/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.update.md;

import java.util.ArrayList;
import java.util.List;
import org.artifactory.repo.InternalRepoPathFactory;
import org.artifactory.repo.RepoPath;
import org.artifactory.update.md.MetadataConverter;
import org.artifactory.util.XmlUtils;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public abstract class MetadataConverterUtils {
    private static final String CREATED_BY = "createdBy";
    private static final String MODIFIED_BY = "modifiedBy";
    private static final String REPO_PATH = "repoPath";
    private static final String REPO_KEY = "repoKey";
    private static final String PATH = "path";
    private static final String NAME = "name";
    private static final String EXTENSION = "extension";
    private static final String REL_PATH = "relPath";
    private static final String[] EXTENSION_FIELDS = new String[]{"lastUpdated", "modifiedBy", "createdBy", "sha1", "md5"};

    private MetadataConverterUtils() {
    }

    public static List<Element> extractExtensionFields(Element rootElement) {
        String modifiedBy = rootElement.getChildText(MODIFIED_BY);
        ArrayList<Element> toMove = new ArrayList<Element>(EXTENSION_FIELDS.length);
        for (String tagName : EXTENSION_FIELDS) {
            Element element = rootElement.getChild(tagName);
            if (element != null) {
                toMove.add(element);
                rootElement.removeChild(tagName);
                continue;
            }
            if (!CREATED_BY.equals(tagName)) continue;
            toMove.add(new Element(CREATED_BY).setText(modifiedBy));
        }
        return toMove;
    }

    public static void addNewContent(Element rootElement, RepoPath repoPath, List<Element> toMove) {
        rootElement.addContent((Content)new Element(NAME).setText(repoPath.getName()));
        rootElement.addContent((Content)new Element(REPO_PATH).addContent((Content)new Element(REPO_KEY).setText(repoPath.getRepoKey())).addContent((Content)new Element(PATH).setText(repoPath.getPath())));
        rootElement.addContent((Content)new Element(EXTENSION).addContent(toMove));
    }

    public static RepoPath extractRepoPath(Element rootElement) {
        String repoKey = rootElement.getChildText(REPO_KEY);
        String relPath = rootElement.getChildText(REL_PATH);
        RepoPath repoPath = InternalRepoPathFactory.create((String)repoKey, (String)relPath);
        rootElement.removeChild(REPO_KEY);
        rootElement.removeChild(REL_PATH);
        return repoPath;
    }

    public static String convertString(MetadataConverter converter, String xmlContent) {
        Document doc = XmlUtils.parse((String)xmlContent);
        converter.convert(doc);
        return XmlUtils.outputString((Document)doc);
    }
}

