/*
 * Decompiled with CFR 0.152.
 */
package org.artifactory.build;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.artifactory.build.Artifact;

public class ArtifactList
implements List<Artifact> {
    private List<org.jfrog.build.api.Artifact> artifactList;

    ArtifactList(List<org.jfrog.build.api.Artifact> artifactList) {
        this.artifactList = artifactList;
    }

    @Override
    public int size() {
        return this.artifactList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.artifactList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.artifactList.contains(((Artifact)o).getBuildArtifact());
    }

    @Override
    @Nonnull
    public Iterator<Artifact> iterator() {
        final Iterator<org.jfrog.build.api.Artifact> iterator = this.artifactList.iterator();
        return new Iterator<Artifact>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Artifact next() {
                return new Artifact((org.jfrog.build.api.Artifact)iterator.next());
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        Object[] array = new Object[this.artifactList.size()];
        for (int i = 0; i < this.artifactList.size(); ++i) {
            array[i] = new Artifact(this.artifactList.get(i));
        }
        return array;
    }

    @Override
    @Nonnull
    public <T> T[] toArray(@Nonnull T[] a) {
        Object[] array = this.toArray();
        for (int i = 0; i < array.length; ++i) {
            a[i] = array[i];
        }
        return a;
    }

    @Override
    public boolean add(Artifact artifact) {
        return this.artifactList.add(artifact.getBuildArtifact());
    }

    @Override
    public boolean remove(Object o) {
        return this.artifactList.remove(((Artifact)o).getBuildArtifact());
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return this.artifactList.containsAll(c.stream().map(input -> ((Artifact)input).getBuildArtifact()).collect(Collectors.toList()));
    }

    @Override
    public boolean addAll(@Nonnull Collection<? extends Artifact> c) {
        return this.artifactList.addAll(c.stream().map(Artifact::getBuildArtifact).collect(Collectors.toList()));
    }

    @Override
    public boolean addAll(int index, @Nonnull Collection<? extends Artifact> c) {
        return this.artifactList.addAll(index, c.stream().map(Artifact::getBuildArtifact).collect(Collectors.toList()));
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        return this.artifactList.removeAll(c.stream().map(input -> ((Artifact)input).getBuildArtifact()).collect(Collectors.toList()));
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.artifactList.retainAll(c.stream().map(input -> ((Artifact)input).getBuildArtifact()).collect(Collectors.toList()));
    }

    @Override
    public void clear() {
        this.artifactList.clear();
    }

    @Override
    public Artifact get(int index) {
        return new Artifact(this.artifactList.get(index));
    }

    @Override
    public Artifact set(int index, Artifact element) {
        org.jfrog.build.api.Artifact artifact = this.artifactList.set(index, element.getBuildArtifact());
        if (artifact == null) {
            return null;
        }
        return new Artifact(artifact);
    }

    @Override
    public void add(int index, Artifact element) {
        this.artifactList.add(index, element.getBuildArtifact());
    }

    @Override
    public Artifact remove(int index) {
        org.jfrog.build.api.Artifact removed = this.artifactList.remove(index);
        if (removed == null) {
            return null;
        }
        return new Artifact(removed);
    }

    @Override
    public int indexOf(Object o) {
        return this.artifactList.indexOf(((Artifact)o).getBuildArtifact());
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.artifactList.lastIndexOf(((Artifact)o).getBuildArtifact());
    }

    @Override
    public ListIterator<Artifact> listIterator() {
        return new ArtifactListIterator(this.artifactList.listIterator());
    }

    @Override
    public ListIterator<Artifact> listIterator(int index) {
        return new ArtifactListIterator(this.artifactList.listIterator(index));
    }

    @Override
    @Nonnull
    public List<Artifact> subList(int fromIndex, int toIndex) {
        return this.artifactList.subList(fromIndex, toIndex).stream().map(Artifact::new).collect(Collectors.toList());
    }

    private class ArtifactListIterator
    implements ListIterator<Artifact> {
        private ListIterator<org.jfrog.build.api.Artifact> artifactListIterator;

        public ArtifactListIterator(ListIterator<org.jfrog.build.api.Artifact> artifactListIterator) {
            this.artifactListIterator = artifactListIterator;
        }

        @Override
        public boolean hasNext() {
            return this.artifactListIterator.hasNext();
        }

        @Override
        public Artifact next() {
            return new Artifact(this.artifactListIterator.next());
        }

        @Override
        public boolean hasPrevious() {
            return this.artifactListIterator.hasPrevious();
        }

        @Override
        public Artifact previous() {
            return new Artifact(this.artifactListIterator.previous());
        }

        @Override
        public int nextIndex() {
            return this.artifactListIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.artifactListIterator.previousIndex();
        }

        @Override
        public void remove() {
            this.artifactListIterator.remove();
        }

        @Override
        public void set(Artifact artifact) {
            this.artifactListIterator.set(artifact.getBuildArtifact());
        }

        @Override
        public void add(Artifact artifact) {
            this.artifactListIterator.add(artifact.getBuildArtifact());
        }
    }
}

