/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.spring.context.impl;

import java.beans.PropertyEditorManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyEditorHelper {
    private static final Log log = LogFactory.getLog(PropertyEditorHelper.class);

    public static void registerCustomEditors() {
        PropertyEditorHelper.registerEditor("java.io.File", "org.apache.xbean.spring.context.impl.FileEditor");
        PropertyEditorHelper.registerEditor("java.net.URI", "org.apache.xbean.spring.context.impl.URIEditor");
        PropertyEditorHelper.registerEditor("java.util.Date", "org.apache.xbean.spring.context.impl.DateEditor");
        PropertyEditorHelper.registerEditor("javax.management.ObjectName", "org.apache.xbean.spring.context.impl.ObjectNameEditor");
    }

    protected static void registerEditor(String typeName, String editorName) {
        Class type = PropertyEditorHelper.loadClass(typeName);
        Class editor = PropertyEditorHelper.loadClass(editorName);
        if (type != null && editor != null) {
            PropertyEditorManager.registerEditor(type, editor);
        }
    }

    public static Class loadClass(String name) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return contextClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
        }
        try {
            return PropertyEditorHelper.class.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)("Could not find class: " + name + " on the classpath"));
            return null;
        }
        catch (NoClassDefFoundError e) {
            log.debug((Object)("Could not load class: " + name + " on the classpath. " + e.getMessage()));
            return null;
        }
    }
}

