/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.utils.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.weex.bridge.ModuleFactory;
import org.apache.weex.bridge.WXModuleManager;
import org.apache.weex.ui.IFComponentHolder;
import org.apache.weex.ui.WXComponentRegistry;
import org.apache.weex.ui.config.AutoScanConfigRegister;
import org.apache.weex.utils.WXLogUtils;

public class RegisterCache {
    private static Map<String, ModuleCache> moduleCacheMap = new ConcurrentHashMap<String, ModuleCache>();
    private static Map<String, ComponentCache> componentCacheMap = new ConcurrentHashMap<String, ComponentCache>();
    private static RegisterCache registerCache;
    private boolean enable = false;
    private boolean enableAutoScan = true;
    private volatile boolean finished = false;
    private volatile int doNotCacheSize = Integer.MAX_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RegisterCache getInstance() {
        if (registerCache != null) return registerCache;
        Class<RegisterCache> clazz = RegisterCache.class;
        synchronized (RegisterCache.class) {
            if (registerCache != null) return registerCache;
            registerCache = new RegisterCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return registerCache;
        }
    }

    private RegisterCache() {
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    private boolean enableCache() {
        return this.enable;
    }

    private boolean canCache() {
        return this.enableCache() && !this.finished && this.getDoNotCacheSize() < 1;
    }

    public boolean enableAutoScan() {
        return this.enableAutoScan;
    }

    public void setEnableAutoScan(boolean enableAutoScan) {
        if (this.enableAutoScan != enableAutoScan) {
            if (enableAutoScan) {
                AutoScanConfigRegister.doScanConfig();
            }
            this.enableAutoScan = enableAutoScan;
        }
    }

    private int getDoNotCacheSize() {
        return this.doNotCacheSize--;
    }

    public void setDoNotCacheSize(int doNotCacheSize) {
        this.doNotCacheSize = doNotCacheSize;
    }

    public boolean idle(boolean atCreateInstance) {
        if (this.finished) {
            return true;
        }
        String message = atCreateInstance ? "idle from create instance" : "idle from external";
        WXLogUtils.e(message + " cache size is " + (moduleCacheMap.size() + componentCacheMap.size()));
        this.finished = true;
        this.CacheComponentRegister();
        this.CacheModuleRegister();
        return true;
    }

    public boolean cacheModule(String moduleName, ModuleFactory factory, boolean global) {
        if (!this.canCache()) {
            return false;
        }
        try {
            moduleCacheMap.put(moduleName, new ModuleCache(moduleName, factory, global));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean cacheComponent(String type, IFComponentHolder holder, Map<String, Object> componentInfo) {
        if (!this.canCache()) {
            return false;
        }
        try {
            componentCacheMap.put(type, new ComponentCache(type, holder, componentInfo));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void CacheComponentRegister() {
        if (componentCacheMap.isEmpty()) {
            return;
        }
        WXComponentRegistry.registerComponent(componentCacheMap);
    }

    private void CacheModuleRegister() {
        if (moduleCacheMap.isEmpty()) {
            return;
        }
        WXModuleManager.registerModule(moduleCacheMap);
    }

    public class ComponentCache {
        public final String type;
        public final IFComponentHolder holder;
        public final Map<String, Object> componentInfo;

        ComponentCache(String type, IFComponentHolder holder, Map<String, Object> componentInfo) {
            this.type = type;
            this.componentInfo = componentInfo;
            this.holder = holder;
        }
    }

    public class ModuleCache {
        public final String name;
        public final ModuleFactory factory;
        public final boolean global;

        ModuleCache(String moduleName, ModuleFactory factory, boolean global) {
            this.name = moduleName;
            this.factory = factory;
            this.global = global;
        }
    }
}

