/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.utils;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.text.TextUtils;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.weex.IWXStatisticsListener;
import org.apache.weex.WXEnvironment;
import org.apache.weex.adapter.IWXSoLoaderAdapter;
import org.apache.weex.adapter.IWXUserTrackAdapter;
import org.apache.weex.common.WXErrorCode;
import org.apache.weex.utils.WXExceptionUtils;
import org.apache.weex.utils.WXFileUtils;
import org.apache.weex.utils.WXLogUtils;
import org.apache.weex.utils.WXUtils;

public class WXSoInstallMgrSdk {
    static final String LOGTAG = "INIT_SO";
    private static final String ARMEABI = "armeabi";
    private static final String X86 = "x86";
    private static final String MIPS = "mips";
    private static final String STARTUPSO = "/libweexjsb.so";
    private static final String STARTUPSOANDROID15 = "/libweexjst.so";
    static Application mContext = null;
    private static IWXSoLoaderAdapter mSoLoader = null;
    private static IWXStatisticsListener mStatisticsListener = null;
    private static String mAbi = null;

    public static void init(Application c, IWXSoLoaderAdapter loader, IWXStatisticsListener listener) {
        mContext = c;
        mSoLoader = loader;
        mStatisticsListener = listener;
    }

    public static boolean isX86() {
        String cpuType = WXSoInstallMgrSdk._cpuType();
        return cpuType.equalsIgnoreCase(X86);
    }

    public static boolean isCPUSupport() {
        String cpuType = WXSoInstallMgrSdk._cpuType();
        return !cpuType.equalsIgnoreCase(MIPS);
    }

    public static boolean initSo(String libName, int version, IWXUserTrackAdapter utAdapter) {
        boolean InitSuc;
        String cpuType;
        block12: {
            cpuType = WXSoInstallMgrSdk._cpuType();
            if (cpuType.equalsIgnoreCase(MIPS)) {
                WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT, "initSo", "[WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT] for android cpuType is MIPS", null);
                return false;
            }
            if ("weexcore".equals(libName)) {
                WXSoInstallMgrSdk.copyStartUpSo();
            }
            InitSuc = false;
            try {
                if (mSoLoader != null) {
                    mSoLoader.doLoadLibrary("c++_shared");
                } else {
                    System.loadLibrary("c++_shared");
                }
            }
            catch (Error | Exception e) {
                WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT, "initSo", "load c++_shared failed Detail Error is: " + e.getMessage(), null);
                if (!WXEnvironment.isApkDebugable()) break block12;
                throw e;
            }
        }
        try {
            if (mSoLoader != null) {
                mSoLoader.doLoadLibrary(libName);
            } else {
                System.loadLibrary(libName);
            }
            InitSuc = true;
        }
        catch (Error | Exception e2) {
            if (cpuType.contains(ARMEABI) || cpuType.contains(X86)) {
                WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT, "initSo", libName + "[WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT] for android cpuType is " + cpuType + "\n Detail Error is: " + e2.getMessage(), null);
            }
            if (WXEnvironment.isApkDebugable()) {
                throw e2;
            }
            InitSuc = false;
        }
        return InitSuc;
    }

    private static File _desSoCopyFile(String soName) {
        String cpuType = WXSoInstallMgrSdk._cpuType();
        String copyPath = WXEnvironment.copySoDesDir();
        if (TextUtils.isEmpty((CharSequence)copyPath)) {
            return null;
        }
        File desDir = new File(copyPath, soName + "/" + cpuType);
        return desDir;
    }

    @SuppressLint(value={"SdCardPath"})
    public static void copyStartUpSo() {
        try {
            File copyPath;
            String pkgName = WXEnvironment.getApplication().getPackageName();
            String cacheFile = WXEnvironment.getApplication().getApplicationContext().getCacheDir().getPath();
            boolean pieSupport = true;
            String startSoName = "weexjsb";
            String startSoPath = STARTUPSO;
            if (Build.VERSION.SDK_INT < 16) {
                pieSupport = false;
                startSoName = "weexjst";
                startSoPath = STARTUPSOANDROID15;
            }
            if (!(copyPath = WXSoInstallMgrSdk._desSoCopyFile(startSoName)).exists()) {
                copyPath.mkdirs();
            }
            File newfile = new File(copyPath, startSoPath);
            WXEnvironment.CORE_JSB_SO_PATH = newfile.getAbsolutePath();
            String jsb = WXEnvironment.getDefaultSettingValue(startSoName, "-1");
            if (newfile.exists() && TextUtils.equals((CharSequence)WXEnvironment.getAppVersionName(), (CharSequence)jsb)) {
                return;
            }
            String path = "/data/data/" + pkgName + "/lib";
            if (cacheFile != null && cacheFile.indexOf("/cache") > 0) {
                path = cacheFile.replace("/cache", "/lib");
            }
            File oldfile = null;
            oldfile = pieSupport ? new File(path, STARTUPSO) : new File(path, STARTUPSOANDROID15);
            if (!oldfile.exists()) {
                try {
                    String weexjsb = ((PathClassLoader)WXSoInstallMgrSdk.class.getClassLoader()).findLibrary(startSoName);
                    oldfile = new File(weexjsb);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!oldfile.exists()) {
                WXEnvironment.extractSo();
                oldfile = new File(copyPath, STARTUPSO);
            }
            if (oldfile.exists()) {
                WXFileUtils.copyFile(oldfile, newfile);
            }
            WXEnvironment.writeDefaultSettingsValue(startSoName, WXEnvironment.getAppVersionName());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void copyJssRuntimeSo() {
        boolean tryUseRunTimeApi = WXUtils.checkGreyConfig("wxapm", "use_runtime_api", "0");
        WXLogUtils.e("weex", "tryUseRunTimeApi ? " + tryUseRunTimeApi);
        if (!tryUseRunTimeApi) {
            return;
        }
        try {
            String fromPath;
            WXLogUtils.e("weex", "copyJssRuntimeSo: ");
            File toPath = WXSoInstallMgrSdk._desSoCopyFile("weexjss");
            if (!toPath.exists()) {
                toPath.mkdirs();
            }
            File targetFile = new File(toPath, "libweexjss.so");
            String keyVersionCode = "app_version_code_weex";
            String defaultSettingValue = WXEnvironment.getDefaultSettingValue(keyVersionCode, "-1");
            if (targetFile.exists()) {
                if (!TextUtils.equals((CharSequence)WXEnvironment.getAppVersionName(), (CharSequence)defaultSettingValue)) {
                    targetFile.delete();
                } else {
                    WXEnvironment.CORE_JSS_SO_PATH = targetFile.getAbsolutePath();
                    WXEnvironment.sUseRunTimeApi = true;
                    WXLogUtils.e("weex", "copyJssRuntimeSo exist:  return");
                    return;
                }
            }
            if (TextUtils.isEmpty((CharSequence)(fromPath = ((PathClassLoader)WXSoInstallMgrSdk.class.getClassLoader()).findLibrary("weexjssr")))) {
                return;
            }
            targetFile.createNewFile();
            WXFileUtils.copyFileWithException(new File(fromPath), targetFile);
            WXEnvironment.CORE_JSS_SO_PATH = targetFile.getAbsolutePath();
            WXEnvironment.writeDefaultSettingsValue(keyVersionCode, WXEnvironment.getAppVersionName());
            WXEnvironment.sUseRunTimeApi = true;
            WXLogUtils.e("weex", "copyJssRuntimeSo: cp end and return ");
        }
        catch (Throwable e) {
            e.printStackTrace();
            WXEnvironment.sUseRunTimeApi = false;
            WXLogUtils.e("weex", "copyJssRuntimeSo:  exception" + e);
        }
    }

    private static String _getFieldReflectively(Build build, String fieldName) {
        try {
            Field field = Build.class.getField(fieldName);
            return field.get(build).toString();
        }
        catch (Exception ex) {
            return "Unknown";
        }
    }

    private static String _cpuType() {
        if (TextUtils.isEmpty((CharSequence)mAbi)) {
            try {
                mAbi = Build.CPU_ABI;
            }
            catch (Throwable e) {
                e.printStackTrace();
                mAbi = ARMEABI;
            }
            if (TextUtils.isEmpty((CharSequence)mAbi)) {
                mAbi = ARMEABI;
            }
            mAbi = mAbi.toLowerCase(Locale.ROOT);
        }
        return mAbi;
    }

    static boolean checkSoIsValid(String libName, long size) {
        Application context = mContext;
        if (null == context) {
            return false;
        }
        try {
            long start = System.currentTimeMillis();
            if (WXSoInstallMgrSdk.class.getClassLoader() instanceof PathClassLoader) {
                String path = ((PathClassLoader)WXSoInstallMgrSdk.class.getClassLoader()).findLibrary(libName);
                if (TextUtils.isEmpty((CharSequence)path)) {
                    return false;
                }
                File file = new File(path);
                if (!file.exists() || size == file.length()) {
                    WXLogUtils.w("weex so size check path :" + path + "   " + (System.currentTimeMillis() - start));
                    return true;
                }
                return false;
            }
        }
        catch (Throwable e) {
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT, "checkSoIsValid", "[WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT] for weex so size check fail exception :" + e.getMessage(), null);
            WXLogUtils.e("weex so size check fail exception :" + e.getMessage());
        }
        return true;
    }

    @SuppressLint(value={"SdCardPath"})
    static String _targetSoFile(String libName, int version) {
        Application context = mContext;
        if (null == context) {
            return "";
        }
        String path = "/data/data/" + context.getPackageName() + "/files";
        File f = context.getFilesDir();
        if (f != null) {
            path = f.getPath();
        }
        return path + "/lib" + libName + "bk" + version + ".so";
    }

    static void removeSoIfExit(String libName, int version) {
        String file = WXSoInstallMgrSdk._targetSoFile(libName, version);
        File a = new File(file);
        if (a.exists()) {
            a.delete();
        }
    }

    static boolean isExist(String libName, int version) {
        String file = WXSoInstallMgrSdk._targetSoFile(libName, version);
        File a = new File(file);
        return a.exists();
    }

    @SuppressLint(value={"UnsafeDynamicallyLoadedCode"})
    static boolean _loadUnzipSo(String libName, int version, IWXUserTrackAdapter utAdapter) {
        boolean initSuc = false;
        try {
            if (WXSoInstallMgrSdk.isExist(libName, version)) {
                if (mSoLoader != null) {
                    mSoLoader.doLoad(WXSoInstallMgrSdk._targetSoFile(libName, version));
                } else {
                    System.load(WXSoInstallMgrSdk._targetSoFile(libName, version));
                }
            }
            initSuc = true;
        }
        catch (Throwable e) {
            initSuc = false;
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT, "_loadUnzipSo", "[WX_KEY_EXCEPTION_SDK_INIT_WX_ERR_COPY_FROM_APK] \n Detail Msg is : " + e.getMessage(), null);
            WXLogUtils.e("", e);
        }
        return initSuc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean unZipSelectedFiles(String libName, int version, IWXUserTrackAdapter utAdapter) throws ZipException, IOException {
        String sourcePath = "lib/armeabi/lib" + libName + ".so";
        String zipPath = "";
        Application context = mContext;
        if (context == null) {
            return false;
        }
        ApplicationInfo aInfo = context.getApplicationInfo();
        if (null != aInfo) {
            zipPath = aInfo.sourceDir;
        }
        ZipFile zf = new ZipFile(zipPath);
        try {
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(sourcePath)) continue;
                InputStream in = null;
                FileOutputStream os = null;
                AbstractInterruptibleChannel channel = null;
                int total = 0;
                try {
                    int realLength;
                    WXSoInstallMgrSdk.removeSoIfExit(libName, version);
                    in = zf.getInputStream(entry);
                    os = context.openFileOutput("lib" + libName + "bk" + version + ".so", 0);
                    channel = os.getChannel();
                    byte[] buffers = new byte[1024];
                    while ((realLength = in.read(buffers)) > 0) {
                        ((FileChannel)channel).write(ByteBuffer.wrap(buffers, 0, realLength));
                        total += realLength;
                    }
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (zf != null) {
                        zf.close();
                        zf = null;
                    }
                }
                if (total > 0) {
                    boolean bl = WXSoInstallMgrSdk._loadUnzipSo(libName, version, utAdapter);
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT_CPU_NOT_SUPPORT, "unZipSelectedFiles", "[WX_KEY_EXCEPTION_SDK_INIT_unZipSelectedFiles] \n Detail msg is: " + e.getMessage(), null);
        }
        finally {
            if (zf != null) {
                zf.close();
                zf = null;
            }
        }
        return false;
    }
}

