/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.utils;

import android.support.annotation.NonNull;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.weex.WXEnvironment;
import org.apache.weex.common.WXRuntimeException;
import org.apache.weex.utils.WXLogUtils;

public class WXJsonUtils {
    @NonNull
    public static <T> List<T> getList(String json, Class<T> clazz) {
        ArrayList result = null;
        try {
            result = JSONObject.parseArray((String)json, clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = new ArrayList();
        }
        return result;
    }

    @NonNull
    public static String fromObjectToJSONString(Object obj, boolean WriteNonStringKeyAsString) {
        try {
            if (WriteNonStringKeyAsString) {
                return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNonStringKeyAsString});
            }
            return JSON.toJSONString((Object)obj);
        }
        catch (Exception e) {
            if (WXEnvironment.isApkDebugable()) {
                throw new WXRuntimeException("fromObjectToJSONString parse error!");
            }
            WXLogUtils.e("fromObjectToJSONString error:", e);
            return "{}";
        }
    }

    @NonNull
    public static String fromObjectToJSONString(Object obj) {
        return WXJsonUtils.fromObjectToJSONString(obj, false);
    }

    public static void putAll(Map<String, Object> container, JSONObject rawValue) {
        for (Map.Entry entry : rawValue.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            container.put(key, value);
        }
    }
}

