/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.weex.utils.WXLogUtils;

public class WXInterception {
    private WXInterception() {
    }

    public static <T> T proxy(Object delegatee, Class<T> interface_class, InterceptionHandler<T> handler) throws IllegalArgumentException {
        if (delegatee instanceof Intercepted) {
            return (T)delegatee;
        }
        handler.setDelegate(delegatee);
        return (T)Proxy.newProxyInstance(WXInterception.class.getClassLoader(), new Class[]{interface_class, Intercepted.class}, handler);
    }

    public static <T> T proxy(Object delegatee, InterceptionHandler<T> handler, Class<?> ... interfaces) throws IllegalArgumentException {
        handler.setDelegate(delegatee);
        return (T)Proxy.newProxyInstance(WXInterception.class.getClassLoader(), interfaces, handler);
    }

    public static abstract class InterceptionHandler<T>
    implements InvocationHandler {
        private T mDelegate;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.delegate(), args);
            }
            catch (IllegalArgumentException e) {
                WXLogUtils.e("", e);
                return null;
            }
            catch (IllegalAccessException e) {
                WXLogUtils.e("", e);
                return null;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        protected T delegate() {
            return this.mDelegate;
        }

        void setDelegate(T delegate) {
            this.mDelegate = delegate;
        }
    }

    private static interface Intercepted {
    }
}

