/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.utils;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.weex.WXEnvironment;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.WXSDKManager;
import org.apache.weex.adapter.IWXConfigAdapter;
import org.apache.weex.adapter.IWXJSExceptionAdapter;
import org.apache.weex.common.WXErrorCode;
import org.apache.weex.common.WXJSExceptionInfo;
import org.apache.weex.performance.WXAnalyzerDataTransfer;
import org.apache.weex.performance.WXStateRecord;
import org.apache.weex.utils.WXLogUtils;
import org.apache.weex.utils.WXUtils;

public class WXExceptionUtils {
    private static Set<String> sGlobalExceptionRecord = new CopyOnWriteArraySet<String>();
    public static String degradeUrl = "BundleUrlDefaultDegradeUrl";

    private static boolean checkNeedReportCauseRepeat(String instanceId, WXErrorCode errCode, String exception) {
        if (TextUtils.isEmpty((CharSequence)exception)) {
            return true;
        }
        if (null != errCode && errCode.getErrorGroup() != WXErrorCode.ErrorGroup.JS) {
            return true;
        }
        if (TextUtils.isEmpty((CharSequence)instanceId)) {
            instanceId = "instanceIdNull";
        }
        String targetException = exception.length() > 200 ? exception.substring(0, 200) : exception;
        Set<String> recordExceptionHistory = null;
        WXSDKInstance instance = WXSDKManager.getInstance().getAllInstanceMap().get(instanceId);
        recordExceptionHistory = null == instance ? sGlobalExceptionRecord : instance.getApmForInstance().exceptionRecord;
        if (null == recordExceptionHistory) {
            return true;
        }
        if (recordExceptionHistory.contains(targetException)) {
            return false;
        }
        recordExceptionHistory.add(targetException);
        return true;
    }

    public static void commitCriticalExceptionRT(@Nullable String instanceId, @Nullable WXErrorCode errCode, @Nullable String function, @Nullable String exception, @Nullable Map<String, String> extParams) {
        try {
            WXLogUtils.e("weex", "commitCriticalExceptionRT :" + (Object)((Object)errCode) + "exception" + exception);
            WXStateRecord.getInstance().recordException(instanceId, exception);
            IWXConfigAdapter configAdapter = WXSDKManager.getInstance().getWxConfigAdapter();
            boolean doCheck = true;
            if (null != configAdapter) {
                String value = configAdapter.getConfig("wxapm", "check_repeat_report", "true");
                doCheck = "true".equalsIgnoreCase(value);
            }
            boolean doReport = true;
            if (doCheck) {
                doReport = WXExceptionUtils.checkNeedReportCauseRepeat(instanceId, errCode, exception);
            }
            if (!doReport) {
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        WXExceptionUtils.commitCriticalExceptionWithDefaultUrl("BundleUrlDefault", instanceId, errCode, function, exception, extParams);
    }

    public static void commitCriticalExceptionWithDefaultUrl(@Nullable String defaultUrl, @Nullable String instanceId, @Nullable WXErrorCode errCode, @Nullable String function, @Nullable String exception, @Nullable Map<String, String> extParams) {
        String illegalValue;
        IWXJSExceptionAdapter adapter = WXSDKManager.getInstance().getIWXJSExceptionAdapter();
        WXSDKInstance instance = null;
        String bundleUrlCommit = TextUtils.isEmpty((CharSequence)defaultUrl) ? "BundleUrlDefault" : defaultUrl;
        String instanceIdCommit = "InstanceIdDefalut";
        String exceptionMsgCommit = exception;
        Map<String, String> commitMap = extParams;
        if (null == commitMap) {
            commitMap = new HashMap<String, String>();
        }
        commitMap.put("wxSdkInitStartTime", String.valueOf(WXEnvironment.sSDKInitStart));
        commitMap.put("wxSDKInitCostTime", String.valueOf(WXEnvironment.sSDKInitTime));
        commitMap.put("wxSDKCurExceptionTime", String.valueOf(System.currentTimeMillis()));
        commitMap.put("wxUseRuntimeApi", String.valueOf(WXEnvironment.sUseRunTimeApi));
        if (!TextUtils.isEmpty((CharSequence)instanceId)) {
            instanceIdCommit = instanceId;
            instance = WXSDKManager.getInstance().getAllInstanceMap().get(instanceId);
            if (null != instance) {
                bundleUrlCommit = instance.getApmForInstance().reportPageName;
                Object loadLength = instance.getApmForInstance().extInfo.get("wxLoadedLength");
                String loadLengthStr = loadLength instanceof Integer ? String.valueOf(loadLength) : "unknownLength";
                commitMap.put("wxLoadedLength", loadLengthStr);
                commitMap.put("templateInfo", instance.getTemplateInfo());
                if (TextUtils.isEmpty((CharSequence)bundleUrlCommit) || bundleUrlCommit.equals("default")) {
                    bundleUrlCommit = !TextUtils.equals((CharSequence)degradeUrl, (CharSequence)"BundleUrlDefaultDegradeUrl") ? degradeUrl : WXSDKInstance.requestUrl;
                }
                for (Map.Entry<String, String> entry : instance.getContainerInfo().entrySet()) {
                    commitMap.put(entry.getKey(), entry.getValue());
                }
                commitMap.put("wxStageList", WXExceptionUtils.convertStageToStr(instance));
                String bundleTemplate = instance.getTemplate();
                if (null == bundleTemplate) {
                    bundleTemplate = "has recycle by gc";
                } else {
                    int length = bundleTemplate.length();
                    bundleTemplate = bundleTemplate.substring(0, Math.min(length, 300));
                }
                commitMap.put("wxTemplateOfBundle", bundleTemplate);
                Long pageStartTime = instance.getApmForInstance().stageMap.get("wxStartDownLoadBundle");
                if (null == pageStartTime) {
                    pageStartTime = instance.getApmForInstance().stageMap.get("wxRenderTimeOrigin");
                }
                if (null != pageStartTime) {
                    commitMap.put("wxUseTime", String.valueOf(WXUtils.getFixUnixTime() - pageStartTime));
                }
            }
        } else if (commitMap.size() > 0) {
            String string2 = bundleUrlCommit = TextUtils.isEmpty((CharSequence)commitMap.get("weexUrl")) ? commitMap.get("weexUrl") : commitMap.get("bundleUrl");
        }
        if (null != (illegalValue = commitMap.get("errorCode")) && illegalValue.length() > 200) {
            commitMap.remove("errorCode");
        }
        WXJSExceptionInfo exceptionCommit = new WXJSExceptionInfo(instanceIdCommit, bundleUrlCommit, errCode, function, exceptionMsgCommit, commitMap);
        if (adapter != null) {
            adapter.onJSException(exceptionCommit);
        }
        WXAnalyzerDataTransfer.transferError(exceptionCommit, instanceId);
    }

    private static String convertStageToStr(WXSDKInstance instance) {
        if (null == instance || null == instance.getApmForInstance() || instance.getApmForInstance().stageMap.isEmpty()) {
            return "noStageRecord";
        }
        ArrayList<Map.Entry<String, Long>> list = new ArrayList<Map.Entry<String, Long>>(instance.getApmForInstance().stageMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return (int)(o1.getValue() - o2.getValue());
            }
        });
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : list) {
            builder.append((String)entry.getKey()).append(':').append(entry.getValue()).append("->");
        }
        return builder.toString();
    }
}

