/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.utils;

import android.annotation.TargetApi;
import android.util.Log;
import org.apache.weex.utils.OsVersion;

public class Trace {
    private static final String TAG = "Weex_Trace";
    private static final AbstractTrace sTrace;
    private static final boolean sEnabled;

    public static final boolean getTraceEnabled() {
        return sEnabled;
    }

    public static void beginSection(String sectionName) {
        Log.i((String)TAG, (String)("beginSection() " + sectionName));
        sTrace.beginSection(sectionName);
    }

    public static void endSection() {
        sTrace.endSection();
        Log.i((String)TAG, (String)"endSection()");
    }

    static {
        sEnabled = false;
        sTrace = sEnabled && OsVersion.isAtLeastJB_MR2() ? new TraceJBMR2() : new TraceDummy();
    }

    private static final class TraceDummy
    extends AbstractTrace {
        private TraceDummy() {
        }

        @Override
        void beginSection(String sectionName) {
        }

        @Override
        void endSection() {
        }
    }

    @TargetApi(value=18)
    private static final class TraceJBMR2
    extends AbstractTrace {
        private TraceJBMR2() {
        }

        @Override
        void beginSection(String sectionName) {
            android.os.Trace.beginSection((String)sectionName);
        }

        @Override
        void endSection() {
            android.os.Trace.endSection();
        }
    }

    private static abstract class AbstractTrace {
        private AbstractTrace() {
        }

        abstract void beginSection(String var1);

        abstract void endSection();
    }
}

