/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.utils;

import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextDirectionHeuristic;
import android.text.TextDirectionHeuristics;
import android.text.TextPaint;
import java.lang.reflect.Constructor;

public class StaticLayoutProxy {
    private static Constructor<StaticLayout> layoutConstructor;

    public static StaticLayout create(CharSequence source, TextPaint paint, int width, Layout.Alignment align, float spacingmult, float spacingadd, boolean includepad, boolean forceRtl) {
        if (Build.VERSION.SDK_INT >= 18 && forceRtl) {
            TextDirectionHeuristic textDir = TextDirectionHeuristics.RTL;
            StaticLayout rtlLayout = StaticLayoutProxy.createInternal(source, paint, width, align, textDir, spacingmult, spacingadd, includepad);
            if (rtlLayout != null) {
                return rtlLayout;
            }
            return new StaticLayout(source, paint, width, align, spacingmult, spacingadd, includepad);
        }
        return new StaticLayout(source, paint, width, align, spacingmult, spacingadd, includepad);
    }

    private static StaticLayout createInternal(CharSequence source, TextPaint paint, int width, Layout.Alignment align, TextDirectionHeuristic textDir, float spacingmult, float spacingadd, boolean includepad) {
        if (Build.VERSION.SDK_INT < 18) {
            return null;
        }
        try {
            if (layoutConstructor == null) {
                Class<StaticLayout> clazz = StaticLayout.class;
                Constructor constructor = clazz.getConstructor(CharSequence.class, TextPaint.class, Integer.TYPE, Layout.Alignment.class, TextDirectionHeuristic.class, Float.TYPE, Float.TYPE, Boolean.TYPE);
                layoutConstructor = constructor;
            }
            if (layoutConstructor != null) {
                return layoutConstructor.newInstance(source, paint, width, align, textDir, Float.valueOf(spacingmult), Float.valueOf(spacingadd), includepad);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }
}

