/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.utils;

import android.content.Context;
import android.graphics.Typeface;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import java.io.File;
import org.apache.weex.WXEnvironment;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.utils.WXFileUtils;
import org.apache.weex.utils.WXLogUtils;

public class FontDO {
    private final String mFontFamilyName;
    private String mUrl = "";
    private String mFilePath;
    private int mType = 1;
    private Typeface mTypeface;
    private int mState = -1;
    public static final int STATE_INVALID = -1;
    public static final int STATE_INIT = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_SUCCESS = 2;
    public static final int STATE_FAILED = 3;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_NETWORK = 1;
    public static final int TYPE_FILE = 2;
    public static final int TYPE_LOCAL = 3;
    public static final int TYPE_NATIVE = 4;
    public static final int TYPE_BASE64 = 5;

    public FontDO(String fontFamilyName, String src, WXSDKInstance instance) {
        this.mFontFamilyName = fontFamilyName;
        this.parseSrc(src, instance);
    }

    public FontDO(String fontFamilyName, Typeface typeface) {
        this.mFontFamilyName = fontFamilyName;
        this.mTypeface = typeface;
        this.mType = 4;
        this.mState = 2;
    }

    public String getFontFamilyName() {
        return this.mFontFamilyName;
    }

    private void parseSrc(String src, WXSDKInstance instance) {
        String localUrl;
        String string2 = src = src != null ? src.trim() : "";
        if (instance != null && instance.getCustomFontNetworkHandler() != null && !TextUtils.isEmpty((CharSequence)(localUrl = instance.getCustomFontNetworkHandler().fetchLocal(src)))) {
            src = localUrl;
        }
        if (src.isEmpty()) {
            this.mState = -1;
            WXLogUtils.e("TypefaceUtil", "font src is empty.");
            return;
        }
        if (src.matches("^url\\((('.*')|(\".*\"))\\)$")) {
            String url = src.substring(5, src.length() - 2);
            Uri uri = Uri.parse((String)url);
            if (instance != null) {
                uri = instance.rewriteUri(uri, "font");
            }
            this.mUrl = uri.toString();
            try {
                String scheme = uri.getScheme();
                if ("http".equals(scheme) || "https".equals(scheme)) {
                    this.mType = 1;
                } else if ("file".equals(scheme)) {
                    this.mType = 2;
                    this.mUrl = uri.getEncodedSchemeSpecificPart();
                } else if ("local".equals(scheme)) {
                    this.mType = 3;
                } else if ("data".equals(scheme)) {
                    String base64Data;
                    String identify;
                    long start = System.currentTimeMillis();
                    String[] data = this.mUrl.split(",");
                    if (data != null && data.length == 2 && !TextUtils.isEmpty((CharSequence)(identify = data[0])) && identify.endsWith("base64") && !TextUtils.isEmpty((CharSequence)(base64Data = data[1]))) {
                        File tmpFile;
                        String md5 = WXFileUtils.md5(base64Data);
                        File cacheDir = new File(WXEnvironment.getApplication().getCacheDir(), "font-family");
                        if (!cacheDir.exists()) {
                            cacheDir.mkdirs();
                        }
                        if (!(tmpFile = new File(cacheDir, md5)).exists()) {
                            tmpFile.createNewFile();
                            WXFileUtils.saveFile(tmpFile.getPath(), Base64.decode((String)base64Data, (int)0), (Context)WXEnvironment.getApplication());
                        }
                        this.mUrl = tmpFile.getPath();
                        this.mType = 5;
                        WXLogUtils.d("TypefaceUtil", "Parse base64 font cost " + (System.currentTimeMillis() - start) + " ms");
                    }
                } else {
                    WXLogUtils.e("TypefaceUtil", "Unknown scheme for font url: " + this.mUrl);
                    this.mType = 0;
                }
                this.mState = 0;
            }
            catch (Exception e) {
                this.mType = -1;
                WXLogUtils.e("TypefaceUtil", "URI.create(mUrl) failed mUrl: " + this.mUrl + "\n" + WXLogUtils.getStackTrace(e));
            }
        } else {
            this.mUrl = src;
            this.mState = -1;
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("TypefaceUtil", "src:" + src + ", mUrl:" + this.mUrl + ", mType:" + this.mType);
        }
    }

    public String getUrl() {
        return this.mUrl;
    }

    public int getType() {
        return this.mType;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public void setTypeface(Typeface typeface) {
        this.mTypeface = typeface;
    }

    public int getState() {
        return this.mState;
    }

    public void setState(int state) {
        this.mState = state;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    public void setFilePath(String mFilePath) {
        this.mFilePath = mFilePath;
    }
}

