/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.view.border;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import org.apache.weex.dom.CSSShorthand;
import org.apache.weex.ui.view.border.BorderCorner;

class BorderEdge {
    @NonNull
    private BorderCorner mPreCorner;
    @NonNull
    private BorderCorner mPostCorner;
    private CSSShorthand.EDGE mEdge;
    private float mBorderWidth;

    BorderEdge() {
    }

    BorderEdge set(@NonNull BorderCorner preCorner, @NonNull BorderCorner postCorner, float borderWidth, CSSShorthand.EDGE edge) {
        this.mPreCorner = preCorner;
        this.mPostCorner = postCorner;
        this.mBorderWidth = borderWidth;
        this.mEdge = edge;
        return this;
    }

    void drawEdge(@NonNull Canvas canvas, @NonNull Paint paint) {
        paint.setStrokeWidth(this.mBorderWidth);
        this.mPreCorner.drawRoundedCorner(canvas, paint, this.mPreCorner.getAngleBisectorDegree());
        paint.setStrokeWidth(this.mBorderWidth);
        float lineStartX = this.mPreCorner.getRoundCornerEndX();
        float lineStartY = this.mPreCorner.getRoundCornerEndY();
        float lineEndX = this.mPostCorner.getRoundCornerStartX();
        float lineEndY = this.mPostCorner.getRoundCornerStartY();
        canvas.drawLine(lineStartX, lineStartY, lineEndX, lineEndY, paint);
        this.mPostCorner.drawRoundedCorner(canvas, paint, this.mPostCorner.getAngleBisectorDegree() - 45.0f);
    }

    public CSSShorthand.EDGE getEdge() {
        return this.mEdge;
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }
}

