/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.view.border;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseIntArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.weex.dom.CSSShorthand;
import org.apache.weex.ui.view.border.BorderEdge;
import org.apache.weex.ui.view.border.BorderStyle;
import org.apache.weex.ui.view.border.BorderUtil;
import org.apache.weex.ui.view.border.BottomLeftCorner;
import org.apache.weex.ui.view.border.BottomRightCorner;
import org.apache.weex.ui.view.border.TopLeftCorner;
import org.apache.weex.ui.view.border.TopRightCorner;
import org.apache.weex.utils.WXLogUtils;
import org.apache.weex.utils.WXViewUtils;

public class BorderDrawable
extends Drawable {
    public static final int BORDER_TOP_LEFT_RADIUS = 0;
    public static final int BORDER_TOP_RIGHT_RADIUS = 1;
    public static final int BORDER_BOTTOM_RIGHT_RADIUS = 2;
    public static final int BORDER_BOTTOM_LEFT_RADIUS = 3;
    public static final int BORDER_RADIUS_ALL = 5;
    static final int DEFAULT_BORDER_COLOR = -16777216;
    static final float DEFAULT_BORDER_WIDTH = 0.0f;
    private static final BorderStyle DEFAULT_BORDER_STYLE = BorderStyle.SOLID;
    private static final String TAG = "Border";
    private final Paint mPaint = new Paint(1);
    private static BorderStyle[] sBorderStyle = BorderStyle.values();
    @Nullable
    private CSSShorthand<CSSShorthand.EDGE> mBorderWidth;
    @Nullable
    private CSSShorthand<CSSShorthand.CORNER> mBorderRadius;
    @Nullable
    private CSSShorthand<CSSShorthand.CORNER> mOverlappingBorderRadius;
    @Nullable
    private SparseIntArray mBorderColor;
    @Nullable
    private SparseIntArray mBorderStyle;
    @Nullable
    private Path mPathForBorderOutline;
    private boolean mNeedUpdatePath = false;
    private int mColor = 0;
    private Shader mShader = null;
    private int mAlpha = 255;
    private TopLeftCorner mTopLeftCorner;
    private TopRightCorner mTopRightCorner;
    private BottomRightCorner mBottomRightCorner;
    private BottomLeftCorner mBottomLeftCorner;
    private final BorderEdge mBorderEdge = new BorderEdge();
    private RectF mRectBounds;

    public void draw(@NonNull Canvas canvas) {
        canvas.save();
        this.updateBorderOutline();
        this.mPaint.setAlpha(255);
        if (this.mPathForBorderOutline != null) {
            int useColor = WXViewUtils.multiplyColorAlpha(this.mColor, this.mAlpha);
            if (this.mShader != null) {
                this.mPaint.setShader(this.mShader);
                this.mPaint.setStyle(Paint.Style.FILL);
                canvas.drawPath(this.mPathForBorderOutline, this.mPaint);
                this.mPaint.setShader(null);
            } else if (useColor >>> 24 != 0) {
                this.mPaint.setColor(useColor);
                this.mPaint.setStyle(Paint.Style.FILL);
                canvas.drawPath(this.mPathForBorderOutline, this.mPaint);
                this.mPaint.setShader(null);
            }
        }
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.drawBorders(canvas);
        this.mPaint.setShader(null);
        canvas.restore();
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.mNeedUpdatePath = true;
    }

    public void setAlpha(int alpha) {
        if (alpha != this.mAlpha) {
            this.mAlpha = alpha;
            this.invalidateSelf();
        }
    }

    public int getAlpha() {
        return this.mAlpha;
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return this.mShader != null ? -1 : WXViewUtils.getOpacityFromColor(WXViewUtils.multiplyColorAlpha(this.mColor, this.mAlpha));
    }

    public void getOutline(@NonNull Outline outline) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (this.mPathForBorderOutline == null) {
                this.mNeedUpdatePath = true;
            }
            this.updateBorderOutline();
            outline.setConvexPath(this.mPathForBorderOutline);
        }
    }

    public void setBorderWidth(CSSShorthand.EDGE edge, float width) {
        if (this.mBorderWidth == null) {
            this.mBorderWidth = new CSSShorthand();
        }
        if (this.mBorderWidth.get(edge) != width) {
            this.mBorderWidth.set(edge, width);
            this.mNeedUpdatePath = true;
            this.invalidateSelf();
        }
    }

    float getBorderWidth(CSSShorthand.EDGE edge) {
        return this.mBorderWidth.get(edge);
    }

    public void setBorderRadius(CSSShorthand.CORNER position, float radius) {
        if (this.mBorderRadius == null) {
            this.mBorderRadius = new CSSShorthand();
        }
        if (this.mBorderRadius.get(position) != radius || position == CSSShorthand.CORNER.ALL && (radius != this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT) || radius != this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT) || radius != this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT) || radius != this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT))) {
            this.mBorderRadius.set(position, radius);
            this.mNeedUpdatePath = true;
            this.invalidateSelf();
        }
    }

    @NonNull
    public float[] getBorderRadius(RectF borderBox) {
        this.prepareBorderRadius(borderBox);
        if (this.mOverlappingBorderRadius == null) {
            this.mOverlappingBorderRadius = new CSSShorthand();
        }
        float topLeftRadius = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT);
        float topRightRadius = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT);
        float bottomRightRadius = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT);
        float bottomLeftRadius = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT);
        return new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius};
    }

    @NonNull
    public float[] getBorderInnerRadius(RectF borderBox) {
        this.prepareBorderRadius(borderBox);
        if (this.mOverlappingBorderRadius == null) {
            this.mOverlappingBorderRadius = new CSSShorthand();
        }
        float topLeftRadius = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT);
        float topRightRadius = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT);
        float bottomRightRadius = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT);
        float bottomLeftRadius = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT);
        if (null != this.mBorderWidth) {
            topLeftRadius = Math.max(topLeftRadius - this.mBorderWidth.get(CSSShorthand.EDGE.TOP), 0.0f);
            topRightRadius = Math.max(topRightRadius - this.mBorderWidth.get(CSSShorthand.EDGE.TOP), 0.0f);
            bottomRightRadius = Math.max(bottomRightRadius - this.mBorderWidth.get(CSSShorthand.EDGE.BOTTOM), 0.0f);
            bottomLeftRadius = Math.max(bottomLeftRadius - this.mBorderWidth.get(CSSShorthand.EDGE.BOTTOM), 0.0f);
        }
        return new float[]{topLeftRadius, topLeftRadius, topRightRadius, topRightRadius, bottomRightRadius, bottomRightRadius, bottomLeftRadius, bottomLeftRadius};
    }

    public void setBorderColor(CSSShorthand.EDGE edge, int color) {
        if (this.mBorderColor == null) {
            this.mBorderColor = new SparseIntArray(5);
            this.mBorderColor.put(CSSShorthand.EDGE.ALL.ordinal(), -16777216);
        }
        if (this.getBorderColor(edge) != color) {
            BorderUtil.updateSparseArray(this.mBorderColor, edge.ordinal(), color);
            this.invalidateSelf();
        }
    }

    int getBorderColor(CSSShorthand.EDGE edge) {
        return BorderUtil.fetchFromSparseArray(this.mBorderColor, edge.ordinal(), -16777216);
    }

    public void setBorderStyle(CSSShorthand.EDGE edge, @NonNull String style) {
        if (this.mBorderStyle == null) {
            this.mBorderStyle = new SparseIntArray(5);
            this.mBorderStyle.put(CSSShorthand.EDGE.ALL.ordinal(), DEFAULT_BORDER_STYLE.ordinal());
        }
        try {
            int borderStyle = BorderStyle.valueOf(style.toUpperCase(Locale.US)).ordinal();
            if (this.getBorderStyle(edge) != borderStyle) {
                BorderUtil.updateSparseArray(this.mBorderStyle, edge.ordinal(), borderStyle);
                this.invalidateSelf();
            }
        }
        catch (IllegalArgumentException e) {
            WXLogUtils.e(TAG, WXLogUtils.getStackTrace(e));
        }
    }

    int getBorderStyle(CSSShorthand.EDGE edge) {
        return BorderUtil.fetchFromSparseArray(this.mBorderStyle, edge.ordinal(), BorderStyle.SOLID.ordinal());
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int color) {
        this.mColor = color;
        this.invalidateSelf();
    }

    public void setImage(Shader shader) {
        this.mShader = shader;
        this.invalidateSelf();
    }

    public boolean hasImage() {
        return this.mShader != null;
    }

    public boolean isRounded() {
        return this.mBorderRadius != null && (this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT) != 0.0f || this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT) != 0.0f || this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT) != 0.0f || this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT) != 0.0f);
    }

    @NonNull
    public Path getContentPath(@NonNull RectF borderBox) {
        Path contentClip = new Path();
        this.prepareBorderPath(0, 0, 0, 0, borderBox, contentClip);
        return contentClip;
    }

    private void updateBorderOutline() {
        if (this.mNeedUpdatePath) {
            this.mNeedUpdatePath = false;
            if (this.mPathForBorderOutline == null) {
                this.mPathForBorderOutline = new Path();
            }
            this.mPathForBorderOutline.reset();
            this.prepareBorderPath(0, 0, 0, 0, new RectF(this.getBounds()), this.mPathForBorderOutline);
        }
    }

    private void prepareBorderPath(int topPadding, int rightPadding, int bottomPadding, int leftPadding, @NonNull RectF rectF, @NonNull Path path) {
        if (this.mBorderRadius != null) {
            this.prepareBorderRadius(rectF);
            if (this.mOverlappingBorderRadius == null) {
                this.mOverlappingBorderRadius = new CSSShorthand();
            }
            float topLeftRadius = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT);
            float topRightRadius = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT);
            float bottomRightRadius = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT);
            float bottomLeftRadius = this.mOverlappingBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT);
            path.addRoundRect(rectF, new float[]{topLeftRadius - (float)leftPadding, topLeftRadius - (float)topPadding, topRightRadius - (float)rightPadding, topRightRadius - (float)topPadding, bottomRightRadius - (float)rightPadding, bottomRightRadius - (float)bottomPadding, bottomLeftRadius - (float)leftPadding, bottomLeftRadius - (float)bottomPadding}, Path.Direction.CW);
        } else {
            path.addRect(rectF, Path.Direction.CW);
        }
    }

    private void prepareBorderRadius(@NonNull RectF borderBox) {
        if (this.mBorderRadius != null) {
            float factor = this.getScaleFactor(borderBox);
            if (this.mOverlappingBorderRadius == null) {
                this.mOverlappingBorderRadius = new CSSShorthand();
            }
            if (!Float.isNaN(factor) && factor < 1.0f) {
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_TOP_LEFT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT) * factor);
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_TOP_RIGHT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT) * factor);
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT) * factor);
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT) * factor);
            } else {
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_TOP_LEFT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT));
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_TOP_RIGHT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT));
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT));
                this.mOverlappingBorderRadius.set(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT, this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT));
            }
        }
    }

    private float getScaleFactor(@NonNull RectF borderBox) {
        float topRadius = this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT) + this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT);
        float rightRadius = this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_RIGHT) + this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT);
        float bottomRadius = this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT) + this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT);
        float leftRadius = this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT) + this.mBorderRadius.get(CSSShorthand.CORNER.BORDER_TOP_LEFT);
        ArrayList<Float> factors = new ArrayList<Float>(4);
        this.updateFactor(factors, borderBox.width(), topRadius);
        this.updateFactor(factors, borderBox.height(), rightRadius);
        this.updateFactor(factors, borderBox.width(), bottomRadius);
        this.updateFactor(factors, borderBox.height(), leftRadius);
        float factor = factors.isEmpty() ? Float.NaN : Collections.min(factors).floatValue();
        return factor;
    }

    private void updateFactor(@NonNull List<Float> list, float numerator, float denominator) {
        if (denominator != 0.0f) {
            list.add(Float.valueOf(numerator / denominator));
        }
    }

    private void drawBorders(Canvas canvas) {
        if (this.mRectBounds == null) {
            this.mRectBounds = new RectF(this.getBounds());
        } else {
            this.mRectBounds.set(this.getBounds());
        }
        if (this.mBorderWidth == null) {
            return;
        }
        float leftBorderWidth = this.mBorderWidth.get(CSSShorthand.EDGE.LEFT);
        float topBorderWidth = this.mBorderWidth.get(CSSShorthand.EDGE.TOP);
        float bottomBorderWidth = this.mBorderWidth.get(CSSShorthand.EDGE.BOTTOM);
        float rightBorderWidth = this.mBorderWidth.get(CSSShorthand.EDGE.RIGHT);
        if (this.mTopLeftCorner == null) {
            this.mTopLeftCorner = new TopLeftCorner();
        }
        this.mTopLeftCorner.set(this.getBorderRadius(CSSShorthand.CORNER.BORDER_TOP_LEFT), leftBorderWidth, topBorderWidth, this.mRectBounds);
        if (this.mTopRightCorner == null) {
            this.mTopRightCorner = new TopRightCorner();
        }
        this.mTopRightCorner.set(this.getBorderRadius(CSSShorthand.CORNER.BORDER_TOP_RIGHT), topBorderWidth, rightBorderWidth, this.mRectBounds);
        if (this.mBottomRightCorner == null) {
            this.mBottomRightCorner = new BottomRightCorner();
        }
        this.mBottomRightCorner.set(this.getBorderRadius(CSSShorthand.CORNER.BORDER_BOTTOM_RIGHT), rightBorderWidth, bottomBorderWidth, this.mRectBounds);
        if (this.mBottomLeftCorner == null) {
            this.mBottomLeftCorner = new BottomLeftCorner();
        }
        this.mBottomLeftCorner.set(this.getBorderRadius(CSSShorthand.CORNER.BORDER_BOTTOM_LEFT), bottomBorderWidth, leftBorderWidth, this.mRectBounds);
        this.drawOneSide(canvas, this.mBorderEdge.set(this.mTopLeftCorner, this.mTopRightCorner, topBorderWidth, CSSShorthand.EDGE.TOP));
        this.drawOneSide(canvas, this.mBorderEdge.set(this.mTopRightCorner, this.mBottomRightCorner, rightBorderWidth, CSSShorthand.EDGE.RIGHT));
        this.drawOneSide(canvas, this.mBorderEdge.set(this.mBottomRightCorner, this.mBottomLeftCorner, bottomBorderWidth, CSSShorthand.EDGE.BOTTOM));
        this.drawOneSide(canvas, this.mBorderEdge.set(this.mBottomLeftCorner, this.mTopLeftCorner, leftBorderWidth, CSSShorthand.EDGE.LEFT));
    }

    private float getBorderRadius(CSSShorthand.CORNER position) {
        if (null != this.mOverlappingBorderRadius) {
            return this.mOverlappingBorderRadius.get(position);
        }
        return 0.0f;
    }

    private void drawOneSide(Canvas canvas, @NonNull BorderEdge borderEdge) {
        if (0.0f != borderEdge.getBorderWidth()) {
            this.preparePaint(borderEdge.getEdge());
            borderEdge.drawEdge(canvas, this.mPaint);
        }
    }

    private void preparePaint(CSSShorthand.EDGE edge) {
        float borderWidth = this.mBorderWidth.get(edge);
        int color = WXViewUtils.multiplyColorAlpha(this.getBorderColor(edge), this.mAlpha);
        BorderStyle borderStyle = sBorderStyle[this.getBorderStyle(edge)];
        Shader shader = borderStyle.getLineShader(borderWidth, color, edge);
        this.mPaint.setShader(shader);
        this.mPaint.setColor(color);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
    }
}

