/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.module;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.text.TextUtils;
import android.widget.Toast;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import org.apache.weex.WXEnvironment;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.WXSDKManager;
import org.apache.weex.annotation.JSMethod;
import org.apache.weex.bridge.JSCallback;
import org.apache.weex.common.WXModule;
import org.apache.weex.utils.WXLogUtils;
import org.apache.weex.utils.WXUtils;
import org.apache.weex.utils.WXViewUtils;

public class WXMetaModule
extends WXModule {
    public static final String WIDTH = "width";
    public static final String DEVICE_WIDTH = "device-width";

    @JSMethod(uiThread=false)
    public void setViewport(String param) {
        if (!TextUtils.isEmpty((CharSequence)param)) {
            try {
                param = URLDecoder.decode(param, "utf-8");
                JSONObject jsObj = JSON.parseObject((String)param);
                Context cxt = this.mWXSDKInstance.getContext();
                if (DEVICE_WIDTH.endsWith(jsObj.getString(WIDTH))) {
                    int width = (int)((float)WXViewUtils.getScreenWidth(cxt) / WXViewUtils.getScreenDensity(cxt));
                    this.mWXSDKInstance.setInstanceViewPortWidth(width, true);
                    WXLogUtils.d("[WXMetaModule] setViewport success[device-width]=" + width);
                } else {
                    int width = jsObj.getInteger(WIDTH);
                    if (width > 0) {
                        this.mWXSDKInstance.setInstanceViewPortWidth(width, true);
                    }
                    WXLogUtils.d("[WXMetaModule] setViewport success[width]=" + width);
                }
            }
            catch (Exception e) {
                WXLogUtils.e("[WXMetaModule] alert param parse error ", e);
            }
        }
    }

    @JSMethod(uiThread=true)
    public void openLog(String open) {
        Application application = WXEnvironment.getApplication();
        if (application == null) {
            return;
        }
        ApplicationInfo info = application.getApplicationInfo();
        if ((info.flags & 2) != 0) {
            if (WXUtils.getBoolean(open, true).booleanValue()) {
                WXEnvironment.setApkDebugable(true);
                if (this.mWXSDKInstance != null) {
                    Toast.makeText((Context)this.mWXSDKInstance.getContext(), (CharSequence)"log open success", (int)0).show();
                }
            } else {
                WXEnvironment.setApkDebugable(false);
                if (this.mWXSDKInstance != null) {
                    Toast.makeText((Context)this.mWXSDKInstance.getContext(), (CharSequence)"log close success", (int)0).show();
                }
            }
        }
    }

    @JSMethod(uiThread=false)
    public void getPageInfo(JSCallback callback) {
        if (callback == null) {
            return;
        }
        List<WXSDKInstance> instances = WXSDKManager.getInstance().getWXRenderManager().getAllInstances();
        HashMap<String, String> map = new HashMap<String, String>(4);
        for (WXSDKInstance instance : instances) {
            if (TextUtils.isEmpty((CharSequence)instance.getBundleUrl())) continue;
            map.put(instance.getBundleUrl(), instance.getTemplateInfo());
        }
        callback.invoke(map);
    }
}

