/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.flat;

import android.support.annotation.RestrictTo;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import java.util.LinkedList;
import java.util.List;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.ui.action.BasicComponentData;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.ui.component.WXVContainer;
import org.apache.weex.ui.flat.FlatComponent;
import org.apache.weex.ui.flat.FlatGUIContext;
import org.apache.weex.ui.flat.widget.AndroidViewWidget;
import org.apache.weex.ui.flat.widget.Widget;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public abstract class WidgetContainer<T extends ViewGroup>
extends WXVContainer<T> {
    protected List<Widget> widgets;

    public WidgetContainer(WXSDKInstance instance, WXVContainer parent, BasicComponentData basicComponentData) {
        super(instance, parent, basicComponentData);
    }

    protected abstract void mountFlatGUI();

    protected abstract void unmountFlatGUI();

    public boolean intendToBeFlatContainer() {
        return false;
    }

    @Override
    public void createChildViewAt(int index) {
        if (this.intendToBeFlatContainer()) {
            Pair<WXComponent, Integer> ret = this.rearrangeIndexAndGetChild(index);
            if (ret.first != null) {
                AndroidViewWidget flatChild;
                WXComponent child = (WXComponent)ret.first;
                FlatGUIContext uiImp = this.getInstance().getFlatUIContext();
                WidgetContainer parent = uiImp.getFlatComponentAncestor(this);
                if (parent == null || uiImp.getAndroidViewWidget(this) != null) {
                    parent = this;
                }
                uiImp.register(child, parent);
                if (child instanceof FlatComponent && !((FlatComponent)((Object)child)).promoteToView(false)) {
                    flatChild = ((FlatComponent)((Object)child)).getOrCreateFlatWidget();
                } else {
                    flatChild = new AndroidViewWidget(uiImp);
                    uiImp.register(child, flatChild);
                    child.createView();
                    flatChild.setContentView((View)child.getHostView());
                    parent.addSubView((View)child.getHostView(), -1);
                }
                uiImp.register(flatChild, child);
                this.addFlatChild(flatChild, (Integer)ret.second);
            }
        } else {
            super.createChildViewAt(index);
        }
    }

    private void addFlatChild(Widget widget, int index) {
        if (this.widgets == null) {
            this.widgets = new LinkedList<Widget>();
        }
        if (index >= this.widgets.size()) {
            this.widgets.add(widget);
        } else {
            this.widgets.add(index, widget);
        }
        this.mountFlatGUI();
    }
}

