/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.component.richtext.node;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import org.apache.weex.ui.component.richtext.node.ANode;
import org.apache.weex.ui.component.richtext.node.ImgNode;
import org.apache.weex.ui.component.richtext.node.RichTextNode;
import org.apache.weex.ui.component.richtext.node.RichTextNodeCreator;
import org.apache.weex.ui.component.richtext.node.SpanNode;
import org.apache.weex.utils.WXLogUtils;

public class RichTextNodeManager {
    private static final Map<String, RichTextNodeCreator> registeredTextNodes = new ArrayMap();

    public static void registerTextNode(String text, RichTextNodeCreator type) {
        registeredTextNodes.put(text, type);
    }

    @Nullable
    static RichTextNode createRichTextNode(@NonNull Context context, @NonNull String instanceId, @NonNull String componentRef, @Nullable JSONObject jsonObject) {
        RichTextNode instance = null;
        try {
            if (jsonObject != null) {
                instance = (RichTextNode)registeredTextNodes.get(jsonObject.getString("type")).createRichTextNode(context, instanceId, componentRef);
                instance.parse(context, instanceId, componentRef, jsonObject);
            }
        }
        catch (Exception e) {
            WXLogUtils.e("Richtext", WXLogUtils.getStackTrace(e));
            instance = null;
        }
        return instance;
    }

    public static RichTextNode createRichTextNode(Context context, String instanceId, String componentRef, String ref, String nodeType, Map<String, String> styles, Map<String, String> attrs) {
        RichTextNode instance;
        try {
            instance = (RichTextNode)registeredTextNodes.get(nodeType).createRichTextNode(context, instanceId, componentRef, ref, styles, attrs);
        }
        catch (Exception e) {
            WXLogUtils.e("Richtext", WXLogUtils.getStackTrace(e));
            instance = null;
        }
        return instance;
    }

    static {
        registeredTextNodes.put("span", new SpanNode.SpanNodeCreator());
        registeredTextNodes.put("image", new ImgNode.ImgNodeCreator());
        registeredTextNodes.put("a", new ANode.ANodeCreator());
    }
}

