/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.component.list.template;

import android.support.v4.view.ViewCompat;
import android.view.View;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.weex.WXSDKManager;
import org.apache.weex.dom.WXAttr;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.ui.component.WXVContainer;
import org.apache.weex.ui.component.list.WXCell;
import org.apache.weex.ui.component.list.template.TemplateViewHolder;
import org.apache.weex.ui.component.list.template.WXRecyclerTemplateList;
import org.apache.weex.ui.view.listview.WXRecyclerView;
import org.apache.weex.ui.view.refresh.wrapper.BounceRecyclerView;

public class TemplateDom {
    public static final String KEY_RESET_ANIMATION = "resetAnimation";
    public static final String KEY_ATTRS = "attrs";
    public static final String KEY_TYPE = "type";
    public static final String KEY_VIRTUAL_DOM_REF = "ref";
    public static final String VIRTUAL_DOM_IDENTIFY = "[[VirtualElement]]";
    public static final String ATTRS_KEY_REF = "ref";
    public static final String ATTACH_CELL_SLOT = "_attach_slot";
    public static final String DETACH_CELL_SLOT = "_detach_slot";
    public static final char SEPARATOR = '@';

    public static String genKeyVirtualDomRef(String listRef, int position, String key) {
        return listRef + '@' + position + '@' + key;
    }

    public static WXComponent findVirtualComponentByVRef(String pageId, String virtualRef) {
        try {
            String[] segments = virtualRef.split("@");
            String listRef = segments[0];
            WXComponent component = WXSDKManager.getInstance().getWXRenderManager().getWXComponent(pageId, listRef);
            if (!(component instanceof WXRecyclerTemplateList)) {
                return null;
            }
            WXRecyclerTemplateList templateList = (WXRecyclerTemplateList)component;
            if (templateList.getHostView() == null || ((BounceRecyclerView)templateList.getHostView()).getInnerView() == null) {
                return null;
            }
            int position = Integer.parseInt(segments[1]);
            WXRecyclerView recyclerView = (WXRecyclerView)((BounceRecyclerView)templateList.getHostView()).getInnerView();
            TemplateViewHolder itemHolder = (TemplateViewHolder)recyclerView.findViewHolderForAdapterPosition(position);
            if (itemHolder == null) {
                return null;
            }
            WXCell cell = itemHolder.getTemplate();
            String viewKey = segments[2];
            WXComponent target = TemplateDom.findComponentByViewTreeKey(cell, viewKey);
            return target;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<String, Object> findAllComponentRefs(String listRef, int position, WXComponent component) {
        HashMap<String, Object> refs = new HashMap<String, Object>();
        TemplateDom.findAllComponentRefs(listRef, position, component, refs);
        HashMap<String, Object> refsMap = new HashMap<String, Object>();
        refsMap.put("refs", refs);
        refsMap.put("position", position);
        refsMap.put("listRef", listRef);
        return refsMap;
    }

    private static void findAllComponentRefs(String listRef, int position, WXComponent component, Map<String, Object> refs) {
        WXAttr attrs;
        if (component.isWaste()) {
            return;
        }
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            for (int i = 0; i < container.getChildCount(); ++i) {
                WXComponent child = container.getChild(i);
                TemplateDom.findAllComponentRefs(listRef, position, child, refs);
            }
        }
        if ((attrs = component.getAttrs()) != null && attrs.get("ref") == null) {
            return;
        }
        String ref = attrs.get("ref").toString();
        ArrayList<Map> refList = (ArrayList<Map>)refs.get(ref);
        if (refList == null) {
            refList = new ArrayList<Map>();
            refs.put(ref, refList);
        }
        Map map = TemplateDom.toMap(listRef, position, component);
        refList.add(map);
    }

    public static Map toMap(String listRef, int position, WXComponent component) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(KEY_ATTRS, component.getAttrs());
        map.put(KEY_TYPE, component.getComponentType());
        map.put("ref", TemplateDom.genKeyVirtualDomRef(listRef, position, component.getViewTreeKey()));
        map.put(VIRTUAL_DOM_IDENTIFY, true);
        return map;
    }

    public static boolean isVirtualDomRef(String ref) {
        if (ref != null) {
            return ref.indexOf(64) > 0;
        }
        return false;
    }

    public static void resetAnimaiton(View view) {
        if (view == null) {
            return;
        }
        if (ViewCompat.getTranslationX((View)view) != 0.0f) {
            ViewCompat.setTranslationX((View)view, (float)0.0f);
        }
        if (ViewCompat.getTranslationY((View)view) != 0.0f) {
            ViewCompat.setTranslationY((View)view, (float)0.0f);
        }
        if (ViewCompat.getTranslationZ((View)view) != 0.0f) {
            ViewCompat.setTranslationZ((View)view, (float)0.0f);
        }
        if (ViewCompat.getScaleX((View)view) != 1.0f) {
            ViewCompat.setScaleX((View)view, (float)1.0f);
        }
        if (ViewCompat.getScaleY((View)view) != 1.0f) {
            ViewCompat.setScaleY((View)view, (float)1.0f);
        }
        if (ViewCompat.getRotationX((View)view) != 0.0f) {
            ViewCompat.setRotationX((View)view, (float)0.0f);
        }
        if (ViewCompat.getRotationY((View)view) != 0.0f) {
            ViewCompat.setRotationY((View)view, (float)0.0f);
        }
        if (ViewCompat.getElevation((View)view) != 0.0f) {
            ViewCompat.setElevation((View)view, (float)0.0f);
        }
    }

    public static final WXComponent findComponentByViewTreeKey(WXComponent component, String viewKey) {
        if (component.getViewTreeKey().equals(viewKey)) {
            return component;
        }
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            for (int i = 0; i < container.getChildCount(); ++i) {
                WXComponent element = container.getChild(i);
                if (TemplateDom.findComponentByViewTreeKey(element, viewKey) == null) continue;
                return element;
            }
        }
        return null;
    }

    private static WXComponent findChildByAttrsRef(WXComponent component, String ref) {
        if (component.getAttrs() != null && ref.equals(component.getAttrs().get("ref"))) {
            return component;
        }
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            for (int i = 0; i < container.getChildCount(); ++i) {
                WXComponent child = TemplateDom.findChildByAttrsRef(container.getChild(i), ref);
                if (child == null) continue;
                return child;
            }
        }
        return null;
    }
}

