/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.component.list;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.weex.WXEnvironment;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.ui.component.list.DragHelper;
import org.apache.weex.ui.component.list.DragSupportCallback;
import org.apache.weex.ui.component.list.EventTrigger;
import org.apache.weex.utils.WXLogUtils;

class DefaultDragHelper
implements DragHelper {
    private boolean mLongPressEnabled;
    @NonNull
    private final EventTrigger mEventTrigger;
    @NonNull
    private final RecyclerView mRecyclerView;
    @NonNull
    private final List<WXComponent> mDataSource;
    @NonNull
    private ItemTouchHelper mItemTouchHelper;
    private static final String EVENT_START_DRAG = "dragstart";
    private static final String EVENT_END_DRAG = "dragend";
    private static final String TAG_EXCLUDED = "drag_excluded";
    private static final String TAG = "WXListExComponent";
    private boolean isDraggable = false;

    DefaultDragHelper(@NonNull List<WXComponent> dataSource, @NonNull RecyclerView recyclerView, @NonNull EventTrigger trigger) {
        this.mDataSource = dataSource;
        this.mEventTrigger = trigger;
        this.mRecyclerView = recyclerView;
        this.mItemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)new DragSupportCallback(this, true));
        try {
            this.mItemTouchHelper.attachToRecyclerView(this.mRecyclerView);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void onDragStart(@NonNull WXComponent component, int from) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(TAG, "list on drag start : from index " + from);
        }
        this.mEventTrigger.triggerEvent(EVENT_START_DRAG, this.buildEvent(component.getRef(), from, -1));
    }

    @Override
    public void onDragEnd(@NonNull WXComponent component, int from, int to) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(TAG, "list on drag end : from index " + from + " to index " + to);
        }
        this.mEventTrigger.triggerEvent(EVENT_END_DRAG, this.buildEvent(component.getRef(), from, to));
    }

    @Override
    public void onDragging(int fromPos, int toPos) {
        RecyclerView.Adapter adapter;
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(TAG, "list on dragging : from index " + fromPos + " to index " + toPos);
        }
        if ((adapter = this.mRecyclerView.getAdapter()) == null) {
            WXLogUtils.e(TAG, "drag failed because of RecyclerView#Adapter is not bound");
            return;
        }
        if (fromPos >= 0 && fromPos <= this.mDataSource.size() - 1 && toPos >= 0 && toPos <= this.mDataSource.size() - 1) {
            Collections.swap(this.mDataSource, fromPos, toPos);
            adapter.notifyItemMoved(fromPos, toPos);
        }
    }

    @Override
    public boolean isLongPressDragEnabled() {
        return this.mLongPressEnabled;
    }

    @Override
    public void setLongPressDragEnabled(boolean enabled) {
        this.mLongPressEnabled = enabled;
    }

    @Override
    public void startDrag(@NonNull RecyclerView.ViewHolder viewHolder) {
        if (this.isDraggable) {
            this.mItemTouchHelper.startDrag(viewHolder);
        }
    }

    @Override
    public boolean isDraggable() {
        return this.isDraggable;
    }

    @Override
    public void setDraggable(boolean draggable) {
        this.isDraggable = draggable;
    }

    @Override
    public void setDragExcluded(@NonNull RecyclerView.ViewHolder viewHolder, boolean isExcluded) {
        if (viewHolder.itemView == null) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e(TAG, "[error] viewHolder.itemView is null");
            }
            return;
        }
        if (isExcluded) {
            viewHolder.itemView.setTag((Object)TAG_EXCLUDED);
        } else {
            viewHolder.itemView.setTag(null);
        }
    }

    @Override
    public boolean isDragExcluded(@NonNull RecyclerView.ViewHolder viewHolder) {
        if (viewHolder.itemView == null) {
            if (WXEnvironment.isApkDebugable()) {
                WXLogUtils.e(TAG, "[error] viewHolder.itemView is null");
            }
            return false;
        }
        return viewHolder.itemView.getTag() != null && TAG_EXCLUDED.equals(viewHolder.itemView.getTag());
    }

    private Map<String, Object> buildEvent(@Nullable String target, int fromIndex, int toIndex) {
        HashMap<String, Object> args = new HashMap<String, Object>(4);
        args.put("target", target == null ? "unknown" : target);
        args.put("fromIndex", fromIndex);
        args.put("toIndex", toIndex);
        args.put("timestamp", System.currentTimeMillis());
        return args;
    }
}

