/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.component.binding;

import android.os.AsyncTask;
import org.apache.weex.WXEnvironment;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.ui.component.WXVContainer;
import org.apache.weex.ui.component.binding.AsynLayoutTask;
import org.apache.weex.ui.component.list.WXCell;
import org.apache.weex.ui.component.list.template.TemplateDom;
import org.apache.weex.ui.component.list.template.TemplateViewHolder;
import org.apache.weex.ui.component.list.template.jni.NativeRenderObjectUtils;
import org.apache.weex.utils.WXLogUtils;
import org.apache.weex.utils.WXUtils;

public class Layouts {
    public static void doLayoutAsync(TemplateViewHolder templateViewHolder, boolean async) {
        WXComponent component = templateViewHolder.getComponent();
        int position = templateViewHolder.getHolderPosition();
        if (templateViewHolder.asyncTask != null) {
            templateViewHolder.asyncTask.cancel(false);
            templateViewHolder.asyncTask = null;
        }
        if (async) {
            AsynLayoutTask asyncTask;
            templateViewHolder.asyncTask = asyncTask = new AsynLayoutTask(templateViewHolder, position, component);
            asyncTask.executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        } else {
            Layouts.doLayoutOnly(component, templateViewHolder);
            Layouts.setLayout(component, false);
            if (templateViewHolder.getHolderPosition() >= 0) {
                templateViewHolder.getTemplateList().fireEvent("_attach_slot", TemplateDom.findAllComponentRefs(templateViewHolder.getTemplateList().getRef(), position, component));
            }
        }
    }

    public static void doLayoutSync(WXCell component, float layoutWidth, float layoutHeight) {
        Layouts.doSafeLayout(component, layoutWidth, layoutHeight);
        Layouts.setLayout(component, false);
    }

    public static void doLayoutOnly(WXComponent component, TemplateViewHolder holder) {
        Layouts.doSafeLayout(component, holder.getTemplateList().getLayoutWidth(), holder.getTemplateList().getLayoutHeight());
    }

    private static void doSafeLayout(WXComponent component, float layoutWidth, float layoutHeight) {
        block4: {
            try {
                long start = System.currentTimeMillis();
                int height = NativeRenderObjectUtils.nativeLayoutRenderObject(component.getRenderObjectPtr(), layoutWidth, layoutHeight);
                if (WXEnvironment.isOpenDebugLog()) {
                    // empty if block
                }
                if (height <= 0) {
                    WXLogUtils.e("WXRecyclerTemplateList", " WXTemplateList doSafeLayout wrong template " + component.getAttrs().get("case") + " cell height " + height);
                }
            }
            catch (Exception e) {
                if (!WXEnvironment.isApkDebugable()) break block4;
                WXLogUtils.e("WXRecyclerTemplateList", e);
            }
        }
    }

    public static final void setLayout(WXComponent component, boolean force) {
        long ptr;
        if (component.isWaste()) {
            return;
        }
        if (component.getAttrs().containsKey("resetAnimation") && WXUtils.getBoolean(component.getAttrs().get("resetAnimation"), true).booleanValue()) {
            TemplateDom.resetAnimaiton(component.getHostView());
        }
        if (NativeRenderObjectUtils.nativeRenderObjectHasNewLayout(ptr = component.getRenderObjectPtr())) {
            NativeRenderObjectUtils.nativeRenderObjectUpdateComponent(ptr, component);
        }
        if (component instanceof WXVContainer) {
            WXVContainer container = (WXVContainer)component;
            int count = container.getChildCount();
            for (int i = 0; i < count; ++i) {
                WXComponent child = container.getChild(i);
                if (child == null) continue;
                Layouts.setLayout(child, force);
            }
        }
    }
}

