/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.component;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.util.HashMap;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.annotation.Component;
import org.apache.weex.ui.action.BasicComponentData;
import org.apache.weex.ui.component.WXBaseRefresh;
import org.apache.weex.ui.component.WXComponentProp;
import org.apache.weex.ui.component.WXScroller;
import org.apache.weex.ui.component.WXVContainer;
import org.apache.weex.ui.component.list.WXListComponent;
import org.apache.weex.ui.view.WXFrameLayout;
import org.apache.weex.ui.view.WXLoadingLayout;
import org.apache.weex.ui.view.refresh.core.WXSwipeLayout;
import org.apache.weex.ui.view.refresh.wrapper.BaseBounceView;
import org.apache.weex.utils.WXUtils;

@Component(lazyload=false)
public class WXLoading
extends WXBaseRefresh
implements WXSwipeLayout.WXOnLoadingListener {
    public static final String HIDE = "hide";

    public WXLoading(WXSDKInstance instance, WXVContainer parent, boolean lazy, BasicComponentData basicComponentData) {
        super(instance, parent, lazy, basicComponentData);
    }

    @Override
    protected WXFrameLayout initComponentHostView(@NonNull Context context) {
        return new WXLoadingLayout(context);
    }

    @Override
    public void onLoading() {
        if (this.getEvents().contains("loading")) {
            this.fireEvent("loading");
        }
    }

    @Override
    protected void setHostLayoutParams(WXFrameLayout host, int width, int height, int left, int right, int top, int bottom) {
        super.setHostLayoutParams(host, width, height, 0, 0, 0, 0);
    }

    @Override
    public void onPullingUp(float dy, int pullOutDistance, float viewHeight) {
        if (this.getEvents().contains("pullingup")) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("dy", Float.valueOf(dy));
            data.put("pullingDistance", pullOutDistance);
            data.put("viewHeight", Float.valueOf(viewHeight));
            this.fireEvent("pullingup", data);
        }
    }

    @Override
    public boolean canRecycled() {
        return false;
    }

    @Override
    protected boolean setProperty(String key, Object param) {
        switch (key) {
            case "display": {
                String display = WXUtils.getString(param, null);
                if (display != null) {
                    this.setDisplay(display);
                }
                return true;
            }
        }
        return super.setProperty(key, param);
    }

    @WXComponentProp(name="display")
    public void setDisplay(String display) {
        if (!TextUtils.isEmpty((CharSequence)display) && display.equals(HIDE) && (this.getParent() instanceof WXListComponent || this.getParent() instanceof WXScroller) && ((BaseBounceView)((Object)this.getParent().getHostView())).getSwipeLayout().isRefreshing()) {
            ((BaseBounceView)((Object)this.getParent().getHostView())).finishPullLoad();
            ((BaseBounceView)((Object)this.getParent().getHostView())).onLoadmoreComplete();
        }
    }
}

