/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.animation;

import android.graphics.drawable.ColorDrawable;
import android.util.Property;
import android.view.View;
import org.apache.weex.ui.view.border.BorderDrawable;
import org.apache.weex.utils.WXLogUtils;
import org.apache.weex.utils.WXViewUtils;

public class BackgroundColorProperty
extends Property<View, Integer> {
    private static final String TAG = "BackgroundColorAnimation";

    public BackgroundColorProperty() {
        super(Integer.class, "backgroundColor");
    }

    public Integer get(View object) {
        int color;
        BorderDrawable borderDrawable = WXViewUtils.getBorderDrawable(object);
        if (borderDrawable != null) {
            color = borderDrawable.getColor();
        } else if (object.getBackground() instanceof ColorDrawable) {
            color = ((ColorDrawable)object.getBackground()).getColor();
        } else {
            color = 0;
            WXLogUtils.e(TAG, "Unsupported background type");
        }
        return color;
    }

    public void set(View object, Integer value) {
        BorderDrawable borderDrawable = WXViewUtils.getBorderDrawable(object);
        if (borderDrawable != null) {
            borderDrawable.setColor(value);
        } else if (object.getBackground() instanceof ColorDrawable) {
            ((ColorDrawable)object.getBackground()).setColor(value.intValue());
        } else {
            WXLogUtils.e(TAG, "Unsupported background type");
        }
    }
}

