/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.action;

import android.support.v4.util.ArrayMap;
import java.util.Map;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.WXSDKManager;
import org.apache.weex.bridge.WXBridgeManager;
import org.apache.weex.dom.CSSShorthand;
import org.apache.weex.dom.transition.WXTransition;
import org.apache.weex.ui.action.BasicGraphicAction;
import org.apache.weex.ui.component.WXComponent;

public class GraphicActionUpdateStyle
extends BasicGraphicAction {
    private Map<String, Object> mStyle;
    private WXComponent component;
    private boolean mIsCausedByPesudo;
    private boolean mIsBorderSet;

    public GraphicActionUpdateStyle(WXSDKInstance instance, String ref, Map<String, Object> style, Map<String, String> paddings, Map<String, String> margins, Map<String, String> borders) {
        this(instance, ref, style, paddings, margins, borders, false);
    }

    public GraphicActionUpdateStyle(WXSDKInstance instance, String ref, Map<String, Object> style, CSSShorthand paddings, CSSShorthand margins, CSSShorthand borders, boolean byPesudo) {
        super(instance, ref);
        this.mStyle = style;
        this.mIsCausedByPesudo = byPesudo;
        this.component = WXSDKManager.getInstance().getWXRenderManager().getWXComponent(this.getPageId(), this.getRef());
        if (this.component == null) {
            return;
        }
        if (null != this.mStyle) {
            this.component.updateStyle(this.mStyle, this.mIsCausedByPesudo);
            if (style.containsKey("transform") && this.component.getTransition() == null) {
                ArrayMap animationMap = new ArrayMap(2);
                animationMap.put("transform", style.get("transform"));
                animationMap.put("transformOrigin", style.get("transformOrigin"));
                this.component.addAnimationForElement((Map<String, Object>)animationMap);
            }
        }
        if (null != paddings) {
            this.component.setPaddings(paddings);
        }
        if (null != margins) {
            this.component.setMargins(margins);
        }
        if (null != borders) {
            this.mIsBorderSet = true;
            this.component.setBorders(borders);
        }
    }

    public GraphicActionUpdateStyle(WXSDKInstance instance, String ref, Map<String, Object> style, Map<String, String> paddings, Map<String, String> margins, Map<String, String> borders, boolean byPesudo) {
        super(instance, ref);
        this.mStyle = style;
        this.mIsCausedByPesudo = byPesudo;
        this.component = WXSDKManager.getInstance().getWXRenderManager().getWXComponent(this.getPageId(), this.getRef());
        if (this.component == null) {
            return;
        }
        if (null != this.mStyle) {
            this.component.addStyle(this.mStyle, this.mIsCausedByPesudo);
            if (style.containsKey("transform") && this.component.getTransition() == null) {
                ArrayMap animationMap = new ArrayMap(2);
                animationMap.put("transform", style.get("transform"));
                animationMap.put("transformOrigin", style.get("transformOrigin"));
                this.component.addAnimationForElement((Map<String, Object>)animationMap);
                WXBridgeManager.getInstance().markDirty(this.component.getInstanceId(), this.component.getRef(), true);
            }
        }
        if (null != paddings) {
            this.component.addShorthand(paddings);
        }
        if (null != margins) {
            this.component.addShorthand(margins);
        }
        if (null != borders) {
            this.mIsBorderSet = true;
            this.component.addShorthand(borders);
        }
    }

    @Override
    public void executeAction() {
        if (this.component == null) {
            return;
        }
        if (this.mStyle != null) {
            if (this.component.getTransition() != null) {
                this.component.getTransition().updateTranstionParams(this.mStyle);
                if (this.component.getTransition().hasTransitionProperty(this.mStyle)) {
                    this.component.getTransition().startTransition(this.mStyle);
                }
            } else {
                this.component.setTransition(WXTransition.fromMap(this.mStyle, this.component));
                this.component.updateStyles(this.mStyle);
            }
        } else if (this.mIsBorderSet) {
            this.component.updateStyles(this.component);
        }
    }
}

