/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui.action;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.WXSDKManager;
import org.apache.weex.bridge.JSCallback;
import org.apache.weex.bridge.SimpleJSCallback;
import org.apache.weex.ui.action.BasicGraphicAction;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.utils.WXViewUtils;

public class ActionGetComponentRect
extends BasicGraphicAction {
    private final String mCallback;

    public ActionGetComponentRect(WXSDKInstance instance, String ref, String callback) {
        super(instance, ref);
        this.mCallback = callback;
    }

    @Override
    public void executeAction() {
        WXSDKInstance instance = this.getWXSDKIntance();
        if (instance == null || instance.isDestroy()) {
            return;
        }
        SimpleJSCallback jsCallback = new SimpleJSCallback(instance.getInstanceId(), this.mCallback);
        if (TextUtils.isEmpty((CharSequence)this.getRef())) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("result", false);
            options.put("errMsg", "Illegal parameter");
            jsCallback.invoke(options);
        } else if ("viewport".equalsIgnoreCase(this.getRef())) {
            this.callbackViewport(instance, jsCallback);
        } else {
            WXComponent component = WXSDKManager.getInstance().getWXRenderManager().getWXComponent(this.getPageId(), this.getRef());
            if (component == null) {
                return;
            }
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (component != null) {
                int viewPort = instance.getInstanceViewPortWidth();
                HashMap<String, Float> size = new HashMap<String, Float>();
                Rect sizes = component.getComponentSize();
                size.put("width", Float.valueOf(this.getWebPxValue(sizes.width(), viewPort)));
                size.put("height", Float.valueOf(this.getWebPxValue(sizes.height(), viewPort)));
                size.put("bottom", Float.valueOf(this.getWebPxValue(sizes.bottom, viewPort)));
                size.put("left", Float.valueOf(this.getWebPxValue(sizes.left, viewPort)));
                size.put("right", Float.valueOf(this.getWebPxValue(sizes.right, viewPort)));
                size.put("top", Float.valueOf(this.getWebPxValue(sizes.top, viewPort)));
                options.put("size", size);
                options.put("result", true);
            } else {
                options.put("errMsg", "Component does not exist");
            }
            jsCallback.invoke(options);
        }
    }

    private void callbackViewport(WXSDKInstance instance, JSCallback jsCallback) {
        View container = instance.getContainerView();
        if (container != null) {
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            HashMap<String, Float> sizes = new HashMap<String, Float>();
            int[] location = new int[2];
            instance.getContainerView().getLocationOnScreen(location);
            int viewport = instance.getInstanceViewPortWidth();
            sizes.put("left", Float.valueOf(0.0f));
            sizes.put("top", Float.valueOf(0.0f));
            sizes.put("right", Float.valueOf(this.getWebPxValue(container.getWidth(), viewport)));
            sizes.put("bottom", Float.valueOf(this.getWebPxValue(container.getHeight(), viewport)));
            sizes.put("width", Float.valueOf(this.getWebPxValue(container.getWidth(), viewport)));
            sizes.put("height", Float.valueOf(this.getWebPxValue(container.getHeight(), viewport)));
            options.put("size", sizes);
            options.put("result", Boolean.valueOf(true));
            jsCallback.invoke(options);
        } else {
            HashMap<String, Object> options = new HashMap<String, Object>();
            options.put("result", false);
            options.put("errMsg", "Component does not exist");
            jsCallback.invoke(options);
        }
    }

    @NonNull
    private float getWebPxValue(int value, int viewport) {
        return WXViewUtils.getWebPxByWidth(value, viewport);
    }
}

