/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.weex.WXSDKManager;
import org.apache.weex.bridge.WXBridgeManager;
import org.apache.weex.common.WXException;
import org.apache.weex.ui.IFComponentHolder;
import org.apache.weex.utils.WXLogUtils;
import org.apache.weex.utils.cache.RegisterCache;

public class WXComponentRegistry {
    private static Map<String, IFComponentHolder> sTypeComponentMap = new ConcurrentHashMap<String, IFComponentHolder>();
    private static ArrayList<Map<String, Object>> sComponentInfos = new ArrayList();

    public static synchronized boolean registerComponent(Map<String, RegisterCache.ComponentCache> componentCacheMap) {
        if (componentCacheMap.isEmpty()) {
            return true;
        }
        final Iterator<Map.Entry<String, RegisterCache.ComponentCache>> iterator = componentCacheMap.entrySet().iterator();
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                ArrayList<Map<String, Object>> coms = new ArrayList<Map<String, Object>>();
                while (iterator.hasNext()) {
                    Map.Entry next = (Map.Entry)iterator.next();
                    try {
                        RegisterCache.ComponentCache value = (RegisterCache.ComponentCache)next.getValue();
                        Map<String, Object> registerInfo = value.componentInfo;
                        if (registerInfo == null) {
                            registerInfo = new HashMap<String, Object>();
                        }
                        registerInfo.put("type", value.type);
                        registerInfo.put("methods", value.holder.getMethods());
                        WXComponentRegistry.registerNativeComponent(value.type, value.holder);
                        sComponentInfos.add(registerInfo);
                        coms.add(registerInfo);
                    }
                    catch (WXException e) {
                        e.printStackTrace();
                    }
                }
                WXSDKManager.getInstance().registerComponents(coms);
            }
        });
        return true;
    }

    public static synchronized boolean registerComponent(final String type, final IFComponentHolder holder, final Map<String, Object> componentInfo) throws WXException {
        if (holder == null || TextUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        if (RegisterCache.getInstance().cacheComponent(type, holder, componentInfo)) {
            return true;
        }
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                try {
                    HashMap<String, String> registerInfo = componentInfo;
                    if (registerInfo == null) {
                        registerInfo = new HashMap<String, String>();
                    }
                    registerInfo.put("type", type);
                    registerInfo.put("methods", (String)holder.getMethods());
                    WXComponentRegistry.registerNativeComponent(type, holder);
                    WXComponentRegistry.registerJSComponent(registerInfo);
                    sComponentInfos.add(registerInfo);
                }
                catch (WXException e) {
                    WXLogUtils.e("register component error:", e);
                }
            }
        });
        return true;
    }

    private static boolean registerNativeComponent(String type, IFComponentHolder holder) throws WXException {
        try {
            holder.loadIfNonLazy();
            sTypeComponentMap.put(type, holder);
        }
        catch (ArrayStoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static boolean registerJSComponent(Map<String, Object> componentInfo) throws WXException {
        ArrayList<Map<String, Object>> coms = new ArrayList<Map<String, Object>>();
        coms.add(componentInfo);
        WXSDKManager.getInstance().registerComponents(coms);
        return true;
    }

    public static IFComponentHolder getComponent(String type) {
        return sTypeComponentMap.get(type);
    }

    public static void reload() {
        WXBridgeManager.getInstance().post(new Runnable(){

            @Override
            public void run() {
                try {
                    for (Map com : sComponentInfos) {
                        WXComponentRegistry.registerJSComponent(com);
                    }
                }
                catch (WXException e) {
                    WXLogUtils.e("", e);
                }
            }
        });
    }
}

