/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.ui;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.dom.RenderContext;
import org.apache.weex.ui.component.WXComponent;

class RenderContextImpl
implements RenderContext {
    private Map<String, WXComponent> mRegistry;
    private WXSDKInstance mWXSDKInstance;

    public RenderContextImpl(WXSDKInstance instance) {
        this.mWXSDKInstance = instance;
        this.mRegistry = new ConcurrentHashMap<String, WXComponent>();
    }

    public void destroy() {
        this.mWXSDKInstance = null;
        try {
            this.mRegistry.clear();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public WXSDKInstance getWXSDKInstance() {
        return this.mWXSDKInstance;
    }

    @Override
    public WXSDKInstance getInstance() {
        return this.mWXSDKInstance;
    }

    @Override
    public WXComponent getComponent(String ref) {
        return this.mRegistry.get(ref);
    }

    public void registerComponent(String ref, WXComponent comp) {
        this.mRegistry.put(ref, comp);
    }

    @Override
    public WXComponent unregisterComponent(String ref) {
        return this.mRegistry.remove(ref);
    }

    public int getComponentCount() {
        return this.mRegistry.size();
    }
}

