/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.el.parse;

import org.apache.weex.el.parse.Operators;

public class Token {
    public static final int TYPE_IDENTIFIER = 0;
    public static final int TYPE_INT = 1;
    public static final int TYPE_DOUBLE = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_KEYWORD = 4;
    public static final int TYPE_OPERATOR = 5;
    public static final int TYPE_BLOCK = 6;
    public static final int TYPE_ARRAY = 7;
    private String token;
    private int type;

    public Token(String token, int type) {
        this.token = token;
        this.type = type;
    }

    public Object execute(Object context) {
        if (this.type == 0) {
            return Operators.el(context, this.token);
        }
        if (this.type == 3) {
            return this.token;
        }
        if (this.type == 1) {
            try {
                return Integer.parseInt(this.token);
            }
            catch (Exception e) {
                return 0;
            }
        }
        if (this.type == 2) {
            try {
                return Double.parseDouble(this.token);
            }
            catch (Exception e) {
                return 0;
            }
        }
        if (this.type == 4) {
            return Operators.KEYWORDS.get(this.token);
        }
        throw new IllegalArgumentException("unhandled token type " + this.type);
    }

    public String toString() {
        return "{" + this.token + "," + this.type + '}';
    }

    public String getToken() {
        return this.token;
    }

    public int getType() {
        return this.type;
    }
}

