/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.el.parse;

import org.apache.weex.el.parse.Operators;
import org.apache.weex.el.parse.Token;

class Operator
extends Token {
    public Token self;
    public Token first;
    public Token second;

    public Operator(String operator, int type) {
        super(operator, type);
    }

    @Override
    public Object execute(Object context) {
        String op;
        switch (op = this.getToken()) {
            case ".": 
            case "[": {
                return Operators.dot(this.first, this.second, context);
            }
            case "===": 
            case "==": {
                return Operators.isEquals(this.first, this.second, context);
            }
            case "!==": 
            case "!=": {
                return !Operators.isEquals(this.first, this.second, context);
            }
            case "?": {
                return Operators.condition(this.self, this.first, this.second, context);
            }
            case "!": {
                return !Operators.tokenTrue(this.self, context);
            }
            case "&&": {
                return Operators.tokenTrue(this.first, context) && Operators.tokenTrue(this.second, context);
            }
            case "||": {
                return Operators.tokenTrue(this.first, context) || Operators.tokenTrue(this.second, context);
            }
            case ">": {
                return Operators.tokenNumber(this.first, context) > Operators.tokenNumber(this.second, context);
            }
            case ">=": {
                return Operators.tokenNumber(this.first, context) >= Operators.tokenNumber(this.second, context);
            }
            case "<": {
                return Operators.tokenNumber(this.first, context) < Operators.tokenNumber(this.second, context);
            }
            case "<=": {
                return Operators.tokenNumber(this.first, context) <= Operators.tokenNumber(this.second, context);
            }
            case "+": {
                return Operators.plus(this.first, this.second, context);
            }
            case "-": {
                return Operators.sub(this.first, this.second, context);
            }
            case "*": {
                return Operators.mul(this.first, this.second, context);
            }
            case "/": {
                return Operators.div(this.first, this.second, context);
            }
            case "%": {
                return Operators.mod(this.first, this.second, context);
            }
        }
        throw new IllegalArgumentException(op + " operator is not supported");
    }

    @Override
    public String toString() {
        if ("!".equals(this.getToken())) {
            return "{!" + this.self + "}";
        }
        if (this.self == null) {
            return "{" + this.first + this.getToken() + this.second + "}";
        }
        return "{" + this.self + this.getToken() + this.first + ":" + this.second + "}";
    }
}

