/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.dom;

import android.support.v4.util.ArrayMap;
import android.support.v4.util.SimpleArrayMap;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.weex.dom.binding.ELUtils;
import org.apache.weex.dom.binding.JSONUtils;

public class WXEvent
extends ArrayList<String>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8186587029452440107L;
    public static final String EVENT_KEY_TYPE = "type";
    public static final String EVENT_KEY_ARGS = "params";
    private ArrayMap mEventBindingArgs;
    private ArrayMap<String, List<Object>> mEventBindingArgsValues;

    @Override
    public void clear() {
        if (this.mEventBindingArgs != null) {
            this.mEventBindingArgs.clear();
        }
        if (this.mEventBindingArgsValues != null) {
            this.mEventBindingArgsValues.clear();
        }
        super.clear();
    }

    public boolean remove(String o) {
        if (this.mEventBindingArgs != null) {
            this.mEventBindingArgs.remove((Object)o);
        }
        if (this.mEventBindingArgsValues != null) {
            this.mEventBindingArgsValues.remove((Object)o);
        }
        return super.remove(o);
    }

    public ArrayMap getEventBindingArgs() {
        return this.mEventBindingArgs;
    }

    public ArrayMap<String, List<Object>> getEventBindingArgsValues() {
        return this.mEventBindingArgsValues;
    }

    public void addEvent(Object event) {
        if (event instanceof CharSequence) {
            if (JSONUtils.isJSON(event.toString())) {
                this.addEvent(JSONUtils.toJSON(event.toString()));
                return;
            }
            String eventName = event.toString();
            if (!this.contains(eventName)) {
                this.add(eventName);
            }
        } else if (event instanceof JSONObject) {
            JSONObject bindings = (JSONObject)event;
            this.addBindingEvent(bindings);
        }
    }

    public static String getEventName(Object event) {
        if (event instanceof CharSequence) {
            return event.toString();
        }
        if (event instanceof JSONObject) {
            JSONObject bindings = (JSONObject)event;
            String eventName = bindings.getString(EVENT_KEY_TYPE);
            return eventName;
        }
        if (event == null) {
            return null;
        }
        return event.toString();
    }

    public void parseStatements() {
        if (!this.isEmpty()) {
            for (int i = 0; i < this.size(); ++i) {
                String event = (String)this.get(i);
                if (!JSONUtils.isJSON(event)) continue;
                JSONObject object = JSONUtils.toJSON(event);
                String eventName = this.addBindingEvent(object);
                this.set(i, eventName);
            }
        }
    }

    private String addBindingEvent(JSONObject bindings) {
        String eventName = bindings.getString(EVENT_KEY_TYPE);
        Object args = bindings.get((Object)EVENT_KEY_ARGS);
        if (eventName != null) {
            this.addBindingArgsEvent(eventName, args);
        }
        return eventName;
    }

    private void addBindingArgsEvent(String eventName, Object args) {
        if (!this.contains(eventName)) {
            this.add(eventName);
        }
        if (args != null) {
            if (this.mEventBindingArgs == null) {
                this.mEventBindingArgs = new ArrayMap();
            }
            this.mEventBindingArgs.put((Object)eventName, ELUtils.bindingBlock(args));
        }
    }

    public void putEventBindingArgsValue(String event, List<Object> value) {
        if (this.mEventBindingArgsValues == null) {
            this.mEventBindingArgsValues = new ArrayMap();
        }
        if (value == null) {
            this.mEventBindingArgsValues.remove((Object)event);
        } else {
            this.mEventBindingArgsValues.put((Object)event, value);
        }
    }

    @Override
    public WXEvent clone() {
        WXEvent event = new WXEvent();
        event.addAll(this);
        if (this.mEventBindingArgs != null) {
            event.mEventBindingArgs = new ArrayMap((SimpleArrayMap)this.mEventBindingArgs);
        }
        event.mEventBindingArgsValues = null;
        return event;
    }
}

