/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.bridge;

import android.util.Log;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Type;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.WXSDKManager;
import org.apache.weex.bridge.Invoker;
import org.apache.weex.bridge.JSCallback;
import org.apache.weex.bridge.MethodInvoker;
import org.apache.weex.bridge.SimpleJSCallback;
import org.apache.weex.performance.WXAnalyzerDataTransfer;
import org.apache.weex.utils.WXLogUtils;
import org.apache.weex.utils.WXReflectionUtils;

public class NativeInvokeHelper {
    private String mInstanceId;

    public NativeInvokeHelper(String instanceId) {
        this.mInstanceId = instanceId;
    }

    public Object invoke(final Object target, final Invoker invoker, JSONArray args) throws Exception {
        final Object[] params = this.prepareArguments(invoker.getParameterTypes(), args);
        if (WXAnalyzerDataTransfer.isInteractionLogOpen() && invoker instanceof MethodInvoker) {
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof SimpleJSCallback)) continue;
                final String callBackId = ((SimpleJSCallback)params[i]).getCallbackId();
                Log.d((String)"wxInteractionAnalyzer", (String)("[client][callNativeModuleStart]," + this.mInstanceId + "," + ((MethodInvoker)invoker).mMethod.getDeclaringClass() + "," + ((MethodInvoker)invoker).mMethod.getName() + "," + callBackId));
                ((SimpleJSCallback)params[i]).setInvokerCallback(new SimpleJSCallback.InvokerCallback(){

                    @Override
                    public void onInvokeSuccess() {
                        Log.d((String)"wxInteractionAnalyzer", (String)("[client][callNativeModuleEnd]," + NativeInvokeHelper.this.mInstanceId + "," + ((MethodInvoker)invoker).mMethod.getDeclaringClass() + "," + ((MethodInvoker)invoker).mMethod.getName() + "," + callBackId));
                    }
                });
                break;
            }
        }
        if (!invoker.isRunOnUIThread()) {
            return invoker.invoke(target, params);
        }
        WXSDKManager.getInstance().postOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (invoker != null) {
                    try {
                        WXSDKInstance targetInstance = WXSDKManager.getInstance().getSDKInstance(NativeInvokeHelper.this.mInstanceId);
                        if (null == targetInstance || targetInstance.isDestroy()) {
                            return;
                        }
                        invoker.invoke(target, params);
                    }
                    catch (Exception e) {
                        WXLogUtils.e("NativeInvokeHelper", target + " Invoker " + invoker.toString() + " exception:" + e);
                    }
                }
            }
        }, 0L);
        return null;
    }

    protected Object[] prepareArguments(Type[] paramClazzs, JSONArray args) throws Exception {
        Object[] params = new Object[paramClazzs.length];
        for (int i = 0; i < paramClazzs.length; ++i) {
            Type paramClazz = paramClazzs[i];
            if (i >= args.size()) {
                if (!paramClazz.getClass().isPrimitive()) {
                    params[i] = null;
                    continue;
                }
                throw new Exception("[prepareArguments] method argument list not match.");
            }
            Object value = args.get(i);
            if (paramClazz == JSONObject.class) {
                if (value instanceof JSONObject || value == null) {
                    params[i] = value;
                    continue;
                }
                if (!(value instanceof String)) continue;
                params[i] = JSON.parseObject((String)value.toString());
                continue;
            }
            if (JSCallback.class == paramClazz) {
                if (value instanceof String) {
                    params[i] = new SimpleJSCallback(this.mInstanceId, (String)value);
                    continue;
                }
                throw new Exception("Parameter type not match.");
            }
            params[i] = WXReflectionUtils.parseArgument(paramClazz, value);
        }
        return params;
    }
}

