/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.appfram.storage;

import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.weex.bridge.JSCallback;

public class StorageResultHandler {
    private static final String RESULT = "result";
    private static final String DATA = "data";
    private static final String UNDEFINED = "undefined";
    private static final String RESULT_FAILED_NO_HANDLER = "no_handler";
    private static final String RESULT_FAILED_INVALID_PARAM = "invalid_param";
    private static final String RESULT_OK = "success";
    private static final String RESULT_FAILED = "failed";

    private StorageResultHandler() {
    }

    public static Map<String, Object> getItemResult(String result) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put(RESULT, result != null ? RESULT_OK : RESULT_FAILED);
        map.put(DATA, result != null ? result : UNDEFINED);
        return map;
    }

    public static Map<String, Object> setItemResult(boolean result) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put(RESULT, result ? RESULT_OK : RESULT_FAILED);
        map.put(DATA, UNDEFINED);
        return map;
    }

    public static Map<String, Object> removeItemResult(boolean result) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put(RESULT, result ? RESULT_OK : RESULT_FAILED);
        map.put(DATA, UNDEFINED);
        return map;
    }

    public static Map<String, Object> getLengthResult(long result) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put(RESULT, RESULT_OK);
        map.put(DATA, result);
        return map;
    }

    public static Map<String, Object> getAllkeysResult(List<String> result) {
        if (result == null) {
            result = new ArrayList<String>(1);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put(RESULT, RESULT_OK);
        map.put(DATA, result);
        return map;
    }

    private static void handleResult(@Nullable JSCallback callback, String result, Object data) {
        if (callback == null) {
            return;
        }
        HashMap<String, Object> retVal = new HashMap<String, Object>(4);
        retVal.put(RESULT, result);
        retVal.put(DATA, data);
        callback.invoke(retVal);
    }

    public static void handleNoHandlerError(@Nullable JSCallback callback) {
        StorageResultHandler.handleResult(callback, RESULT_FAILED, RESULT_FAILED_NO_HANDLER);
    }

    public static void handleInvalidParam(@Nullable JSCallback callback) {
        StorageResultHandler.handleResult(callback, RESULT_FAILED, RESULT_FAILED_INVALID_PARAM);
    }
}

