/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex.adapter;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.util.List;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.adapter.URIAdapter;

public class DefaultUriAdapter
implements URIAdapter {
    @Override
    @NonNull
    public Uri rewrite(WXSDKInstance instance, String type, Uri uri) {
        return this.rewrite(instance.getBundleUrl(), type, uri);
    }

    @Override
    @NonNull
    public Uri rewrite(String bundleURL, String type, Uri uri) {
        if (TextUtils.isEmpty((CharSequence)bundleURL)) {
            return uri;
        }
        Uri base = Uri.parse((String)bundleURL);
        Uri.Builder resultBuilder = uri.buildUpon();
        if (uri.isRelative()) {
            if (uri.getEncodedPath().length() == 0) {
                if ("image".equals(type) && TextUtils.isEmpty((CharSequence)uri.toString())) {
                    return uri;
                }
                return base;
            }
            resultBuilder = this.buildRelativeURI(resultBuilder, base, uri);
            return resultBuilder.build();
        }
        return uri;
    }

    private Uri.Builder buildRelativeURI(Uri.Builder resultBuilder, Uri base, Uri uri) {
        if (uri.getAuthority() != null) {
            return resultBuilder.scheme(base.getScheme());
        }
        resultBuilder.encodedAuthority(base.getEncodedAuthority()).scheme(base.getScheme()).path(null);
        if (uri.getPath().startsWith("/")) {
            resultBuilder.appendEncodedPath(uri.getEncodedPath().substring(1));
        } else {
            List segments = base.getPathSegments();
            int ignoreLast = 1;
            if (base.getPath().endsWith("/")) {
                ignoreLast = 0;
            }
            int len = segments.size() - ignoreLast;
            for (int i = 0; i < len; ++i) {
                resultBuilder.appendEncodedPath((String)segments.get(i));
            }
            resultBuilder.appendEncodedPath(uri.getEncodedPath());
        }
        return resultBuilder;
    }
}

