/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.Log;
import android.view.Choreographer;
import java.lang.ref.WeakReference;
import org.apache.weex.WXSDKInstance;
import org.apache.weex.WXSDKManager;
import org.apache.weex.common.WXErrorCode;

public class WeexFrameRateControl {
    private static final long VSYNC_FRAME = 16L;
    private WeakReference<VSyncListener> mListener;
    private final Choreographer mChoreographer;
    private final Choreographer.FrameCallback mVSyncFrameCallback;
    private final Runnable runnable;

    public WeexFrameRateControl(VSyncListener listener) {
        this.mListener = new WeakReference<VSyncListener>(listener);
        if (Build.VERSION.SDK_INT > 15) {
            this.mChoreographer = Choreographer.getInstance();
            this.mVSyncFrameCallback = new Choreographer.FrameCallback(){

                @SuppressLint(value={"NewApi"})
                public void doFrame(long frameTimeNanos) {
                    block3: {
                        VSyncListener vSyncListener;
                        if (WeexFrameRateControl.this.mListener != null && (vSyncListener = (VSyncListener)WeexFrameRateControl.this.mListener.get()) != null) {
                            try {
                                vSyncListener.OnVSync();
                                WeexFrameRateControl.this.mChoreographer.postFrameCallback(WeexFrameRateControl.this.mVSyncFrameCallback);
                            }
                            catch (UnsatisfiedLinkError e) {
                                if (!(vSyncListener instanceof WXSDKInstance)) break block3;
                                ((WXSDKInstance)((Object)vSyncListener)).onRenderError(WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode(), Log.getStackTraceString((Throwable)e));
                            }
                        }
                    }
                }
            };
            this.runnable = null;
        } else {
            this.runnable = new Runnable(){

                @Override
                public void run() {
                    block3: {
                        VSyncListener vSyncListener;
                        if (WeexFrameRateControl.this.mListener != null && (vSyncListener = (VSyncListener)WeexFrameRateControl.this.mListener.get()) != null) {
                            try {
                                vSyncListener.OnVSync();
                                WXSDKManager.getInstance().getWXRenderManager().postOnUiThread(WeexFrameRateControl.this.runnable, 16L);
                            }
                            catch (UnsatisfiedLinkError e) {
                                if (!(vSyncListener instanceof WXSDKInstance)) break block3;
                                ((WXSDKInstance)((Object)vSyncListener)).onRenderError(WXErrorCode.WX_DEGRAD_ERR_INSTANCE_CREATE_FAILED.getErrorCode(), Log.getStackTraceString((Throwable)e));
                            }
                        }
                    }
                }
            };
            this.mChoreographer = null;
            this.mVSyncFrameCallback = null;
        }
    }

    @SuppressLint(value={"NewApi"})
    public void start() {
        if (this.mChoreographer != null) {
            this.mChoreographer.postFrameCallback(this.mVSyncFrameCallback);
        } else if (this.runnable != null) {
            WXSDKManager.getInstance().getWXRenderManager().postOnUiThread(this.runnable, 16L);
        }
    }

    @SuppressLint(value={"NewApi"})
    public void stop() {
        if (this.mChoreographer != null) {
            this.mChoreographer.removeFrameCallback(this.mVSyncFrameCallback);
        } else if (this.runnable != null) {
            WXSDKManager.getInstance().getWXRenderManager().removeTask(this.runnable);
        }
    }

    public static interface VSyncListener {
        public void OnVSync();
    }
}

