/*
 * Decompiled with CFR 0.152.
 */
package org.apache.weex;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.weex.InitConfig;
import org.apache.weex.WXEnvironment;
import org.apache.weex.WXGlobalEventModule;
import org.apache.weex.WXSDKManager;
import org.apache.weex.adapter.IDrawableLoader;
import org.apache.weex.adapter.IWXHttpAdapter;
import org.apache.weex.adapter.IWXImgLoaderAdapter;
import org.apache.weex.adapter.IWXJSExceptionAdapter;
import org.apache.weex.adapter.IWXJsFileLoaderAdapter;
import org.apache.weex.adapter.IWXUserTrackAdapter;
import org.apache.weex.appfram.clipboard.WXClipboardModule;
import org.apache.weex.appfram.navigator.IActivityNavBarSetter;
import org.apache.weex.appfram.navigator.INavigator;
import org.apache.weex.appfram.navigator.WXNavigatorModule;
import org.apache.weex.appfram.pickers.WXPickersModule;
import org.apache.weex.appfram.storage.IWXStorageAdapter;
import org.apache.weex.appfram.storage.WXStorageModule;
import org.apache.weex.appfram.websocket.WebSocketModule;
import org.apache.weex.bridge.ModuleFactory;
import org.apache.weex.bridge.WXBridgeManager;
import org.apache.weex.bridge.WXModuleManager;
import org.apache.weex.bridge.WXServiceManager;
import org.apache.weex.common.Destroyable;
import org.apache.weex.common.TypeModuleFactory;
import org.apache.weex.common.WXErrorCode;
import org.apache.weex.common.WXException;
import org.apache.weex.common.WXInstanceWrap;
import org.apache.weex.common.WXModule;
import org.apache.weex.http.WXStreamModule;
import org.apache.weex.performance.WXStateRecord;
import org.apache.weex.ui.ExternalLoaderComponentHolder;
import org.apache.weex.ui.IExternalComponentGetter;
import org.apache.weex.ui.IExternalModuleGetter;
import org.apache.weex.ui.IFComponentHolder;
import org.apache.weex.ui.SimpleComponentHolder;
import org.apache.weex.ui.WXComponentRegistry;
import org.apache.weex.ui.animation.WXAnimationModule;
import org.apache.weex.ui.component.Textarea;
import org.apache.weex.ui.component.WXA;
import org.apache.weex.ui.component.WXComponent;
import org.apache.weex.ui.component.WXDiv;
import org.apache.weex.ui.component.WXEmbed;
import org.apache.weex.ui.component.WXHeader;
import org.apache.weex.ui.component.WXImage;
import org.apache.weex.ui.component.WXIndicator;
import org.apache.weex.ui.component.WXInput;
import org.apache.weex.ui.component.WXLoading;
import org.apache.weex.ui.component.WXLoadingIndicator;
import org.apache.weex.ui.component.WXRefresh;
import org.apache.weex.ui.component.WXScroller;
import org.apache.weex.ui.component.WXSlider;
import org.apache.weex.ui.component.WXSliderNeighbor;
import org.apache.weex.ui.component.WXSwitch;
import org.apache.weex.ui.component.WXText;
import org.apache.weex.ui.component.WXVideo;
import org.apache.weex.ui.component.WXWeb;
import org.apache.weex.ui.component.list.HorizontalListComponent;
import org.apache.weex.ui.component.list.SimpleListComponent;
import org.apache.weex.ui.component.list.WXCell;
import org.apache.weex.ui.component.list.WXListComponent;
import org.apache.weex.ui.component.list.template.WXRecyclerTemplateList;
import org.apache.weex.ui.component.richtext.WXRichText;
import org.apache.weex.ui.config.AutoScanConfigRegister;
import org.apache.weex.ui.module.ConsoleLogModule;
import org.apache.weex.ui.module.WXDeviceInfoModule;
import org.apache.weex.ui.module.WXLocaleModule;
import org.apache.weex.ui.module.WXMetaModule;
import org.apache.weex.ui.module.WXModalUIModule;
import org.apache.weex.ui.module.WXTimerModule;
import org.apache.weex.ui.module.WXWebViewModule;
import org.apache.weex.utils.LogLevel;
import org.apache.weex.utils.WXExceptionUtils;
import org.apache.weex.utils.WXLogUtils;
import org.apache.weex.utils.WXSoInstallMgrSdk;
import org.apache.weex.utils.batch.BatchOperationHelper;
import org.apache.weex.utils.cache.RegisterCache;

public class WXSDKEngine
implements Serializable {
    public static final String JS_FRAMEWORK_RELOAD = "js_framework_reload";
    private static final String V8_SO_NAME = "weexcore";
    private static volatile boolean mIsInit = false;
    private static volatile boolean mIsSoInit = false;
    private static final Object mLock = new Object();
    private static final String TAG = "WXSDKEngine";

    @Deprecated
    public static void init(Application application) {
        WXSDKEngine.init(application, null);
    }

    @Deprecated
    public static void init(Application application, IWXUserTrackAdapter utAdapter) {
        WXSDKEngine.init(application, utAdapter, null);
    }

    @Deprecated
    public static void init(Application application, IWXUserTrackAdapter utAdapter, String framework) {
        WXSDKEngine.initialize(application, new InitConfig.Builder().setUtAdapter(utAdapter).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInitialized() {
        Object object = mLock;
        synchronized (object) {
            return mIsInit && WXEnvironment.JsFrameworkInit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSoInitialized() {
        Object object = mLock;
        synchronized (object) {
            return mIsSoInit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(Application application, InitConfig config) {
        Object object = mLock;
        synchronized (object) {
            long start;
            if (mIsInit) {
                return;
            }
            WXEnvironment.sSDKInitStart = start = System.currentTimeMillis();
            WXEnvironment.sLogLevel = WXEnvironment.isApkDebugable(application) ? LogLevel.DEBUG : LogLevel.WARN;
            WXSDKEngine.doInitInternal(application, config);
            WXSDKEngine.registerApplicationOptions(application);
            WXEnvironment.sSDKInitInvokeTime = System.currentTimeMillis() - start;
            WXLogUtils.renderPerformanceLog("SDKInitInvokeTime", WXEnvironment.sSDKInitInvokeTime);
            mIsInit = true;
        }
    }

    private static void registerApplicationOptions(Application application) {
        if (application == null) {
            WXLogUtils.e(TAG, "RegisterApplicationOptions application is null");
            return;
        }
        Resources resources = application.getResources();
        WXSDKEngine.registerCoreEnv("screen_width_pixels", String.valueOf(resources.getDisplayMetrics().widthPixels));
        WXSDKEngine.registerCoreEnv("screen_height_pixels", String.valueOf(resources.getDisplayMetrics().heightPixels));
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            int statusBarHeight = resources.getDimensionPixelSize(resourceId);
            WXSDKEngine.registerCoreEnv("status_bar_height", String.valueOf(statusBarHeight));
        }
    }

    private static void doInitInternal(final Application application, final InitConfig config) {
        WXEnvironment.sApplication = application;
        if (application == null) {
            WXLogUtils.e(TAG, " doInitInternal application is null");
            WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT, "doInitInternal", WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT.getErrorMsg() + "WXEnvironment sApplication is null", null);
        }
        WXEnvironment.JsFrameworkInit = false;
        WXBridgeManager.getInstance().postWithName(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                WXSDKManager sm = WXSDKManager.getInstance();
                sm.onSDKEngineInitialize();
                if (config != null) {
                    sm.setInitConfig(config);
                }
                WXSoInstallMgrSdk.init(application, sm.getIWXSoLoaderAdapter(), sm.getWXStatisticsListener());
                IWXUserTrackAdapter userTrackAdapter = config != null ? config.getUtAdapter() : null;
                boolean version = true;
                mIsSoInit = WXSoInstallMgrSdk.initSo(WXSDKEngine.V8_SO_NAME, 1, userTrackAdapter);
                WXSoInstallMgrSdk.copyJssRuntimeSo();
                if (config != null) {
                    for (String libraryName : config.getNativeLibraryList()) {
                        WXSoInstallMgrSdk.initSo(libraryName, 1, userTrackAdapter);
                    }
                }
                if (!mIsSoInit) {
                    WXExceptionUtils.commitCriticalExceptionRT(null, WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT, "doInitInternal", WXErrorCode.WX_KEY_EXCEPTION_SDK_INIT.getErrorMsg() + "isSoInit false", null);
                    return;
                }
                sm.initScriptsFramework(config != null ? config.getFramework() : null);
                WXEnvironment.sSDKInitExecuteTime = System.currentTimeMillis() - start;
                WXLogUtils.renderPerformanceLog("SDKInitExecuteTime", WXEnvironment.sSDKInitExecuteTime);
            }
        }, null, "doInitWeexSdkInternal");
        WXStateRecord.getInstance().startJSThreadWatchDog();
        WXSDKEngine.register();
    }

    @Deprecated
    public static void init(Application application, String framework, IWXUserTrackAdapter utAdapter, IWXImgLoaderAdapter imgLoaderAdapter, IWXHttpAdapter httpAdapter) {
        WXSDKEngine.initialize(application, new InitConfig.Builder().setUtAdapter(utAdapter).setHttpAdapter(httpAdapter).setImgAdapter(imgLoaderAdapter).build());
    }

    public static void setJSExcetptionAdapter(IWXJSExceptionAdapter excetptionAdapter) {
        WXSDKManager.getInstance().setIWXJSExceptionAdapter(excetptionAdapter);
    }

    private static void register() {
        BatchOperationHelper batchHelper = new BatchOperationHelper(WXBridgeManager.getInstance());
        try {
            WXSDKEngine.registerComponent(new SimpleComponentHolder(WXText.class, new WXText.Creator()), false, "text");
            WXSDKEngine.registerComponent(new SimpleComponentHolder(WXDiv.class, new WXDiv.Ceator()), false, "container", "div", "header", "footer");
            WXSDKEngine.registerComponent(new SimpleComponentHolder(WXImage.class, new WXImage.Creator()), false, "image", "img");
            WXSDKEngine.registerComponent(new SimpleComponentHolder(WXScroller.class, new WXScroller.Creator()), false, "scroller");
            WXSDKEngine.registerComponent(new SimpleComponentHolder(WXSlider.class, new WXSlider.Creator()), true, "slider", "cycleslider");
            WXSDKEngine.registerComponent(new SimpleComponentHolder(WXSliderNeighbor.class, new WXSliderNeighbor.Creator()), true, "slider-neighbor");
            WXSDKEngine.registerComponent(new SimpleComponentHolder(WXCell.class, new WXCell.Creator()), true, "cell");
            WXSDKEngine.registerComponent(new SimpleComponentHolder(WXListComponent.class, new WXListComponent.Creator()), true, "list", "vlist", "recycler", "waterfall");
            WXSDKEngine.registerComponent(new SimpleComponentHolder(WXRichText.class, new WXRichText.Creator()), false, "richtext");
            String simpleList = "simplelist";
            WXSDKEngine.registerComponent(SimpleListComponent.class, false, simpleList);
            WXSDKEngine.registerComponent(WXRecyclerTemplateList.class, false, "recycle-list");
            WXSDKEngine.registerComponent(HorizontalListComponent.class, false, "hlist");
            WXSDKEngine.registerComponent("cell-slot", WXCell.class, true);
            WXSDKEngine.registerComponent("indicator", WXIndicator.class, true);
            WXSDKEngine.registerComponent("video", WXVideo.class, false);
            WXSDKEngine.registerComponent("input", WXInput.class, false);
            WXSDKEngine.registerComponent("textarea", Textarea.class, false);
            WXSDKEngine.registerComponent("switch", WXSwitch.class, false);
            WXSDKEngine.registerComponent("a", WXA.class, false);
            WXSDKEngine.registerComponent("embed", WXEmbed.class, true);
            WXSDKEngine.registerComponent("web", WXWeb.class);
            WXSDKEngine.registerComponent("refresh", WXRefresh.class);
            WXSDKEngine.registerComponent("loading", WXLoading.class);
            WXSDKEngine.registerComponent("loading-indicator", WXLoadingIndicator.class);
            WXSDKEngine.registerComponent("header", WXHeader.class);
            WXSDKEngine.registerModule("modal", WXModalUIModule.class);
            WXSDKEngine.registerModule("instanceWrap", WXInstanceWrap.class);
            WXSDKEngine.registerModule("animation", WXAnimationModule.class);
            WXSDKEngine.registerModule("webview", WXWebViewModule.class);
            WXSDKEngine.registerModule("navigator", WXNavigatorModule.class);
            WXSDKEngine.registerModule("stream", WXStreamModule.class);
            WXSDKEngine.registerModule("timer", WXTimerModule.class);
            WXSDKEngine.registerModule("storage", WXStorageModule.class);
            WXSDKEngine.registerModule("clipboard", WXClipboardModule.class);
            WXSDKEngine.registerModule("globalEvent", WXGlobalEventModule.class);
            WXSDKEngine.registerModule("picker", WXPickersModule.class);
            WXSDKEngine.registerModule("meta", WXMetaModule.class);
            WXSDKEngine.registerModule("webSocket", WebSocketModule.class);
            WXSDKEngine.registerModule("locale", WXLocaleModule.class);
            WXSDKEngine.registerModule("deviceInfo", WXDeviceInfoModule.class);
            WXSDKEngine.registerModule("sdk-console-log", ConsoleLogModule.class);
        }
        catch (WXException e) {
            WXLogUtils.e("[WXSDKEngine] register:", e);
        }
        if (RegisterCache.getInstance().enableAutoScan()) {
            AutoScanConfigRegister.doScanConfig();
        }
        batchHelper.flush();
    }

    public static boolean registerComponent(String type, Class<? extends WXComponent> clazz, boolean appendTree) throws WXException {
        return WXSDKEngine.registerComponent(clazz, appendTree, type);
    }

    public static boolean registerComponent(String type, IExternalComponentGetter componentGetter, boolean appendTree) throws WXException {
        return WXSDKEngine.registerComponent(new ExternalLoaderComponentHolder(type, componentGetter), appendTree, type);
    }

    public static boolean registerComponent(Class<? extends WXComponent> clazz, boolean appendTree, String ... names) throws WXException {
        if (clazz == null) {
            return false;
        }
        SimpleComponentHolder holder = new SimpleComponentHolder(clazz);
        return WXSDKEngine.registerComponent(holder, appendTree, names);
    }

    public static boolean registerComponent(IFComponentHolder holder, boolean appendTree, String ... names) throws WXException {
        boolean result = true;
        try {
            for (String name : names) {
                HashMap<String, Object> componentInfo = new HashMap<String, Object>();
                if (appendTree) {
                    componentInfo.put("append", "tree");
                }
                result = result && WXComponentRegistry.registerComponent(name, holder, componentInfo);
            }
            return result;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return result;
        }
    }

    public static <T extends WXModule> boolean registerModule(String moduleName, Class<T> moduleClass, boolean global) throws WXException {
        return moduleClass != null && WXSDKEngine.registerModule(moduleName, new TypeModuleFactory<T>(moduleClass), global);
    }

    public static <T extends WXModule> boolean registerModuleWithFactory(String moduleName, DestroyableModuleFactory factory, boolean global) throws WXException {
        return WXSDKEngine.registerModule(moduleName, factory, global);
    }

    public static <T extends WXModule> boolean registerModuleWithFactory(String moduleName, IExternalModuleGetter factory, boolean global) throws WXException {
        return WXSDKEngine.registerModule(moduleName, factory.getExternalModuleClass(moduleName, (Context)WXEnvironment.getApplication()), global);
    }

    public static <T extends WXModule> boolean registerModule(String moduleName, ModuleFactory factory, boolean global) throws WXException {
        return WXModuleManager.registerModule(moduleName, factory, global);
    }

    public static boolean registerModule(String moduleName, Class<? extends WXModule> moduleClass) throws WXException {
        return WXSDKEngine.registerModule(moduleName, moduleClass, false);
    }

    public static boolean registerService(String name, String serviceScript, Map<String, Object> options) {
        return WXServiceManager.registerService(name, serviceScript, options);
    }

    public static boolean unRegisterService(String name) {
        return WXServiceManager.unRegisterService(name);
    }

    public static void callback(String instanceId, String funcId, Map<String, Object> data) {
        WXSDKManager.getInstance().callback(instanceId, funcId, data);
    }

    public static void restartBridge(boolean debug) {
        WXEnvironment.sDebugMode = debug;
        WXSDKManager.getInstance().restartBridge();
    }

    public static boolean registerComponent(String type, Class<? extends WXComponent> clazz) throws WXException {
        return WXComponentRegistry.registerComponent(type, new SimpleComponentHolder(clazz), new HashMap<String, Object>());
    }

    public static boolean registerComponent(Map<String, Object> componentInfo, Class<? extends WXComponent> clazz) throws WXException {
        if (componentInfo == null) {
            return false;
        }
        String type = (String)componentInfo.get("type");
        if (TextUtils.isEmpty((CharSequence)type)) {
            return false;
        }
        return WXComponentRegistry.registerComponent(type, new SimpleComponentHolder(clazz), componentInfo);
    }

    public static void addCustomOptions(String key, String value) {
        WXEnvironment.addCustomOptions(key, value);
    }

    public static IWXUserTrackAdapter getIWXUserTrackAdapter() {
        return WXSDKManager.getInstance().getIWXUserTrackAdapter();
    }

    public static IWXImgLoaderAdapter getIWXImgLoaderAdapter() {
        return WXSDKManager.getInstance().getIWXImgLoaderAdapter();
    }

    public static IDrawableLoader getDrawableLoader() {
        return WXSDKManager.getInstance().getDrawableLoader();
    }

    public static IWXHttpAdapter getIWXHttpAdapter() {
        return WXSDKManager.getInstance().getIWXHttpAdapter();
    }

    public static IWXStorageAdapter getIWXStorageAdapter() {
        return WXSDKManager.getInstance().getIWXStorageAdapter();
    }

    public static IWXJsFileLoaderAdapter getIWXJsFileLoaderAdapter() {
        return WXSDKManager.getInstance().getIWXJsFileLoaderAdapter();
    }

    public static IActivityNavBarSetter getActivityNavBarSetter() {
        return WXSDKManager.getInstance().getActivityNavBarSetter();
    }

    public static INavigator getNavigator() {
        return WXSDKManager.getInstance().getNavigator();
    }

    public static void setNavigator(INavigator navigator) {
        WXSDKManager.getInstance().setNavigator(navigator);
    }

    public static void setActivityNavBarSetter(IActivityNavBarSetter activityNavBarSetter) {
        WXSDKManager.getInstance().setActivityNavBarSetter(activityNavBarSetter);
    }

    public static void reload(final Context context, String framework, boolean remoteDebug) {
        WXEnvironment.sRemoteDebugMode = remoteDebug;
        WXBridgeManager.getInstance().restart();
        WXBridgeManager.getInstance().initScriptsFramework(framework);
        WXServiceManager.reload();
        WXModuleManager.reload();
        WXComponentRegistry.reload();
        WXSDKManager.getInstance().postOnUiThread(new Runnable(){

            @Override
            public void run() {
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(new Intent(WXSDKEngine.JS_FRAMEWORK_RELOAD));
            }
        }, 0L);
    }

    public static void reload(Context context, boolean remoteDebug) {
        WXSDKEngine.reload(context, null, remoteDebug);
    }

    public static void reload() {
        WXSDKEngine.reload((Context)WXEnvironment.getApplication(), WXEnvironment.sRemoteDebugMode);
    }

    public static void registerCoreEnv(String key, String value) {
        WXBridgeManager.getInstance().registerCoreEnv(key, value);
    }

    public static abstract class DestroyableModuleFactory<T extends DestroyableModule>
    extends TypeModuleFactory<T> {
        public DestroyableModuleFactory(Class<T> clz) {
            super(clz);
        }
    }

    public static abstract class DestroyableModule
    extends WXModule
    implements Destroyable {
    }
}

