/*
 * Copyright (c) 1997, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package jakarta.resource.spi.work;

/**
 * This models a <code>Work</code> instance that would be executed by a 
 * <code>WorkManager</code> upon submission.
 *
 * @version 1.0
 * @author  Ram Jeyaraman
 */
public interface Work extends Runnable {

    /**
     * The <code>WorkManager</code> might call this method to hint the
     * active <code>Work</code> instance to complete execution as soon as 
     * possible. This would be called on a separate thread other than the
     * one currently executing the <code>Work</code> instance.
     */
    void release();
}
