/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.metadata.TikaPagedText;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PDFRenderingTest
extends TikaTest {
    @Test
    public void testDefault() throws Exception {
        List metadataList = this.getRecursiveMetadata("testPDF.pdf");
        Assertions.assertEquals((int)1, (int)metadataList.size());
    }

    @Test
    public void testBasic() throws Exception {
        ParseContext parseContext = this.configureParseContext();
        TikaConfig config = this.getConfig("tika-rendering-config.xml");
        AutoDetectParser p = new AutoDetectParser(config);
        List metadataList = this.getRecursiveMetadata("testPDF.pdf", (Parser)p, parseContext);
        Map<Integer, byte[]> embedded = ((RenderCaptureExtractor)((Object)parseContext.get(EmbeddedDocumentExtractor.class))).getEmbedded();
        Assertions.assertEquals((int)1, (int)embedded.size());
        Assertions.assertTrue((boolean)embedded.containsKey(0));
        Assertions.assertTrue((embedded.get(0).length > 1000 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)metadataList.size());
        Metadata tiffMetadata = (Metadata)metadataList.get(1);
        Assertions.assertEquals((Object)"RENDERING", (Object)tiffMetadata.get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE));
        Assertions.assertEquals((int)1, (Integer)tiffMetadata.getInt(TikaPagedText.PAGE_NUMBER));
    }

    @Test
    public void testRotated() throws Exception {
        ParseContext parseContext = this.configureParseContext();
        TikaConfig config = this.getConfig("tika-rendering-config.xml");
        AutoDetectParser p = new AutoDetectParser(config);
        List metadataList = this.getRecursiveMetadata("testPDF_rotated.pdf", (Parser)p, parseContext);
        Map<Integer, byte[]> embedded = ((RenderCaptureExtractor)((Object)parseContext.get(EmbeddedDocumentExtractor.class))).getEmbedded();
        Assertions.assertEquals((int)1, (int)embedded.size());
        Assertions.assertTrue((boolean)embedded.containsKey(0));
        Assertions.assertTrue((embedded.get(0).length > 1000 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)metadataList.size());
        Metadata tiffMetadata = (Metadata)metadataList.get(1);
        Assertions.assertEquals((Object)"RENDERING", (Object)tiffMetadata.get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE));
        Assertions.assertEquals((int)1, (Integer)tiffMetadata.getInt(TikaPagedText.PAGE_NUMBER));
        Assertions.assertEquals((double)90.0, (double)Double.parseDouble(tiffMetadata.get(TikaPagedText.PAGE_ROTATION)), (double)0.1);
    }

    private TikaConfig getConfig(String path) throws TikaException, IOException, SAXException {
        try (InputStream is = PDFRenderingTest.class.getResourceAsStream(path);){
            TikaConfig tikaConfig = new TikaConfig(is);
            return tikaConfig;
        }
    }

    private ParseContext configureParseContext() {
        ParseContext parseContext = new ParseContext();
        parseContext.set(EmbeddedDocumentExtractor.class, (Object)new RenderCaptureExtractor(parseContext));
        return parseContext;
    }

    private class RenderCaptureExtractor
    extends ParsingEmbeddedDocumentExtractor {
        private int count;
        Map<Integer, byte[]> embedded;

        public RenderCaptureExtractor(ParseContext context) {
            super(context);
            this.count = 0;
            this.embedded = new HashMap<Integer, byte[]>();
        }

        public void parseEmbedded(InputStream stream, ContentHandler handler, Metadata metadata, boolean outputHtml) throws SAXException, IOException {
            TikaInputStream tstream = TikaInputStream.get((InputStream)stream);
            byte[] bytes = Files.readAllBytes(tstream.getPath());
            this.embedded.put(this.count++, bytes);
            try (InputStream is = Files.newInputStream(tstream.getPath(), new OpenOption[0]);){
                super.parseEmbedded(is, handler, metadata, outputHtml);
            }
        }

        public Map<Integer, byte[]> getEmbedded() {
            return this.embedded;
        }
    }
}

