/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.mapreduce.input.base;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapred.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.split.TezGroupedSplitsInputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.mapreduce.hadoop.MRInputHelpers;
import org.apache.tez.mapreduce.protos.MRRuntimeProtos;
import org.apache.tez.runtime.api.AbstractLogicalInput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.Reader;

@InterfaceAudience.Private
public abstract class MRInputBase
extends AbstractLogicalInput {
    protected JobConf jobConf;
    protected TezCounter inputRecordCounter;
    @InterfaceAudience.Private
    protected boolean useNewApi;

    public MRInputBase(InputContext inputContext, int numPhysicalInputs) {
        super(inputContext, numPhysicalInputs);
    }

    public Reader getReader() throws Exception {
        return null;
    }

    public List<Event> initialize() throws IOException {
        this.getContext().requestInitialMemory(0L, null);
        MRRuntimeProtos.MRInputUserPayloadProto mrUserPayload = MRInputHelpers.parseMRInputPayload(this.getContext().getUserPayload());
        boolean isGrouped = mrUserPayload.getGroupingEnabled();
        Preconditions.checkArgument((!mrUserPayload.hasSplits() ? 1 : 0) != 0, (Object)("Split information not expected in " + ((Object)((Object)this)).getClass().getName()));
        Configuration conf = TezUtils.createConfFromByteString((ByteString)mrUserPayload.getConfigurationBytes());
        this.jobConf = new JobConf(conf);
        this.useNewApi = this.jobConf.getUseNewMapper();
        if (isGrouped) {
            if (this.useNewApi) {
                this.jobConf.set("mapreduce.job.inputformat.class", TezGroupedSplitsInputFormat.class.getName());
            } else {
                this.jobConf.set("mapred.input.format.class", org.apache.hadoop.mapred.split.TezGroupedSplitsInputFormat.class.getName());
            }
        }
        this.jobConf.getCredentials().mergeAll(UserGroupInformation.getCurrentUser().getCredentials());
        TaskAttemptID taskAttemptId = new TaskAttemptID(new TaskID(Long.toString(this.getContext().getApplicationId().getClusterTimestamp()), this.getContext().getApplicationId().getId(), TaskType.MAP, this.getContext().getTaskIndex()), this.getContext().getTaskAttemptNumber());
        this.jobConf.set("mapreduce.task.attempt.id", taskAttemptId.toString());
        this.jobConf.setInt("mapreduce.job.application.attempt.id", this.getContext().getDAGAttemptNumber());
        this.jobConf.setInt("tez.mapreduce.dag.index", this.getContext().getDagIdentifier());
        this.jobConf.setInt("tez.mapreduce.vertex.index", this.getContext().getTaskVertexIndex());
        this.jobConf.setInt("tez.mapreduce.task.index", this.getContext().getTaskIndex());
        this.jobConf.setInt("tez.mapreduce.task.attempt.index", this.getContext().getTaskAttemptNumber());
        this.jobConf.set("tez.mapreduce.dag.name", this.getContext().getDAGName());
        this.jobConf.set("tez.mapreduce.vertex.name", this.getContext().getTaskVertexName());
        this.jobConf.setInt("tez.mapreduce.input.index", this.getContext().getInputIndex());
        this.jobConf.set("tez.mapreduce.input.name", this.getContext().getSourceVertexName());
        this.jobConf.set("tez.mapreduce.application.id", this.getContext().getApplicationId().toString());
        this.jobConf.set("tez.mapreduce.unique.identifier", this.getContext().getUniqueIdentifier());
        this.jobConf.setInt("tez.mapreduce.dag.attempt.number", this.getContext().getDAGAttemptNumber());
        TezDAGID tezDAGID = TezDAGID.getInstance((ApplicationId)this.getContext().getApplicationId(), (int)this.getContext().getDagIdentifier());
        TezVertexID tezVertexID = TezVertexID.getInstance((TezDAGID)tezDAGID, (int)this.getContext().getTaskVertexIndex());
        TezTaskID tezTaskID = TezTaskID.getInstance((TezVertexID)tezVertexID, (int)this.getContext().getTaskIndex());
        TezTaskAttemptID tezTaskAttemptID = TezTaskAttemptID.getInstance((TezTaskID)tezTaskID, (int)this.getContext().getTaskAttemptNumber());
        this.jobConf.set("tez.mapreduce.dag.id", tezDAGID.toString());
        this.jobConf.set("tez.mapreduce.vertex.id", tezVertexID.toString());
        this.jobConf.set("tez.mapreduce.task.id", tezTaskID.toString());
        this.jobConf.set("tez.mapreduce.task.attempt.id", tezTaskAttemptID.toString());
        this.inputRecordCounter = this.getContext().getCounters().findCounter((Enum)TaskCounter.INPUT_RECORDS_PROCESSED);
        return null;
    }
}

