/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import org.apache.tapestry5.internal.plastic.Cache;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.PlasticUtils;

public class NameCache {
    private final Cache<String, String> class2internal = new Cache<String, String>(){

        @Override
        protected String convert(String className) {
            return PlasticInternalUtils.toInternalName(className);
        }
    };
    private final Cache<Class, String> type2internal = new Cache<Class, String>(){

        @Override
        protected String convert(Class input) {
            return NameCache.this.toInternalName(input.getName());
        }
    };
    private final Cache<MethodDescription, String> md2desc = new Cache<MethodDescription, String>(){

        @Override
        protected String convert(MethodDescription methodDescription) {
            return NameCache.this.toMethodDescriptor(methodDescription.returnType, methodDescription.argumentTypes);
        }
    };
    private final Cache<String, String> type2desc = new Cache<String, String>(){

        @Override
        protected String convert(String typeName) {
            return PlasticInternalUtils.toDescriptor(typeName);
        }
    };
    private final Cache<Class, String> typeToTypeName = new Cache<Class, String>(){

        @Override
        protected String convert(Class type) {
            return PlasticUtils.toTypeName(type);
        }
    };

    public String toInternalName(String className) {
        return this.class2internal.get(className);
    }

    public String toInternalName(Class type) {
        return this.type2internal.get(type);
    }

    public String toDesc(MethodDescription md) {
        return this.md2desc.get(md);
    }

    public String toDesc(String typeName) {
        return this.type2desc.get(typeName);
    }

    public String toTypeName(Class type) {
        return this.typeToTypeName.get(type);
    }

    public String[] toTypeNames(Class ... types) {
        String[] result = new String[types.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.toTypeName(types[i]);
        }
        return result;
    }

    public String toMethodDescriptor(Class returnType, Class ... argumentTypes) {
        return this.toMethodDescriptor(this.toTypeName(returnType), this.toTypeNames(argumentTypes));
    }

    public String toMethodDescriptor(String returnType, String ... argumentTypes) {
        StringBuilder builder = new StringBuilder("(");
        for (String argumentType : argumentTypes) {
            builder.append(this.toDesc(argumentType));
        }
        builder.append(")").append(this.toDesc(returnType));
        return builder.toString();
    }
}

