/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.plastic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.plastic.StaticContext;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.InstanceContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInstantiatorImpl<T>
implements ClassInstantiator<T>,
InstanceContext {
    private final Class clazz;
    private final Constructor<T> ctor;
    private final StaticContext staticContext;
    private final ClassInstantiatorImpl<T> parent;
    private final Class withType;
    private final Object withValue;

    ClassInstantiatorImpl(Class<T> clazz, Constructor ctor, StaticContext staticContext) {
        this(clazz, ctor, staticContext, null, null, null);
    }

    private <W> ClassInstantiatorImpl(Class clazz, Constructor ctor, StaticContext staticContext, ClassInstantiatorImpl<T> parent, Class<W> withType, W withValue) {
        this.clazz = clazz;
        this.ctor = ctor;
        this.staticContext = staticContext;
        this.parent = parent;
        this.withType = withType;
        this.withValue = withValue;
    }

    @Override
    public <V> ClassInstantiator<T> with(Class<V> valueType, V instanceContextValue) {
        assert (valueType != null);
        assert (instanceContextValue != null);
        V existing = this.find(valueType);
        if (existing != null) {
            throw new IllegalStateException(String.format("An instance context value of type %s has already been added.", valueType.getName()));
        }
        return new ClassInstantiatorImpl<T>(this.clazz, this.ctor, this.staticContext, this.withType == null ? null : this, valueType, instanceContextValue);
    }

    public <V> V get(Class<V> valueType) {
        V result = this.find(valueType);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Instance context for class %s does not contain a value for type %s.", this.clazz.getName(), valueType));
        }
        return result;
    }

    private <V> V find(Class<V> valueType) {
        ClassInstantiatorImpl<T> cursor = this;
        while (cursor != null) {
            if (cursor.withType == valueType) {
                return valueType.cast(cursor.withValue);
            }
            cursor = cursor.parent;
        }
        return null;
    }

    @Override
    public T newInstance() {
        if (Modifier.isAbstract(this.clazz.getModifiers())) {
            throw new IllegalStateException(String.format("Class %s is abstract and can not be instantiated.", this.clazz.getName()));
        }
        try {
            return this.ctor.newInstance(this.staticContext, this);
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Unable to instantiate instance of transformed class %s: %s", this.clazz.getName(), PlasticInternalUtils.toMessage(ex)), ex);
        }
    }

    public Class<T> getInstanceType() {
        return this.clazz;
    }

    public String toString() {
        return String.format("ClassInstantiator[%s]", this.clazz.getName());
    }
}

