/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.subversion.javahl.ISVNRepos;
import org.apache.subversion.javahl.NativeResources;
import org.apache.subversion.javahl.ReposNotifyInformation;
import org.apache.subversion.javahl.SVNRepos;
import org.apache.subversion.javahl.callback.ReposNotifyCallback;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Depth;
import org.tigris.subversion.javahl.InputInterface;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.OutputInterface;
import org.tigris.subversion.javahl.Revision;
import org.tigris.subversion.javahl.SubversionException;
import org.tigris.subversion.javahl.Version;

public class SVNAdmin {
    private SVNRepos aSVNAdmin = new SVNRepos();
    protected long cppAddr = this.aSVNAdmin.getCppAddr();
    public static final String BDB = "bdb";
    public static final String FSFS = "fsfs";

    public void dispose() {
        this.aSVNAdmin.dispose();
    }

    protected void finalize() {
    }

    public Version getVersion() {
        return new Version(NativeResources.getVersion());
    }

    public void create(String path, boolean disableFsyncCommit, boolean keepLog, String configPath, String fstype) throws ClientException {
        try {
            this.aSVNAdmin.create(new File(path), disableFsyncCommit, keepLog, configPath == null ? null : new File(configPath), fstype);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void deltify(String path, Revision start, Revision end) throws ClientException {
        try {
            this.aSVNAdmin.deltify(new File(path), start == null ? null : start.toApache(), end == null ? null : end.toApache());
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void dump(String path, OutputInterface dataOut, OutputInterface errorOut, Revision start, Revision end, boolean incremental) throws ClientException {
        this.dump(path, dataOut, errorOut, start, end, incremental, false);
    }

    public void dump(String path, OutputInterface dataOut, OutputInterface errorOut, Revision start, Revision end, boolean incremental, boolean useDeltas) throws ClientException {
        try {
            this.aSVNAdmin.dump(new File(path), new OutputWrapper(dataOut), start == null ? null : start.toApache(), end == null ? null : end.toApache(), incremental, useDeltas, new ReposNotifyHandler(errorOut));
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void hotcopy(String path, String targetPath, boolean cleanLogs) throws ClientException {
        try {
            this.aSVNAdmin.hotcopy(new File(path), new File(targetPath), cleanLogs);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void listDBLogs(String path, MessageReceiver receiver) throws ClientException {
        try {
            this.aSVNAdmin.listDBLogs(new File(path), receiver);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void listUnusedDBLogs(String path, MessageReceiver receiver) throws ClientException {
        try {
            this.aSVNAdmin.listUnusedDBLogs(new File(path), receiver);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void load(String path, InputInterface dataInput, OutputInterface messageOutput, boolean ignoreUUID, boolean forceUUID, String relativePath) throws ClientException {
        this.load(path, dataInput, messageOutput, ignoreUUID, forceUUID, false, false, relativePath);
    }

    public void load(String path, InputInterface dataInput, OutputInterface messageOutput, boolean ignoreUUID, boolean forceUUID, boolean usePreCommitHook, boolean usePostCommitHook, String relativePath) throws ClientException {
        try {
            this.aSVNAdmin.load(new File(path), new InputWrapper(dataInput), ignoreUUID, forceUUID, usePreCommitHook, usePostCommitHook, relativePath, new ReposNotifyHandler(messageOutput));
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void lstxns(String path, MessageReceiver receiver) throws ClientException {
        try {
            this.aSVNAdmin.lstxns(new File(path), receiver);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public long recover(String path) throws ClientException {
        try {
            return this.aSVNAdmin.recover(new File(path), null);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void rmtxns(String path, String[] transactions) throws ClientException {
        try {
            this.aSVNAdmin.rmtxns(new File(path), transactions);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void setLog(String path, Revision rev, String message, boolean bypassHooks) throws ClientException {
        try {
            this.aSVNAdmin.setRevProp(new File(path), rev == null ? null : rev.toApache(), "svn:log", message, !bypassHooks, !bypassHooks);
        }
        catch (org.apache.subversion.javahl.SubversionException ex) {
            throw ClientException.fromException(ex);
        }
    }

    public void setRevProp(String path, Revision rev, String propName, String propValue, boolean usePreRevPropChangeHook, boolean usePostRevPropChangeHook) throws SubversionException {
        try {
            this.aSVNAdmin.setRevProp(new File(path), rev == null ? null : rev.toApache(), propName, propValue, usePreRevPropChangeHook, usePostRevPropChangeHook);
        }
        catch (org.apache.subversion.javahl.SubversionException ex) {
            throw new SubversionException(ex);
        }
    }

    public void verify(String path, OutputInterface messageOut, Revision start, Revision end) throws ClientException {
        try {
            this.aSVNAdmin.verify(new File(path), start == null ? null : start.toApache(), end == null ? null : end.toApache(), new ReposNotifyHandler(messageOut));
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public Lock[] lslocks(String path) throws ClientException {
        try {
            Set<org.apache.subversion.javahl.types.Lock> aLocks = this.aSVNAdmin.lslocks(new File(path), Depth.toADepth(3));
            Lock[] locks = new Lock[aLocks.size()];
            int i = 0;
            for (org.apache.subversion.javahl.types.Lock lock : aLocks) {
                locks[i] = new Lock(lock);
                ++i;
            }
            return locks;
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    public void rmlocks(String path, String[] locks) throws ClientException {
        try {
            this.aSVNAdmin.rmlocks(new File(path), locks);
        }
        catch (org.apache.subversion.javahl.ClientException ex) {
            throw new ClientException(ex);
        }
    }

    private class ReposNotifyHandler
    implements ReposNotifyCallback {
        private OutputInterface outputer;

        public ReposNotifyHandler(OutputInterface outputer) {
            this.outputer = outputer;
        }

        public void onNotify(ReposNotifyInformation info) {
            String val;
            block1 : switch (info.getAction()) {
                case warning: {
                    val = info.getWarning();
                    break;
                }
                case dump_rev_end: {
                    val = "* Dumped revision " + info.getRevision() + ".\n";
                    break;
                }
                case verify_rev_end: {
                    val = "* Verified revision " + info.getRevision() + ".\n";
                    break;
                }
                case load_txn_committed: {
                    if (info.getOldRevision() == -1L) {
                        val = "\n------- Committed revision " + info.getNewRevision() + " >>>\n\n";
                        break;
                    }
                    val = "\n------- Committed new rev " + info.getNewRevision() + " (loaded from original rev " + info.getOldRevision() + ") >>>\n\n";
                    break;
                }
                case load_node_start: {
                    switch (info.getNodeAction()) {
                        case change: {
                            val = "     * editing path : " + info.getPath() + " ...";
                            break block1;
                        }
                        case deleted: {
                            val = "     * deleting path : " + info.getPath() + " ...";
                            break block1;
                        }
                        case add: {
                            val = "     * adding path : " + info.getPath() + " ...";
                            break block1;
                        }
                        case replace: {
                            val = "     * replacing path : " + info.getPath() + " ...";
                            break block1;
                        }
                    }
                    val = null;
                    break;
                }
                case load_node_done: {
                    val = " done.\n";
                    break;
                }
                case load_copied_node: {
                    val = "COPIED...";
                    break;
                }
                case load_txn_start: {
                    val = "<<< Started new transaction, based on original revision " + info.getOldRevision() + "\n";
                    break;
                }
                case load_normalized_mergeinfo: {
                    val = " removing '\\r' from svn:mergeinfo ...";
                    break;
                }
                default: {
                    val = null;
                }
            }
            if (val != null) {
                try {
                    this.outputer.write(val.getBytes());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private class InputWrapper
    extends InputStream {
        private InputInterface inputer;

        InputWrapper(InputInterface inputer) {
            this.inputer = inputer;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.inputer.read(b) > 0) {
                return b[0];
            }
            return -1;
        }

        public int read(byte[] b) throws IOException {
            return this.inputer.read(b);
        }

        public void close() throws IOException {
            this.inputer.close();
        }
    }

    private class OutputWrapper
    extends OutputStream {
        private OutputInterface outputer;

        OutputWrapper(OutputInterface outputer) {
            this.outputer = outputer;
        }

        public void write(int b) throws IOException {
            this.outputer.write(new byte[]{(byte)(b & 0xFF)});
        }

        public void write(byte[] b) throws IOException {
            this.outputer.write(b);
        }

        public void close() throws IOException {
            this.outputer.close();
        }
    }

    public static interface MessageReceiver
    extends ISVNRepos.MessageReceiver {
    }
}

