/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.jasperreports;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.security.NotExcludedAcceptedPatternsChecker;
import com.opensymphony.xwork2.util.ValueStack;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.result.StrutsResultSupport;
import org.apache.struts2.views.jasperreports.JasperReportConstants;
import org.apache.struts2.views.jasperreports.ValueStackDataSource;
import org.apache.struts2.views.jasperreports.ValueStackShadowMap;

public class JasperReportsResult
extends StrutsResultSupport
implements JasperReportConstants {
    private static final long serialVersionUID = -2523174799621182907L;
    private static final Logger LOG = LogManager.getLogger(JasperReportsResult.class);
    protected String dataSource;
    private String parsedDataSource;
    protected String format;
    protected String documentName;
    protected String contentDisposition;
    protected String delimiter;
    protected String imageServletUrl = "/images/";
    protected String timeZone;
    protected boolean wrapField = true;
    protected String connection;
    protected String reportParameters;
    private String parsedReportParameters;
    protected String exportParameters;
    private String parsedExportParameters;
    private NotExcludedAcceptedPatternsChecker notExcludedAcceptedPatterns;

    public JasperReportsResult() {
    }

    public JasperReportsResult(String location) {
        super(location);
    }

    @Inject
    public void setNotExcludedAcceptedPatterns(NotExcludedAcceptedPatternsChecker notExcludedAcceptedPatterns) {
        this.notExcludedAcceptedPatterns = notExcludedAcceptedPatterns;
    }

    public String getImageServletUrl() {
        return this.imageServletUrl;
    }

    public void setImageServletUrl(String imageServletUrl) {
        this.imageServletUrl = imageServletUrl;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setDocumentName(String documentName) {
        this.documentName = documentName;
    }

    public void setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public void setWrapField(boolean wrapField) {
        this.wrapField = wrapField;
    }

    public String getReportParameters() {
        return this.reportParameters;
    }

    public void setReportParameters(String reportParameters) {
        this.reportParameters = reportParameters;
    }

    public String getExportParameters() {
        return this.exportParameters;
    }

    public void setExportParameters(String exportParameters) {
        this.exportParameters = exportParameters;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    protected void doExecute(String finalLocation, ActionInvocation invocation) throws Exception {
        ByteArrayOutputStream output;
        JasperPrint jasperPrint;
        Map reportParams;
        this.initializeProperties(invocation);
        LOG.debug("Creating JasperReport for dataSource = {}, format = {}", (Object)this.dataSource, (Object)this.format);
        HttpServletRequest request = (HttpServletRequest)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse response = (HttpServletResponse)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        if ("contype".equals(request.getHeader("User-Agent"))) {
            try (ServletOutputStream outputStream = response.getOutputStream();){
                response.setContentType("application/pdf");
                response.setContentLength(0);
            }
            catch (IOException e) {
                LOG.error("Error writing report output", (Throwable)e);
                throw new ServletException(e.getMessage(), (Throwable)e);
            }
            return;
        }
        ValueStack stack = invocation.getStack();
        ValueStackDataSource stackDataSource = null;
        Connection conn = (Connection)stack.findValue(this.connection);
        if (conn == null) {
            boolean reevaluate;
            boolean evaluated = this.parsedDataSource != null && !this.parsedDataSource.equals(this.dataSource);
            boolean bl = reevaluate = !evaluated || this.isAcceptableExpression(this.parsedDataSource);
            if (reevaluate) {
                stackDataSource = new ValueStackDataSource(stack, this.parsedDataSource, this.wrapField);
            } else {
                throw new ServletException(String.format("Error building dataSource for excluded or not accepted [%s]", this.parsedDataSource));
            }
        }
        if ("https".equalsIgnoreCase(request.getScheme())) {
            response.setHeader("CACHE-CONTROL", "PRIVATE");
            response.setHeader("Cache-Control", "maxage=3600");
            response.setHeader("Pragma", "public");
            response.setHeader("Accept-Ranges", "none");
        }
        ServletContext servletContext = (ServletContext)invocation.getInvocationContext().get("com.opensymphony.xwork2.dispatcher.ServletContext");
        String systemId = servletContext.getRealPath(finalLocation);
        ValueStackShadowMap parameters = new ValueStackShadowMap(stack);
        File directory = new File(systemId.substring(0, systemId.lastIndexOf(File.separator)));
        parameters.put("reportDirectory", directory);
        parameters.put("REPORT_LOCALE", invocation.getInvocationContext().getLocale());
        if (this.timeZone != null) {
            this.timeZone = this.conditionalParse(this.timeZone, invocation);
            TimeZone tz = TimeZone.getTimeZone(this.timeZone);
            if (tz != null) {
                parameters.put("REPORT_TIME_ZONE", tz);
            }
        }
        boolean evaluated = this.parsedReportParameters != null && !this.parsedReportParameters.equals(this.reportParameters);
        boolean reevaluate = !evaluated || this.isAcceptableExpression(this.parsedReportParameters);
        Map map = reportParams = reevaluate ? (Map)stack.findValue(this.parsedReportParameters) : null;
        if (reportParams != null) {
            LOG.debug("Found report parameters; adding to parameters...");
            parameters.putAll(reportParams);
        }
        try {
            JasperReport jasperReport = (JasperReport)JRLoader.loadObject((File)new File(systemId));
            jasperPrint = conn == null ? JasperFillManager.fillReport((JasperReport)jasperReport, (Map)parameters, (JRDataSource)stackDataSource) : JasperFillManager.fillReport((JasperReport)jasperReport, (Map)parameters, (Connection)conn);
        }
        catch (JRException e) {
            LOG.error("Error building report for uri {}", (Object)systemId, (Object)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        try {
            Map exportParams;
            JRPdfExporter exporter;
            if (this.contentDisposition != null || this.documentName != null) {
                StringBuffer tmp = new StringBuffer();
                tmp.append(this.contentDisposition == null ? "inline" : this.contentDisposition);
                if (this.documentName != null) {
                    tmp.append("; filename=");
                    tmp.append(this.documentName);
                    tmp.append(".");
                    tmp.append(this.format.toLowerCase());
                }
                response.setHeader("Content-disposition", tmp.toString());
            }
            if (this.format.equals("PDF")) {
                response.setContentType("application/pdf");
                exporter = new JRPdfExporter();
            } else if (this.format.equals("CSV")) {
                response.setContentType("text/csv");
                exporter = new JRCsvExporter();
            } else if (this.format.equals("HTML")) {
                response.setContentType("text/html");
                HashMap imagesMap = new HashMap();
                request.getSession(true).setAttribute("IMAGES_MAP", imagesMap);
                exporter = new JRHtmlExporter();
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, imagesMap);
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)(request.getContextPath() + this.imageServletUrl));
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                request.getSession().setAttribute("net.sf.jasperreports.j2ee.jasper_print", (Object)jasperPrint);
            } else if (this.format.equals("XLS")) {
                response.setContentType("application/vnd.ms-excel");
                exporter = new JRXlsExporter();
            } else if (this.format.equals("XML")) {
                response.setContentType("text/xml");
                exporter = new JRXmlExporter();
            } else if (this.format.equals("RTF")) {
                response.setContentType("application/rtf");
                exporter = new JRRtfExporter();
            } else {
                throw new ServletException("Unknown report format: " + this.format);
            }
            evaluated = this.parsedExportParameters != null && !this.parsedExportParameters.equals(this.exportParameters);
            reevaluate = !evaluated || this.isAcceptableExpression(this.parsedExportParameters);
            Map map2 = exportParams = reevaluate ? (Map)stack.findValue(this.parsedExportParameters) : null;
            if (exportParams != null) {
                LOG.debug("Found export parameters; adding to exporter parameters...");
                exporter.getParameters().putAll(exportParams);
            }
            output = this.exportReportToBytes(jasperPrint, (JRExporter)exporter);
        }
        catch (JRException e) {
            LOG.error("Error producing {} report for uri {}", (Object)this.format, (Object)systemId, (Object)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Could not close db connection properly", (Throwable)e);
            }
        }
        response.setContentLength(output.size());
        this.writeReport(response, output);
    }

    private void writeReport(HttpServletResponse response, ByteArrayOutputStream output) throws ServletException {
        try (ServletOutputStream outputStream = response.getOutputStream();){
            output.writeTo((OutputStream)outputStream);
            outputStream.flush();
        }
        catch (IOException e) {
            LOG.error("Error writing report output", (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    private void initializeProperties(ActionInvocation invocation) throws Exception {
        if (this.dataSource == null && this.connection == null) {
            String message = "No dataSource specified...";
            LOG.error(message);
            throw new RuntimeException(message);
        }
        if (this.dataSource != null) {
            this.parsedDataSource = this.conditionalParse(this.dataSource, invocation);
        }
        this.format = this.conditionalParse(this.format, invocation);
        if (StringUtils.isEmpty((CharSequence)this.format)) {
            this.format = "PDF";
        }
        if (this.contentDisposition != null) {
            this.contentDisposition = this.conditionalParse(this.contentDisposition, invocation);
        }
        if (this.documentName != null) {
            this.documentName = this.conditionalParse(this.documentName, invocation);
        }
        this.parsedReportParameters = this.conditionalParse(this.reportParameters, invocation);
        this.parsedExportParameters = this.conditionalParse(this.exportParameters, invocation);
    }

    private ByteArrayOutputStream exportReportToBytes(JasperPrint jasperPrint, JRExporter exporter) throws JRException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
        exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)baos);
        if (this.delimiter != null) {
            exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)this.delimiter);
        }
        exporter.exportReport();
        return baos;
    }

    protected boolean isAcceptableExpression(String expression) {
        NotExcludedAcceptedPatternsChecker.IsAllowed isAllowed = this.notExcludedAcceptedPatterns.isAllowed(expression);
        if (isAllowed.isAllowed()) {
            return true;
        }
        LOG.warn("Expression [{}] isn't allowed by pattern [{}]! See Accepted / Excluded patterns at\nhttps://struts.apache.org/security/", (Object)expression, (Object)isAllowed.getAllowedPattern());
        return false;
    }
}

