/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openpgp;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.apache.sshd.common.config.keys.IdentityUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.c02e.jpgpj.CompressionAlgorithm;
import org.c02e.jpgpj.EncryptionAlgorithm;
import org.c02e.jpgpj.Key;
import org.c02e.jpgpj.Subkey;

public final class PGPUtils {
    public static final String DEFAULT_PGP_FILE_SUFFIX = ".gpg";
    public static final String STD_LINUX_PGP_FOLDER_NAME = ".gnupg";
    public static final String STD_WINDOWS_PGP_FOLDER_NAME = "gnupg";
    public static final String PGP_ENCRYPTED_FILE = "application/pgp-encrypted";
    public static final String NO_CIPHER_PLACEHOLDER = "none";
    public static final Set<EncryptionAlgorithm> CIPHERS = Collections.unmodifiableSet(EnumSet.allOf(EncryptionAlgorithm.class));
    public static final String NO_COMPRESSION_PLACEHOLDER = "none";
    public static final Set<CompressionAlgorithm> COMPRESSIONS = Collections.unmodifiableSet(EnumSet.allOf(CompressionAlgorithm.class));

    private PGPUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static EncryptionAlgorithm fromCipherName(String name) {
        if (GenericUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        if ("none".equalsIgnoreCase(name)) {
            return EncryptionAlgorithm.Unencrypted;
        }
        return CIPHERS.stream().filter(c -> name.equalsIgnoreCase(c.name())).findFirst().orElse(null);
    }

    public static CompressionAlgorithm fromCompressionName(String name) {
        if (GenericUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        if ("none".equalsIgnoreCase(name)) {
            return CompressionAlgorithm.Uncompressed;
        }
        return COMPRESSIONS.stream().filter(c -> name.equalsIgnoreCase(c.name())).findFirst().orElse(null);
    }

    public static NavigableMap<String, Subkey> mapSubKeysByFingerprint(Key key) {
        return PGPUtils.mapSubKeysByFingerprint(key == null ? Collections.emptyList() : key.getSubkeys());
    }

    public static NavigableMap<String, Subkey> mapSubKeysByFingerprint(Collection<? extends Subkey> subKeys) {
        if (GenericUtils.isEmpty(subKeys)) {
            return Collections.emptyNavigableMap();
        }
        TreeMap<String, Subkey> keysMap = new TreeMap<String, Subkey>(String.CASE_INSENSITIVE_ORDER);
        for (Subkey subkey : subKeys) {
            String fp = ValidateUtils.checkNotNullAndNotEmpty((String)subkey.getFingerprint(), (String)"No fingerprint for %s", (Object)subkey);
            Subkey prev = keysMap.put(fp, subkey);
            ValidateUtils.checkState((prev == null ? 1 : 0) != 0, (String)"Multiple sub-keys with fingerprint=%s: %s / %s", (Object[])new Object[]{fp, subkey, prev});
        }
        return keysMap;
    }

    public static Subkey findSubkeyByFingerprint(Key key, String fingerprint) {
        return PGPUtils.findSubkeyByFingerprint(key == null ? Collections.emptyList() : key.getSubkeys(), fingerprint);
    }

    public static Subkey findSubkeyByFingerprint(Collection<? extends Subkey> subKeys, String fingerprint) {
        if (GenericUtils.isEmpty(subKeys) || GenericUtils.isEmpty((CharSequence)fingerprint)) {
            return null;
        }
        return subKeys.stream().filter(k -> fingerprint.equalsIgnoreCase(k.getFingerprint())).findFirst().orElse(null);
    }

    public static Path getDefaultPgpFolderPath() {
        return LazyDefaultPgpKeysFolderHolder.PATH;
    }

    private static final class LazyDefaultPgpKeysFolderHolder {
        private static final Path PATH = IdentityUtils.getUserHomeFolder().resolve(OsUtils.isUNIX() ? ".gnupg" : "gnupg");

        private LazyDefaultPgpKeysFolderHolder() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }
}

