/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys.loader.openpgp;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Objects;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.c02e.jpgpj.Subkey;

@FunctionalInterface
public interface PGPPublicKeyExtractor {
    default public PublicKey extractPublicKey(NamedResource resourceKey, Subkey sk) throws IOException, GeneralSecurityException {
        if (sk == null) {
            return null;
        }
        PGPPublicKey pgpKey = Objects.requireNonNull(sk.getPublicKey(), "Missing sub-key public key");
        PublicKeyPacket pgpPacket = Objects.requireNonNull(pgpKey.getPublicKeyPacket(), "Missing public key packet");
        BCPGKey bcKey = Objects.requireNonNull(pgpPacket.getKey(), "Missing BC key");
        if (bcKey instanceof RSAPublicBCPGKey) {
            return this.extractRSAPublicKey(resourceKey, (RSAPublicBCPGKey)bcKey);
        }
        if (bcKey instanceof ECPublicBCPGKey) {
            return this.extractECPublicKey(resourceKey, (ECPublicBCPGKey)bcKey);
        }
        if (bcKey instanceof DSAPublicBCPGKey) {
            return this.extractDSSPublicKey(resourceKey, (DSAPublicBCPGKey)bcKey);
        }
        throw new NoSuchAlgorithmException("Unsupported BC public key type: " + bcKey.getClass().getSimpleName());
    }

    default public RSAPublicKey extractRSAPublicKey(NamedResource resourceKey, RSAPublicBCPGKey bcKey) throws IOException, GeneralSecurityException {
        if (bcKey == null) {
            return null;
        }
        BigInteger e = bcKey.getPublicExponent();
        BigInteger n = bcKey.getModulus();
        return this.generatePublicKey("RSA", RSAPublicKey.class, new RSAPublicKeySpec(n, e));
    }

    default public PublicKey extractECPublicKey(NamedResource resourceKey, ECPublicBCPGKey bcKey) throws IOException, GeneralSecurityException {
        if (bcKey == null) {
            return null;
        }
        if (bcKey instanceof EdDSAPublicBCPGKey) {
            return this.extractEdDSAPublicKey(resourceKey, (EdDSAPublicBCPGKey)bcKey);
        }
        if (bcKey instanceof ECDSAPublicBCPGKey || bcKey instanceof ECDHPublicBCPGKey) {
            return this.extractECDSAPublicKey(resourceKey, bcKey);
        }
        throw new NoSuchAlgorithmException("Unsupported EC public key type: " + bcKey.getClass().getSimpleName());
    }

    default public ECPublicKey extractECDSAPublicKey(NamedResource resourceKey, ECPublicBCPGKey bcKey) throws IOException, GeneralSecurityException {
        ECPoint w;
        if (bcKey == null) {
            return null;
        }
        ASN1ObjectIdentifier asnId = bcKey.getCurveOID();
        String oid = asnId.getId();
        ECCurves curve = ECCurves.fromOID((String)oid);
        if (curve == null) {
            throw new InvalidKeySpecException("Not an EC curve OID: " + oid);
        }
        if (!SecurityUtils.isECCSupported()) {
            throw new NoSuchProviderException("ECC not supported");
        }
        BigInteger encPoint = bcKey.getEncodedPoint();
        byte[] octets = encPoint.toByteArray();
        try {
            w = ECCurves.octetStringToEcPoint((byte[])octets);
            if (w == null) {
                throw new InvalidKeySpecException("No ECPoint generated for curve=" + curve.getName() + " from octets=" + BufferUtils.toHex((char)':', (byte[])octets));
            }
        }
        catch (RuntimeException e) {
            throw new InvalidKeySpecException("Failed (" + e.getClass().getSimpleName() + ") to generate ECPoint for curve=" + curve.getName() + " from octets=" + BufferUtils.toHex((char)':', (byte[])octets) + ": " + e.getMessage());
        }
        ECParameterSpec paramSpec = curve.getParameters();
        return this.generatePublicKey("EC", ECPublicKey.class, new ECPublicKeySpec(w, paramSpec));
    }

    default public PublicKey extractEdDSAPublicKey(NamedResource resourceKey, EdDSAPublicBCPGKey bcKey) throws IOException, GeneralSecurityException {
        if (bcKey == null) {
            return null;
        }
        if (!SecurityUtils.isEDDSACurveSupported()) {
            throw new NoSuchProviderException("EdDSA not supported");
        }
        throw new NoSuchAlgorithmException("Unsupported EdDSA public key type: " + bcKey.getClass().getSimpleName());
    }

    default public DSAPublicKey extractDSSPublicKey(NamedResource resourceKey, DSAPublicBCPGKey bcKey) throws IOException, GeneralSecurityException {
        if (bcKey == null) {
            return null;
        }
        BigInteger p = bcKey.getP();
        BigInteger q = bcKey.getQ();
        BigInteger g = bcKey.getG();
        BigInteger y = bcKey.getY();
        return this.generatePublicKey("DSA", DSAPublicKey.class, new DSAPublicKeySpec(y, p, q, g));
    }

    public <K extends PublicKey> K generatePublicKey(String var1, Class<K> var2, KeySpec var3) throws GeneralSecurityException;
}

