/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.expressions;

import java.io.Serializable;
import org.apache.spark.annotation.Stable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.CurrentRow$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.RowFrame$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnboundedFollowing$;
import org.apache.spark.sql.catalyst.expressions.UnboundedPreceding$;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Stable
@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001\u0002\u0007\u000e\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0004=\u0001\u0011\u0005q\"\u0010\u0005\u0006\u0007\u0002!\t\u0001\u0012\u0005\u0006\u0007\u0002!\ta\u0017\u0005\u0006I\u0002!\t!\u001a\u0005\u0006I\u0002!\t!\u001b\u0005\u0006Y\u0002!\t!\u001c\u0005\u0006k\u0002!\tA\u001e\u0005\u0007s\u0002!\ta\u0004>\u0003\u0015]Kg\u000eZ8x'B,7M\u0003\u0002\u000f\u001f\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0001\u0012#A\u0002tc2T!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\u0002\u0001'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\u000ea\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2\u0011\u0007\u0005JCF\u0004\u0002#O9\u00111EJ\u0007\u0002I)\u0011QeF\u0001\u0007yI|w\u000e\u001e \n\u0003qI!\u0001K\u000e\u0002\u000fA\f7m[1hK&\u0011!f\u000b\u0002\u0004'\u0016\f(B\u0001\u0015\u001c!\ti\u0013'D\u0001/\u0015\tqqF\u0003\u00021\u001f\u0005A1-\u0019;bYf\u001cH/\u0003\u00023]\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u0013=\u0014H-\u001a:Ta\u0016\u001c\u0007cA\u0011*kA\u0011QFN\u0005\u0003o9\u0012\u0011bU8si>\u0013H-\u001a:\u0002\u000b\u0019\u0014\u0018-\\3\u0011\u00055R\u0014BA\u001e/\u0005-9\u0016N\u001c3po\u001a\u0013\u0018-\\3\u0002\rqJg.\u001b;?)\u0011q\u0004)\u0011\"\u0011\u0005}\u0002Q\"A\u0007\t\u000b}!\u0001\u0019\u0001\u0011\t\u000bM\"\u0001\u0019\u0001\u001b\t\u000ba\"\u0001\u0019A\u001d\u0002\u0017A\f'\u000f^5uS>t')\u001f\u000b\u0004}\u0015{\u0005\"\u0002$\u0006\u0001\u00049\u0015aB2pY:\u000bW.\u001a\t\u0003\u00112s!!\u0013&\u0011\u0005\rZ\u0012BA&\u001c\u0003\u0019\u0001&/\u001a3fM&\u0011QJ\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-[\u0002\"\u0002)\u0006\u0001\u0004\t\u0016\u0001C2pY:\u000bW.Z:\u0011\u0007i\u0011v)\u0003\u0002T7\tQAH]3qK\u0006$X\r\u001a )\u0005\u0015)\u0006C\u0001,Z\u001b\u00059&B\u0001-\u001c\u0003)\tgN\\8uCRLwN\\\u0005\u00035^\u0013qA^1sCJ<7\u000f\u0006\u0002?9\")QL\u0002a\u0001=\u0006!1m\u001c7t!\rQ\"k\u0018\t\u0003A\u0006l\u0011aD\u0005\u0003E>\u0011aaQ8mk6t\u0007F\u0001\u0004V\u0003\u001dy'\u000fZ3s\u0005f$2A\u00104h\u0011\u00151u\u00011\u0001H\u0011\u0015\u0001v\u00011\u0001RQ\t9Q\u000b\u0006\u0002?U\")Q\f\u0003a\u0001=\"\u0012\u0001\"V\u0001\fe><8OQ3uo\u0016,g\u000eF\u0002?]NDQa\\\u0005A\u0002A\fQa\u001d;beR\u0004\"AG9\n\u0005I\\\"\u0001\u0002'p]\u001eDQ\u0001^\u0005A\u0002A\f1!\u001a8e\u00031\u0011\u0018M\\4f\u0005\u0016$x/Z3o)\rqt\u000f\u001f\u0005\u0006_*\u0001\r\u0001\u001d\u0005\u0006i*\u0001\r\u0001]\u0001\u000eo&$\b.Q4he\u0016<\u0017\r^3\u0015\u0005}[\b\"\u0002?\f\u0001\u0004y\u0016!C1hOJ,w-\u0019;fQ\t\u0001a\u0010E\u0002\u0000\u0003\u0007i!!!\u0001\u000b\u0005a\u000b\u0012\u0002BA\u0003\u0003\u0003\u0011aa\u0015;bE2,\u0007")
public class WindowSpec {
    private final Seq<Expression> partitionSpec;
    private final Seq<SortOrder> orderSpec;
    private final WindowFrame frame;

    public WindowSpec partitionBy(String colName, String ... colNames) {
        return this.partitionBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public WindowSpec partitionBy(Column ... cols) {
        return this.partitionBy((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    public WindowSpec orderBy(String colName, String ... colNames) {
        return this.orderBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public WindowSpec orderBy(Column ... cols) {
        return this.orderBy((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    public WindowSpec partitionBy(String colName, Seq<String> colNames) {
        String string = colName;
        return this.partitionBy((Seq<Column>)((Seq)((TraversableLike)colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> Column$.MODULE$.apply((String)x$2), Seq$.MODULE$.canBuildFrom())));
    }

    public WindowSpec partitionBy(Seq<Column> cols) {
        return new WindowSpec((Seq<Expression>)((Seq)cols.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.expr(), Seq$.MODULE$.canBuildFrom())), this.orderSpec, this.frame);
    }

    public WindowSpec orderBy(String colName, Seq<String> colNames) {
        String string = colName;
        return this.orderBy((Seq<Column>)((Seq)((TraversableLike)colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> Column$.MODULE$.apply((String)x$5), Seq$.MODULE$.canBuildFrom())));
    }

    public WindowSpec orderBy(Seq<Column> cols) {
        Seq sortOrder = (Seq)cols.map((Function1 & Serializable & scala.Serializable)col -> {
            SortOrder sortOrder;
            Expression expression = col.expr();
            if (expression instanceof SortOrder) {
                SortOrder sortOrder2;
                sortOrder = sortOrder2 = (SortOrder)expression;
            } else if (expression != null) {
                Expression expression2 = expression;
                sortOrder = SortOrder$.MODULE$.apply(expression2, (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            } else {
                throw new MatchError((Object)expression);
            }
            return sortOrder;
        }, Seq$.MODULE$.canBuildFrom());
        return new WindowSpec(this.partitionSpec, (Seq<SortOrder>)sortOrder, this.frame);
    }

    public WindowSpec rowsBetween(long start, long end) {
        CurrentRow$ currentRow$;
        CurrentRow$ currentRow$2;
        long l = start;
        if (0L == l) {
            currentRow$2 = CurrentRow$.MODULE$;
        } else if (Long.MIN_VALUE == l) {
            currentRow$2 = UnboundedPreceding$.MODULE$;
        } else if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            currentRow$2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)l)));
        } else {
            throw QueryCompilationErrors$.MODULE$.invalidBoundaryStartError(l);
        }
        CurrentRow$ boundaryStart = currentRow$2;
        long l2 = end;
        if (0L == l2) {
            currentRow$ = CurrentRow$.MODULE$;
        } else if (Long.MAX_VALUE == l2) {
            currentRow$ = UnboundedFollowing$.MODULE$;
        } else if (Integer.MIN_VALUE <= l2 && l2 <= Integer.MAX_VALUE) {
            currentRow$ = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)l2)));
        } else {
            throw QueryCompilationErrors$.MODULE$.invalidBoundaryEndError(l2);
        }
        CurrentRow$ boundaryEnd = currentRow$;
        return new WindowSpec(this.partitionSpec, this.orderSpec, (WindowFrame)new SpecifiedWindowFrame((FrameType)RowFrame$.MODULE$, (Expression)boundaryStart, (Expression)boundaryEnd));
    }

    public WindowSpec rangeBetween(long start, long end) {
        long l = start;
        Object object = 0L == l ? CurrentRow$.MODULE$ : (Long.MIN_VALUE == l ? UnboundedPreceding$.MODULE$ : Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)l)));
        CurrentRow$ boundaryStart = object;
        long l2 = end;
        Object object2 = 0L == l2 ? CurrentRow$.MODULE$ : (Long.MAX_VALUE == l2 ? UnboundedFollowing$.MODULE$ : Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)l2)));
        CurrentRow$ boundaryEnd = object2;
        return new WindowSpec(this.partitionSpec, this.orderSpec, (WindowFrame)new SpecifiedWindowFrame((FrameType)RangeFrame$.MODULE$, (Expression)boundaryStart, (Expression)boundaryEnd));
    }

    public Column withAggregate(Column aggregate) {
        WindowSpecDefinition spec = new WindowSpecDefinition(this.partitionSpec, this.orderSpec, this.frame);
        return new Column((Expression)new WindowExpression(aggregate.expr(), spec));
    }

    public WindowSpec(Seq<Expression> partitionSpec, Seq<SortOrder> orderSpec, WindowFrame frame) {
        this.partitionSpec = partitionSpec;
        this.orderSpec = orderSpec;
        this.frame = frame;
    }
}

