/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.io.File;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.fs.Path;
import org.apache.spark.annotation.Unstable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.ArchiveResource$;
import org.apache.spark.sql.catalyst.catalog.FileResource$;
import org.apache.spark.sql.catalyst.catalog.FunctionResource;
import org.apache.spark.sql.catalyst.catalog.FunctionResourceLoader;
import org.apache.spark.sql.catalyst.catalog.FunctionResourceType;
import org.apache.spark.sql.catalyst.catalog.JarResource$;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Unstable
@ScalaSignature(bytes="\u0006\u0001)3A!\u0002\u0004\u0001#!A\u0001\u0005\u0001B\u0001B\u0003%\u0011\u0005C\u0003&\u0001\u0011\u0005a\u0005C\u0003+\u0001\u0011\u00053\u0006C\u00035\u0001\u0011\u0005QGA\u000bTKN\u001c\u0018n\u001c8SKN|WO]2f\u0019>\fG-\u001a:\u000b\u0005\u001dA\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011\u0002\u0004\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BC\u0001\u0004B]f\u0014VM\u001a\t\u00033yi\u0011A\u0007\u0006\u00037q\tqaY1uC2|wM\u0003\u0002\u001e\u0011\u0005A1-\u0019;bYf\u001cH/\u0003\u0002 5\t1b)\u001e8di&|gNU3t_V\u00148-\u001a'pC\u0012,'/A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005\t\u001aS\"\u0001\u0005\n\u0005\u0011B!\u0001D*qCJ\\7+Z:tS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0002(SA\u0011\u0001\u0006A\u0007\u0002\r!)\u0001E\u0001a\u0001C\u0005aAn\\1e%\u0016\u001cx.\u001e:dKR\u0011Af\f\t\u0003'5J!A\f\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006a\r\u0001\r!M\u0001\te\u0016\u001cx.\u001e:dKB\u0011\u0011DM\u0005\u0003gi\u0011\u0001CR;oGRLwN\u001c*fg>,(oY3\u0002\r\u0005$GMS1s)\tac\u0007C\u00038\t\u0001\u0007\u0001(\u0001\u0003qCRD\u0007CA\u001dA\u001d\tQd\b\u0005\u0002<)5\tAH\u0003\u0002>!\u00051AH]8pizJ!a\u0010\u000b\u0002\rA\u0013X\rZ3g\u0013\t\t%I\u0001\u0004TiJLgn\u001a\u0006\u0003\u007fQA#\u0001\u0001#\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001dS\u0011AC1o]>$\u0018\r^5p]&\u0011\u0011J\u0012\u0002\t+:\u001cH/\u00192mK\u0002")
public class SessionResourceLoader
implements FunctionResourceLoader {
    private final SparkSession session;

    public void loadResource(FunctionResource resource) {
        FunctionResourceType functionResourceType = resource.resourceType();
        if (JarResource$.MODULE$.equals(functionResourceType)) {
            this.addJar(resource.uri());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (FileResource$.MODULE$.equals(functionResourceType)) {
            this.session.sparkContext().addFile(resource.uri());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (ArchiveResource$.MODULE$.equals(functionResourceType)) {
                throw new AnalysisException("Archive is not allowed to be loaded. If YARN mode is used, please use --archives options while calling spark-submit.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            throw new MatchError((Object)functionResourceType);
        }
    }

    public void addJar(String path) {
        this.session.sparkContext().addJar(path);
        URI uri = new Path(path).toUri();
        URL jarURL = uri.getScheme() == null ? new File(path).toURI().toURL() : uri.toURL();
        this.session.sharedState().jarClassLoader().addURL(jarURL);
        Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this.session.sharedState().jarClassLoader()));
    }

    public SessionResourceLoader(SparkSession session) {
        this.session = session;
    }
}

