/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException;
import org.apache.spark.sql.catalyst.analysis.NoSuchFunctionException$;
import org.apache.spark.sql.catalyst.catalog.CatalogFunction;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.execution.command.RefreshFunctionCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\f\u0019\u0001\u0016B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tA\u0010\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u007f!Aa\n\u0001BK\u0002\u0013\u0005q\n\u0003\u0005Q\u0001\tE\t\u0015!\u0003C\u0011\u0015\t\u0006\u0001\"\u0001S\u0011\u00151\u0006\u0001\"\u0011X\u0011\u001dQ\u0007!!A\u0005\u0002-DqA\u001c\u0001\u0012\u0002\u0013\u0005q\u000eC\u0004{\u0001E\u0005I\u0011A>\t\u000fu\u0004\u0011\u0011!C!}\"I\u0011Q\u0002\u0001\u0002\u0002\u0013\u0005\u0011q\u0002\u0005\n\u0003/\u0001\u0011\u0011!C\u0001\u00033A\u0011\"!\n\u0001\u0003\u0003%\t%a\n\t\u0013\u0005U\u0002!!A\u0005\u0002\u0005]\u0002\"CA!\u0001\u0005\u0005I\u0011IA\"\u000f%\t9\u0005GA\u0001\u0012\u0003\tIE\u0002\u0005\u00181\u0005\u0005\t\u0012AA&\u0011\u0019\t\u0016\u0003\"\u0001\u0002Z!I\u00111L\t\u0002\u0002\u0013\u0015\u0013Q\f\u0005\n\u0003?\n\u0012\u0011!CA\u0003CB\u0011\"a\u001a\u0012\u0003\u0003%\t)!\u001b\t\u0013\u0005]\u0014#!A\u0005\n\u0005e$A\u0006*fMJ,7\u000f\u001b$v]\u000e$\u0018n\u001c8D_6l\u0017M\u001c3\u000b\u0005eQ\u0012aB2p[6\fg\u000e\u001a\u0006\u00037q\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005uq\u0012aA:rY*\u0011q\u0004I\u0001\u0006gB\f'o\u001b\u0006\u0003C\t\na!\u00199bG\",'\"A\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u00011\u0003\u0007\u000e\u001e\u0011\u0005\u001drS\"\u0001\u0015\u000b\u0005%R\u0013a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003W1\nQ\u0001\u001d7b]NT!!\f\u000f\u0002\u0011\r\fG/\u00197zgRL!a\f\u0015\u0003\u00171{w-[2bYBc\u0017M\u001c\t\u0003cIj\u0011\u0001G\u0005\u0003ga\u0011qBU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\b!J|G-^2u!\t)4(\u0003\u0002=m\ta1+\u001a:jC2L'0\u00192mK\u0006aA-\u0019;bE\u0006\u001cXMT1nKV\tq\bE\u00026\u0001\nK!!\u0011\u001c\u0003\r=\u0003H/[8o!\t\u0019%J\u0004\u0002E\u0011B\u0011QIN\u0007\u0002\r*\u0011q\tJ\u0001\u0007yI|w\u000e\u001e \n\u0005%3\u0014A\u0002)sK\u0012,g-\u0003\u0002L\u0019\n11\u000b\u001e:j]\u001eT!!\u0013\u001c\u0002\u001b\u0011\fG/\u00192bg\u0016t\u0015-\\3!\u000311WO\\2uS>tg*Y7f+\u0005\u0011\u0015!\u00044v]\u000e$\u0018n\u001c8OC6,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004'R+\u0006CA\u0019\u0001\u0011\u0015iT\u00011\u0001@\u0011\u0015qU\u00011\u0001C\u0003\r\u0011XO\u001c\u000b\u00031\u0016\u00042!\u00170b\u001d\tQFL\u0004\u0002F7&\tq'\u0003\u0002^m\u00059\u0001/Y2lC\u001e,\u0017BA0a\u0005\r\u0019V-\u001d\u0006\u0003;Z\u0002\"AY2\u000e\u0003qI!\u0001\u001a\u000f\u0003\u0007I{w\u000fC\u0003g\r\u0001\u0007q-\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002cQ&\u0011\u0011\u000e\b\u0002\r'B\f'o[*fgNLwN\\\u0001\u0005G>\u0004\u0018\u0010F\u0002TY6Dq!P\u0004\u0011\u0002\u0003\u0007q\bC\u0004O\u000fA\u0005\t\u0019\u0001\"\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t\u0001O\u000b\u0002@c.\n!\u000f\u0005\u0002tq6\tAO\u0003\u0002vm\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003oZ\n!\"\u00198o_R\fG/[8o\u0013\tIHOA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'F\u0001}U\t\u0011\u0015/A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0002\u007fB!\u0011\u0011AA\u0006\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011\u0001\u00027b]\u001eT!!!\u0003\u0002\t)\fg/Y\u0005\u0004\u0017\u0006\r\u0011\u0001\u00049s_\u0012,8\r^!sSRLXCAA\t!\r)\u00141C\u0005\u0004\u0003+1$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u000e\u0003C\u00012!NA\u000f\u0013\r\tyB\u000e\u0002\u0004\u0003:L\b\"CA\u0012\u0019\u0005\u0005\t\u0019AA\t\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011\u0011\u0006\t\u0007\u0003W\t\t$a\u0007\u000e\u0005\u00055\"bAA\u0018m\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0012Q\u0006\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002:\u0005}\u0002cA\u001b\u0002<%\u0019\u0011Q\b\u001c\u0003\u000f\t{w\u000e\\3b]\"I\u00111\u0005\b\u0002\u0002\u0003\u0007\u00111D\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005e\u0012Q\t\u0005\n\u0003Gy\u0011\u0011!a\u0001\u00037\taCU3ge\u0016\u001c\bNR;oGRLwN\\\"p[6\fg\u000e\u001a\t\u0003cE\u0019B!EA'uA9\u0011qJA+\u007f\t\u001bVBAA)\u0015\r\t\u0019FN\u0001\beVtG/[7f\u0013\u0011\t9&!\u0015\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002J\u0005AAo\\*ue&tw\rF\u0001\u0000\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\u0019\u00161MA3\u0011\u0015iD\u00031\u0001@\u0011\u0015qE\u00031\u0001C\u0003\u001d)h.\u00199qYf$B!a\u001b\u0002tA!Q\u0007QA7!\u0015)\u0014qN C\u0013\r\t\tH\u000e\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005UT#!AA\u0002M\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005m\u0004\u0003BA\u0001\u0003{JA!a \u0002\u0004\t1qJ\u00196fGR\u0004")
public class RefreshFunctionCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final Option<String> databaseName;
    private final String functionName;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Option<String>, String>> unapply(RefreshFunctionCommand refreshFunctionCommand) {
        return RefreshFunctionCommand$.MODULE$.unapply(refreshFunctionCommand);
    }

    public static Function1<Tuple2<Option<String>, String>, RefreshFunctionCommand> tupled() {
        return RefreshFunctionCommand$.MODULE$.tupled();
    }

    public static Function1<Option<String>, Function1<String, RefreshFunctionCommand>> curried() {
        return RefreshFunctionCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        RefreshFunctionCommand refreshFunctionCommand = this;
        synchronized (refreshFunctionCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public Option<String> databaseName() {
        return this.databaseName;
    }

    public String functionName() {
        return this.functionName;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        if (FunctionRegistry$.MODULE$.builtin().functionExists(new FunctionIdentifier(this.functionName(), this.databaseName()))) {
            throw new AnalysisException(new StringBuilder(33).append("Cannot refresh built-in function ").append(this.functionName()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        if (catalog.isTemporaryFunction(new FunctionIdentifier(this.functionName(), this.databaseName()))) {
            throw new AnalysisException(new StringBuilder(34).append("Cannot refresh temporary function ").append(this.functionName()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        FunctionIdentifier identifier = new FunctionIdentifier(this.functionName(), (Option)new Some(this.databaseName().getOrElse((Function0 & Serializable & scala.Serializable)() -> catalog.getCurrentDatabase())));
        if (!catalog.isPersistentFunction(identifier)) {
            catalog.unregisterFunction(identifier);
            throw new NoSuchFunctionException((String)identifier.database().get(), identifier.funcName(), NoSuchFunctionException$.MODULE$.$lessinit$greater$default$3());
        }
        CatalogFunction func = catalog.getFunctionMetadata(identifier);
        catalog.registerFunction(func, true, catalog.registerFunction$default$3());
        return (Seq)Seq$.MODULE$.empty();
    }

    public RefreshFunctionCommand copy(Option<String> databaseName, String functionName) {
        return new RefreshFunctionCommand(databaseName, functionName);
    }

    public Option<String> copy$default$1() {
        return this.databaseName();
    }

    public String copy$default$2() {
        return this.functionName();
    }

    public String productPrefix() {
        return "RefreshFunctionCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.databaseName();
                break;
            }
            case 1: {
                object = this.functionName();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RefreshFunctionCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RefreshFunctionCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        RefreshFunctionCommand refreshFunctionCommand = (RefreshFunctionCommand)x$1;
        Option<String> option = this.databaseName();
        Option<String> option2 = refreshFunctionCommand.databaseName();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        String string = this.functionName();
        String string2 = refreshFunctionCommand.functionName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!refreshFunctionCommand.canEqual(this)) return false;
        return true;
    }

    public RefreshFunctionCommand(Option<String> databaseName, String functionName) {
        this.databaseName = databaseName;
        this.functionName = functionName;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

