/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnsupportedOperationChecker$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.streaming.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.StreamExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryListenerBus;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Evolving
@ScalaSignature(bytes="\u0006\u0001\t]g\u0001\u0002\u0012$\u00019B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\u0007\u0001\u0002!\t!J!\t\u0011\u0015\u0003!\u0019!C\u0001K\u0019Ca\u0001\u0015\u0001!\u0002\u00139\u0005bB)\u0001\u0005\u0004%IA\u0015\u0005\u0007/\u0002\u0001\u000b\u0011B*\t\u000fa\u0003!\u0019!C\u00053\"1Q\u000e\u0001Q\u0001\niCqa\u001f\u0001C\u0002\u0013%A\u0010C\u0004\u0002\b\u0001\u0001\u000b\u0011B?\t\u0011\u0005%\u0001A1A\u0005\nqDq!a\u0003\u0001A\u0003%Q\u0010C\u0005\u0002\u000e\u0001\u0001\r\u0011\"\u0003\u0002\u0010!I\u0011\u0011\u0003\u0001A\u0002\u0013%\u00111\u0003\u0005\b\u0003?\u0001\u0001\u0015)\u0003k\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!a\f\u0001\t\u0003\t\t\u0004C\u0004\u00020\u0001!\t!a\u000e\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005e\u0005bBA\\\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003s\u0003A\u0011AA^\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Dq!!4\u0001\t\u0003\ty\r\u0003\u0005\u0002T\u0002!\t!JAk\u0011\u001d\tI\u000f\u0001C\u0005\u0003WD\u0001B!\u001b\u0001\t\u0003)#1\u000e\u0005\u000b\u00053\u0003\u0011\u0013!C\u0001K\tm\u0005B\u0003BX\u0001E\u0005I\u0011A\u0013\u0003\u001c\"Q!\u0011\u0017\u0001\u0012\u0002\u0013\u0005QEa-\t\u0015\t]\u0006!%A\u0005\u0002\u0015\u0012I\f\u0003\u0005\u0003>\u0002!\t!\nB`\u0011\u001d\u0011)\r\u0001C\u0005\u0005\u000f\u0014Qc\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u00180T1oC\u001e,'O\u0003\u0002%K\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003M\u001d\n1a]9m\u0015\tA\u0013&A\u0003ta\u0006\u00148N\u0003\u0002+W\u00051\u0011\r]1dQ\u0016T\u0011\u0001L\u0001\u0004_J<7\u0001A\n\u0004\u0001=*\u0004C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g\r\u0005\u00027s5\tqG\u0003\u00029O\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002;o\t9Aj\\4hS:<\u0017\u0001D:qCJ\\7+Z:tS>t\u0007CA\u001f?\u001b\u0005)\u0013BA &\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019a\u0014N\\5u}Q\u0011!\t\u0012\t\u0003\u0007\u0002i\u0011a\t\u0005\u0006w\t\u0001\r\u0001P\u0001\u0016gR\fG/Z*u_J,7i\\8sI&t\u0017\r^8s+\u00059\u0005C\u0001%O\u001b\u0005I%B\u0001&L\u0003\u0015\u0019H/\u0019;f\u0015\t!CJ\u0003\u0002NK\u0005IQ\r_3dkRLwN\\\u0005\u0003\u001f&\u0013\u0001d\u0015;bi\u0016\u001cFo\u001c:f\u0007>|'\u000fZ5oCR|'OU3g\u0003Y\u0019H/\u0019;f'R|'/Z\"p_J$\u0017N\\1u_J\u0004\u0013a\u00037jgR,g.\u001a:CkN,\u0012a\u0015\t\u0003)Vk\u0011aS\u0005\u0003-.\u0013\u0011d\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010T5ti\u0016tWM\u001d\"vg\u0006aA.[:uK:,'OQ;tA\u0005i\u0011m\u0019;jm\u0016\fV/\u001a:jKN,\u0012A\u0017\t\u00057\u0002\u0014'.D\u0001]\u0015\tif,A\u0004nkR\f'\r\\3\u000b\u0005}\u000b\u0014AC2pY2,7\r^5p]&\u0011\u0011\r\u0018\u0002\b\u0011\u0006\u001c\b.T1q!\t\u0019\u0007.D\u0001e\u0015\t)g-\u0001\u0003vi&d'\"A4\u0002\t)\fg/Y\u0005\u0003S\u0012\u0014A!V+J\tB\u00111i[\u0005\u0003Y\u000e\u0012ab\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u00180\u0001\bbGRLg/Z)vKJLWm\u001d\u0011)\t!y\u0017P\u001f\t\u0003a^l\u0011!\u001d\u0006\u0003eN\f!bY8oGV\u0014(/\u001a8u\u0015\t!X/\u0001\u0006b]:|G/\u0019;j_:T\u0011A^\u0001\u0006U\u00064\u0018\r_\u0005\u0003qF\u0014\u0011bR;be\u0012,GMQ=\u0002\u000bY\fG.^3\"\u0003m\fq#Y2uSZ,\u0017+^3sS\u0016\u001c8\u000b[1sK\u0012dunY6\u0016\u0003u\u00042A`A\u0002\u001b\u0005y(bAA\u0001M\u0006!A.\u00198h\u0013\r\t)a \u0002\u0007\u001f\nTWm\u0019;\u00021\u0005\u001cG/\u001b<f#V,'/[3t'\"\f'/\u001a3M_\u000e\\\u0007%\u0001\u000bbo\u0006LG\u000fV3s[&t\u0017\r^5p]2{7m[\u0001\u0016C^\f\u0017\u000e\u001e+fe6Lg.\u0019;j_:dunY6!\u0003Ma\u0017m\u001d;UKJl\u0017N\\1uK\u0012\fV/\u001a:z+\u0005Q\u0017a\u00067bgR$VM]7j]\u0006$X\rZ)vKJLx\fJ3r)\u0011\t)\"a\u0007\u0011\u0007A\n9\"C\u0002\u0002\u001aE\u0012A!\u00168ji\"A\u0011Q\u0004\b\u0002\u0002\u0003\u0007!.A\u0002yIE\nA\u0003\\1tiR+'/\\5oCR,G-U;fef\u0004\u0003&B\bps\u0006\r\u0012EAA\u0005\u0003\u0019\t7\r^5wKV\u0011\u0011\u0011\u0006\t\u0005a\u0005-\".C\u0002\u0002.E\u0012Q!\u0011:sCf\f1aZ3u)\rQ\u00171\u0007\u0005\u0007\u0003k\t\u0002\u0019\u00012\u0002\u0005%$Gc\u00016\u0002:!9\u0011Q\u0007\nA\u0002\u0005m\u0002\u0003BA\u001f\u0003\u0017rA!a\u0010\u0002HA\u0019\u0011\u0011I\u0019\u000e\u0005\u0005\r#bAA#[\u00051AH]8pizJ1!!\u00132\u0003\u0019\u0001&/\u001a3fM&!\u0011QJA(\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011J\u0019\u0002'\u0005<\u0018-\u001b;B]f$VM]7j]\u0006$\u0018n\u001c8\u0015\u0005\u0005U\u0001&B\n\u0002X\u0005\r\u0004#\u0002\u0019\u0002Z\u0005u\u0013bAA.c\t1A\u000f\u001b:poN\u00042aQA0\u0013\r\t\tg\t\u0002\u0018'R\u0014X-Y7j]\u001e\fV/\u001a:z\u000bb\u001cW\r\u001d;j_:\ftAHA\u001e\u0003K\n9*M\u0005$\u0003O\ny'!$\u0002rU!\u0011\u0011NA6+\t\tY\u0004B\u0004\u0002n5\u0012\r!a\u001e\u0003\u0003QKA!!\u001d\u0002t\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER1!!\u001e2\u0003\u0019!\bN]8xgF!\u0011\u0011PA@!\r\u0001\u00141P\u0005\u0004\u0003{\n$a\u0002(pi\"Lgn\u001a\t\u0005\u0003\u0003\u000b9ID\u00021\u0003\u0007K1!!\"2\u0003\u001d\u0001\u0018mY6bO\u0016LA!!#\u0002\f\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u000b\u000b\u0014'C\u0012\u0002\u0010\u0006E\u00151SA;\u001d\r\u0001\u0014\u0011S\u0005\u0004\u0003k\n\u0014'\u0002\u00121c\u0005U%!B:dC2\f\u0017g\u0001\u0014\u0002^Q!\u00111TAQ!\r\u0001\u0014QT\u0005\u0004\u0003?\u000b$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003G#\u0002\u0019AAS\u0003%!\u0018.\\3pkRl5\u000fE\u00021\u0003OK1!!+2\u0005\u0011auN\\4)\u000bQ\t9&!,2\u000fy\tY$a,\u00026FJ1%a\u001a\u0002p\u0005E\u0016\u0011O\u0019\nG\u0005=\u0015\u0011SAZ\u0003k\nTA\t\u00192\u0003+\u000b4AJA/\u0003=\u0011Xm]3u)\u0016\u0014X.\u001b8bi\u0016$\u0017aC1eI2K7\u000f^3oKJ$B!!\u0006\u0002>\"9\u0011q\u0018\fA\u0002\u0005\u0005\u0017\u0001\u00037jgR,g.\u001a:\u0011\u0007\r\u000b\u0019-C\u0002\u0002F\u000e\u0012ac\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010T5ti\u0016tWM]\u0001\u000fe\u0016lwN^3MSN$XM\\3s)\u0011\t)\"a3\t\u000f\u0005}v\u00031\u0001\u0002B\u0006iA.[:u\u0019&\u001cH/\u001a8feN$\"!!5\u0011\u000bA\nY#!1\u0002#A|7\u000f\u001e'jgR,g.\u001a:Fm\u0016tG\u000f\u0006\u0003\u0002\u0016\u0005]\u0007bBAm3\u0001\u0007\u00111\\\u0001\u0006KZ,g\u000e\u001e\t\u0005\u0003;\f\u0019OD\u0002D\u0003?L1!!9$\u0003Y\u0019FO]3b[&tw-U;fefd\u0015n\u001d;f]\u0016\u0014\u0018\u0002BAs\u0003O\u0014Q!\u0012<f]RT1!!9$\u0003-\u0019'/Z1uKF+XM]=\u0015-\u00055\u00181_A\u007f\u0005\u0003\u0011\tCa\u000b\u0003@\t%#Q\nB)\u00057\u00022\u0001VAx\u0013\r\t\tp\u0013\u0002\u0016'R\u0014X-Y7j]\u001e\fV/\u001a:z/J\f\u0007\u000f]3s\u0011\u001d\t)P\u0007a\u0001\u0003o\f\u0011#^:feN\u0003XmY5gS\u0016$g*Y7f!\u0015\u0001\u0014\u0011`A\u001e\u0013\r\tY0\r\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005}(\u00041\u0001\u0002x\u0006yRo]3s'B,7-\u001b4jK\u0012\u001c\u0005.Z2la>Lg\u000e\u001e'pG\u0006$\u0018n\u001c8\t\u000f\t\r!\u00041\u0001\u0003\u0006\u0005\u0011AM\u001a\t\u0005\u0005\u000f\u0011YB\u0004\u0003\u0003\n\tea\u0002\u0002B\u0006\u0005/qAA!\u0004\u0003\u00169!!q\u0002B\n\u001d\u0011\t\tE!\u0005\n\u00031J!AK\u0016\n\u0005!J\u0013B\u0001\u0014(\u0013\r\t))J\u0005\u0005\u0005;\u0011yBA\u0005ECR\fgI]1nK*\u0019\u0011QQ\u0013\t\u000f\t\r\"\u00041\u0001\u0003&\u0005aQ\r\u001f;sC>\u0003H/[8ogBA\u0011Q\bB\u0014\u0003w\tY$\u0003\u0003\u0003*\u0005=#aA'ba\"9!Q\u0006\u000eA\u0002\t=\u0012\u0001B:j].\u0004BA!\r\u0003<5\u0011!1\u0007\u0006\u0005\u0005k\u00119$A\u0004dCR\fGn\\4\u000b\u0007\teR%A\u0005d_:tWm\u0019;pe&!!Q\bB\u001a\u0005\u0015!\u0016M\u00197f\u0011\u001d\u0011\tE\u0007a\u0001\u0005\u0007\n!b\\;uaV$Xj\u001c3f!\r\u0019%QI\u0005\u0004\u0005\u000f\u001a#AC(viB,H/T8eK\"9!1\n\u000eA\u0002\u0005m\u0015!G;tKR+W\u000e]\"iK\u000e\\\u0007o\\5oi2{7-\u0019;j_:DqAa\u0014\u001b\u0001\u0004\tY*A\u000fsK\u000e|g/\u001a:Ge>l7\t[3dWB|\u0017N\u001c;M_\u000e\fG/[8o\u0011\u001d\u0011\u0019F\u0007a\u0001\u0005+\nq\u0001\u001e:jO\u001e,'\u000fE\u0002D\u0005/J1A!\u0017$\u0005\u001d!&/[4hKJDqA!\u0018\u001b\u0001\u0004\u0011y&\u0001\u0007ue&<w-\u001a:DY>\u001c7\u000e\u0005\u0003\u0003b\t\u0015TB\u0001B2\u0015\t)w%\u0003\u0003\u0003h\t\r$!B\"m_\u000e\\\u0017AC:uCJ$\u0018+^3ssR)\"N!\u001c\u0003p\tE$1\u000fB;\u0005o\u0012IHa\u001f\u0003~\t}\u0004bBA{7\u0001\u0007\u0011q\u001f\u0005\b\u0003\u007f\\\u0002\u0019AA|\u0011\u001d\u0011\u0019a\u0007a\u0001\u0005\u000bAqAa\t\u001c\u0001\u0004\u0011)\u0003C\u0004\u0003.m\u0001\rAa\f\t\u000f\t\u00053\u00041\u0001\u0003D!I!1J\u000e\u0011\u0002\u0003\u0007\u00111\u0014\u0005\n\u0005\u001fZ\u0002\u0013!a\u0001\u00037C\u0011Ba\u0015\u001c!\u0003\u0005\rA!\u0016\t\u0013\tu3\u0004%AA\u0002\t}\u0003&B\u000e\u0003\u0004\n=\u0005#\u0002\u0019\u0002Z\t\u0015\u0005\u0003\u0002BD\u0005\u0017k!A!#\u000b\u0005I$\u0017\u0002\u0002BG\u0005\u0013\u0013\u0001\u0003V5nK>,H/\u0012=dKB$\u0018n\u001c82\u000fy\tYD!%\u0003\u0018FJ1%a\u001a\u0002p\tM\u0015\u0011O\u0019\nG\u0005=\u0015\u0011\u0013BK\u0003k\nTA\t\u00192\u0003+\u000b4A\nBC\u0003Q\u0019H/\u0019:u#V,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!Q\u0014\u0016\u0005\u00037\u0013yj\u000b\u0002\u0003\"B!!1\u0015BV\u001b\t\u0011)K\u0003\u0003\u0003(\n%\u0016!C;oG\",7m[3e\u0015\t!\u0018'\u0003\u0003\u0003.\n\u0015&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!2\u000f^1siF+XM]=%I\u00164\u0017-\u001e7uIa\nAc\u001d;beR\fV/\u001a:zI\u0011,g-Y;mi\u0012JTC\u0001B[U\u0011\u0011)Fa(\u0002+M$\u0018M\u001d;Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132aU\u0011!1\u0018\u0016\u0005\u0005?\u0012y*\u0001\fo_RLg-_)vKJLH+\u001a:nS:\fG/[8o)\u0011\t)B!1\t\r\t\r\u0007\u00051\u0001k\u0003=!XM]7j]\u0006$X\rZ)vKJL\u0018AG;oe\u0016<\u0017n\u001d;feR+'/\\5oCR,Gm\u0015;sK\u0006lG\u0003BA\u000b\u0005\u0013DaAa1\"\u0001\u0004Q\u0007f\u0001\u0001\u0003NB!!q\u001aBj\u001b\t\u0011\tN\u0003\u0002uO%!!Q\u001bBi\u0005!)eo\u001c7wS:<\u0007")
public class StreamingQueryManager
implements Logging {
    private final SparkSession sparkSession;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final StreamingQueryListenerBus listenerBus;
    @GuardedBy(value="activeQueriesSharedLock")
    private final HashMap<UUID, StreamingQuery> activeQueries;
    private final Object activeQueriesSharedLock;
    private final Object awaitTerminationLock;
    @GuardedBy(value="awaitTerminationLock")
    private StreamingQuery lastTerminatedQuery;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private StreamingQueryListenerBus listenerBus() {
        return this.listenerBus;
    }

    private HashMap<UUID, StreamingQuery> activeQueries() {
        return this.activeQueries;
    }

    private Object activeQueriesSharedLock() {
        return this.activeQueriesSharedLock;
    }

    private Object awaitTerminationLock() {
        return this.awaitTerminationLock;
    }

    private StreamingQuery lastTerminatedQuery() {
        return this.lastTerminatedQuery;
    }

    private void lastTerminatedQuery_$eq(StreamingQuery x$1) {
        this.lastTerminatedQuery = x$1;
    }

    public StreamingQuery[] active() {
        StreamingQuery[] streamingQueryArray;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQueryArray = (StreamingQuery[])this.activeQueries().values().toArray(ClassTag$.MODULE$.apply(StreamingQuery.class));
        }
        return streamingQueryArray;
    }

    public StreamingQuery get(UUID id) {
        StreamingQuery streamingQuery;
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            streamingQuery = (StreamingQuery)this.activeQueries().get((Object)id).orNull(Predef$.MODULE$.$conforms());
        }
        return streamingQuery;
    }

    public StreamingQuery get(String id) {
        return this.get(UUID.fromString(id));
    }

    public void awaitAnyTermination() throws StreamingQueryException {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (this.lastTerminatedQuery() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQuery() != null && this.lastTerminatedQuery().exception().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQuery().exception().get();
            }
        }
    }

    public boolean awaitAnyTermination(long timeoutMs) throws StreamingQueryException {
        boolean bl;
        long startTime = System.nanoTime();
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (!StreamingQueryManager.isTimedout$1(startTime, timeoutMs) && this.lastTerminatedQuery() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQuery() != null && this.lastTerminatedQuery().exception().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQuery().exception().get();
            }
            bl = this.lastTerminatedQuery() != null;
        }
        return bl;
    }

    public void resetTerminated() {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            this.lastTerminatedQuery_$eq(null);
        }
    }

    public void addListener(StreamingQueryListener listener) {
        this.listenerBus().addListener(listener);
    }

    public void removeListener(StreamingQueryListener listener) {
        this.listenerBus().removeListener(listener);
    }

    public StreamingQueryListener[] listListeners() {
        return (StreamingQueryListener[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.listenerBus().listeners()).asScala()).toArray(ClassTag$.MODULE$.apply(StreamingQueryListener.class));
    }

    public void postListenerEvent(StreamingQueryListener.Event event) {
        this.listenerBus().post(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamingQueryWrapper createQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock) {
        Tuple2 tuple2;
        Path checkpointPath;
        FileSystem fs;
        BooleanRef deleteCheckpointOnStop = BooleanRef.create((boolean)false);
        String checkpointLocation = (String)userSpecifiedCheckpointLocation.map((Function1 & Serializable & scala.Serializable)userSpecified -> new Path(userSpecified).toString()).orElse((Function0 & Serializable & scala.Serializable)() -> df.sparkSession().sessionState().conf().checkpointLocation().map((Function1 & Serializable & scala.Serializable)location -> new Path(location, (String)userSpecifiedName.getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString())).toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var3_5;
            if (!useTempCheckpointLocation) {
                throw new AnalysisException(new StringBuilder(119).append("checkpointLocation must be specified either through option(\"checkpointLocation\", ...) or ").append("SparkSession.conf.set(\"").append(SQLConf$.MODULE$.CHECKPOINT_LOCATION().key()).append("\", ...)").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            deleteCheckpointOnStop$1.elem = true;
            String x$1 = "temporary";
            String x$2 = Utils$.MODULE$.createTempDir$default$1();
            String tempDir = Utils$.MODULE$.createTempDir(x$2, x$1).getCanonicalPath();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(235).append("Temporary checkpoint location created which is deleted normally when").append(" the query didn't fail: ").append(tempDir).append(". If it's required to delete it under any").append(" circumstances, please set ").append(SQLConf$.MODULE$.FORCE_DELETE_TEMP_CHECKPOINT_LOCATION().key()).append(" to").append(" true. Important to know deleting temp checkpoint folder is best effort.").toString());
            return var3_5;
        });
        if (!recoverFromCheckpointLocation && (fs = (checkpointPath = new Path(checkpointLocation, "offsets")).getFileSystem(df.sparkSession().sessionState().newHadoopConf())).exists(checkpointPath)) {
            throw new AnalysisException(new StringBuilder(87).append("This query does not support recovering from checkpoint location. ").append("Delete ").append(checkpointPath).append(" to start over.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        LogicalPlan analyzedPlan = df.queryExecution().analyzed();
        df.queryExecution().assertAnalyzed();
        boolean operationCheckEnabled = this.sparkSession.sessionState().conf().isUnsupportedOperationCheckEnabled();
        if (this.sparkSession.sessionState().conf().adaptiveExecutionEnabled()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append(SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key()).append(" ").append("is not supported in streaming DataFrames/Datasets and will be disabled.").toString());
        }
        if ((tuple2 = new Tuple2((Object)sink, (Object)trigger)) != null) {
            Table table = (Table)tuple2._1();
            Trigger trigger2 = (Trigger)tuple2._2();
            if (table instanceof SupportsWrite) {
                SupportsWrite supportsWrite = (SupportsWrite)table;
                if (trigger2 instanceof ContinuousTrigger) {
                    ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
                    if (!operationCheckEnabled) return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, supportsWrite, continuousTrigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
                    UnsupportedOperationChecker$.MODULE$.checkForContinuous(analyzedPlan, outputMode);
                    return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, supportsWrite, continuousTrigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
                }
            }
        }
        if (!operationCheckEnabled) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        UnsupportedOperationChecker$.MODULE$.checkForStreaming(analyzedPlan, outputMode);
        return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamingQuery startQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, Table sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock) throws TimeoutException {
        None$ none$;
        StreamingQueryWrapper query = this.createQuery(userSpecifiedName, userSpecifiedCheckpointLocation, df, extraOptions, sink, outputMode, useTempCheckpointLocation, recoverFromCheckpointLocation, trigger, triggerClock);
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            None$ none$2;
            userSpecifiedName.foreach((Function1 & Serializable & scala.Serializable)name -> {
                StreamingQueryManager.$anonfun$startQuery$1(this, name);
                return BoxedUnit.UNIT;
            });
            Option activeOption = Option$.MODULE$.apply((Object)this.sparkSession.sharedState().activeStreamingQueries().get(query.id())).orElse((Function0 & Serializable & scala.Serializable)() -> this.activeQueries().get((Object)query.id()));
            boolean shouldStopActiveRun = BoxesRunTime.unboxToBoolean((Object)this.sparkSession.sessionState().conf().getConf(SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART()));
            if (activeOption.isDefined()) {
                if (!shouldStopActiveRun) throw new IllegalStateException(new StringBuilder(259).append("Cannot start query with id ").append(query.id()).append(" as another query with same id is ").append("already active. Perhaps you are attempting to restart a query from checkpoint ").append("that is already active. You may stop the old query by setting the SQL ").append("configuration: ").append("spark.conf.set(\"").append(SQLConf$.MODULE$.STREAMING_STOP_ACTIVE_RUN_ON_RESTART().key()).append("\", true) ").append("and retry.").toString());
                StreamingQuery oldQuery = (StreamingQuery)activeOption.get();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("Stopping existing streaming query [id=").append(query.id()).append(", ").append("runId=").append(oldQuery.runId()).append("], as a new run is being started.").toString());
                none$2 = new Some((Object)oldQuery);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        None$ activeRunOpt = none$;
        activeRunOpt.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
        Object object2 = this.activeQueriesSharedLock();
        synchronized (object2) {
            StreamExecution oldActiveQuery = this.sparkSession.sharedState().activeStreamingQueries().put(query.id(), query.streamingQuery());
            if (oldActiveQuery != null) {
                throw new ConcurrentModificationException("Another instance of this query was just started by a concurrent session.");
            }
            this.activeQueries().put((Object)query.id(), (Object)query);
        }
        try {
            query.streamingQuery().start();
            return query;
        }
        catch (Throwable e) {
            this.unregisterTerminatedStream(query);
            throw e;
        }
    }

    public boolean startQuery$default$7() {
        return false;
    }

    public boolean startQuery$default$8() {
        return true;
    }

    public Trigger startQuery$default$9() {
        return Trigger.ProcessingTime(0L);
    }

    public Clock startQuery$default$10() {
        return new SystemClock();
    }

    public void notifyQueryTermination(StreamingQuery terminatedQuery) {
        this.unregisterTerminatedStream(terminatedQuery);
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            if (this.lastTerminatedQuery() == null || terminatedQuery.exception().nonEmpty()) {
                this.lastTerminatedQuery_$eq(terminatedQuery);
            }
            this.awaitTerminationLock().notifyAll();
        }
        this.stateStoreCoordinator().deactivateInstances(terminatedQuery.runId());
    }

    private void unregisterTerminatedStream(StreamingQuery terminatedQuery) {
        Object object = this.activeQueriesSharedLock();
        synchronized (object) {
            this.sparkSession.sharedState().activeStreamingQueries().remove(terminatedQuery.id(), terminatedQuery);
            this.activeQueries().$minus$eq((Object)terminatedQuery.id());
        }
    }

    public static final /* synthetic */ void $anonfun$new$2(StreamingQueryManager $this, StreamingQueryListener listener) {
        $this.addListener(listener);
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Registered listener ").append(listener.getClass().getName()).toString());
    }

    public static final /* synthetic */ void $anonfun$new$1(StreamingQueryManager $this, Seq classNames) {
        Utils$.MODULE$.loadExtensions(StreamingQueryListener.class, classNames, $this.sparkSession.sparkContext().conf()).foreach((Function1 & Serializable & scala.Serializable)listener -> {
            StreamingQueryManager.$anonfun$new$2($this, listener);
            return BoxedUnit.UNIT;
        });
    }

    private static final boolean isTimedout$1(long startTime$1, long timeoutMs$1) {
        return System.nanoTime() - startTime$1 >= TimeUnit.MILLISECONDS.toNanos(timeoutMs$1);
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$2(String name$1, StreamingQuery x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startQuery$1(StreamingQueryManager $this, String name) {
        if ($this.activeQueries().values().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$2(name, x$1)))) {
            throw new IllegalArgumentException(new StringBuilder(94).append("Cannot start query with name ").append(name).append(" as a query ").append("with that name is already active in this SparkSession").toString());
        }
    }

    public StreamingQueryManager(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.stateStoreCoordinator = StateStoreCoordinatorRef$.MODULE$.forDriver(sparkSession.sparkContext().env());
        this.listenerBus = new StreamingQueryListenerBus(sparkSession.sparkContext().listenerBus());
        this.activeQueries = new HashMap();
        this.activeQueriesSharedLock = sparkSession.sharedState().activeQueriesLock();
        this.awaitTerminationLock = new Object();
        this.lastTerminatedQuery = null;
        try {
            ((Option)sparkSession.sparkContext().conf().get((ConfigEntry)StaticSQLConf$.MODULE$.STREAMING_QUERY_LISTENERS())).foreach((Function1 & Serializable & scala.Serializable)classNames -> {
                StreamingQueryManager.$anonfun$new$1(this, classNames);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            throw new SparkException("Exception when registering StreamingQueryListener", (Throwable)e);
        }
    }
}

