/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.v2;

import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.datasources.v2.FileScan;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Utils$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000194QAC\u0006\u0002\u0002iA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tI\u0001\u0011\t\u0011)A\u0005K!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u0003+\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0004\"\u0002\u001d\u0001\t\u0003I\u0004\u0002\u0003!\u0001\u0011\u000b\u0007I\u0011B!\t\u000bM\u0003A\u0011\t+\t\u000b\u0001\u0004A\u0011I1\u0003#Q+\u0007\u0010\u001e\"bg\u0016$g)\u001b7f'\u000e\fgN\u0003\u0002\r\u001b\u0005\u0011aO\r\u0006\u0003\u001d=\t1\u0002Z1uCN|WO]2fg*\u0011\u0001#E\u0001\nKb,7-\u001e;j_:T!AE\n\u0002\u0007M\fHN\u0003\u0002\u0015+\u0005)1\u000f]1sW*\u0011acF\u0001\u0007CB\f7\r[3\u000b\u0003a\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\u000e\u0011\u0005qiR\"A\u0006\n\u0005yY!\u0001\u0003$jY\u0016\u001c6-\u00198\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005\u0005\u0012S\"A\t\n\u0005\r\n\"\u0001D*qCJ\\7+Z:tS>t\u0017!\u00034jY\u0016Le\u000eZ3y!\t1s%D\u0001\u000e\u0013\tASB\u0001\u000eQCJ$\u0018\u000e^5p]&tw-Q<be\u00164\u0015\u000e\\3J]\u0012,\u00070\u0001\bsK\u0006$G)\u0019;b'\u000eDW-\\1\u0011\u0005-rS\"\u0001\u0017\u000b\u00055\n\u0012!\u0002;za\u0016\u001c\u0018BA\u0018-\u0005)\u0019FO];diRK\b/Z\u0001\u0014e\u0016\fG\rU1si&$\u0018n\u001c8TG\",W.Y\u0001\b_B$\u0018n\u001c8t!\t\u0019d'D\u00015\u0015\t)\u0014#\u0001\u0003vi&d\u0017BA\u001c5\u0005a\u0019\u0015m]3J]N,gn]5uSZ,7\u000b\u001e:j]\u001el\u0015\r]\u0001\u0007y%t\u0017\u000e\u001e \u0015\riZD(\u0010 @!\ta\u0002\u0001C\u0003 \r\u0001\u0007\u0001\u0005C\u0003%\r\u0001\u0007Q\u0005C\u0003*\r\u0001\u0007!\u0006C\u00031\r\u0001\u0007!\u0006C\u00032\r\u0001\u0007!'\u0001\u0007d_\u0012,7MR1di>\u0014\u00180F\u0001C!\t\u0019%*D\u0001E\u0015\t)e)\u0001\u0005d_6\u0004(/Z:t\u0015\t9\u0005*\u0001\u0002j_*\u0011\u0011*F\u0001\u0007Q\u0006$wn\u001c9\n\u0005-#%aF\"p[B\u0014Xm]:j_:\u001cu\u000eZ3d\r\u0006\u001cGo\u001c:zQ\t9Q\n\u0005\u0002O#6\tqJC\u0001Q\u0003\u0015\u00198-\u00197b\u0013\t\u0011vJA\u0005ue\u0006t7/[3oi\u0006Y\u0011n]*qY&$\u0018M\u00197f)\t)\u0006\f\u0005\u0002O-&\u0011qk\u0014\u0002\b\u0005>|G.Z1o\u0011\u0015I\u0006\u00021\u0001[\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005msV\"\u0001/\u000b\u0005uC\u0015A\u00014t\u0013\tyFL\u0001\u0003QCRD\u0017!G4fi\u001aKG.Z+o'Bd\u0017\u000e\u001e;bE2,'+Z1t_:$\"AY7\u0011\u0005\rTgB\u00013i!\t)w*D\u0001g\u0015\t9\u0017$\u0001\u0004=e>|GOP\u0005\u0003S>\u000ba\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011n\u0014\u0005\u00063&\u0001\rA\u0017")
public abstract class TextBasedFileScan
extends FileScan {
    private transient CompressionCodecFactory codecFactory;
    private final SparkSession sparkSession;
    private final CaseInsensitiveStringMap options;
    private volatile transient boolean bitmap$trans$0;

    private CompressionCodecFactory codecFactory$lzycompute() {
        TextBasedFileScan textBasedFileScan = this;
        synchronized (textBasedFileScan) {
            if (!this.bitmap$trans$0) {
                this.codecFactory = new CompressionCodecFactory(this.sparkSession.sessionState().newHadoopConfWithOptions((scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.options).asScala()).toMap(Predef$.MODULE$.$conforms())));
                this.bitmap$trans$0 = true;
            }
        }
        return this.codecFactory;
    }

    private CompressionCodecFactory codecFactory() {
        return !this.bitmap$trans$0 ? this.codecFactory$lzycompute() : this.codecFactory;
    }

    @Override
    public boolean isSplitable(Path path) {
        return Utils$.MODULE$.isFileSplittable(path, this.codecFactory());
    }

    @Override
    public String getFileUnSplittableReason(Path path) {
        Predef$.MODULE$.assert(!this.isSplitable(path));
        return "the file is compressed by unsplittable compression codec";
    }

    public TextBasedFileScan(SparkSession sparkSession, PartitioningAwareFileIndex fileIndex, StructType readDataSchema, StructType readPartitionSchema, CaseInsensitiveStringMap options) {
        this.sparkSession = sparkSession;
        this.options = options;
        super(sparkSession, fileIndex, readDataSchema, readPartitionSchema);
    }
}

