/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRecordMaterializer;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMb\u0001\u0002\u000f\u001e\u00011B\u0001B\u0011\u0001\u0003\u0006\u0004%\ta\u0011\u0005\t%\u0002\u0011\t\u0011)A\u0005\t\"A1\u000b\u0001B\u0001B\u0003%A\u000bC\u0003X\u0001\u0011\u0005\u0001\fC\u0005^\u0001\u0001\u0007\t\u0019!C\u0005=\"IQ\r\u0001a\u0001\u0002\u0004%IA\u001a\u0005\nY\u0002\u0001\r\u0011!Q!\n}CQa\u0016\u0001\u0005\u00025DQA\u001c\u0001\u0005B=Dq!a\u0005\u0001\t\u0003\n)bB\u0004\u0002duA\t!!\u001a\u0007\rqi\u0002\u0012AA4\u0011\u00199F\u0002\"\u0001\u0002p!I\u0011\u0011\u000f\u0007C\u0002\u0013\u0005\u00111\u000f\u0005\t\u0003\u007fb\u0001\u0015!\u0003\u0002v!I\u0011\u0011\u0011\u0007C\u0002\u0013\u0005\u00111\u000f\u0005\t\u0003\u0007c\u0001\u0015!\u0003\u0002v!9\u0011Q\u0011\u0007\u0005\u0002\u0005\u001d\u0005\"CAK\u0019E\u0005I\u0011AAL\u0011\u001d\ti\u000b\u0004C\u0005\u0003_Cq!a2\r\t\u0013\tI\rC\u0004\u0002P2!I!!5\t\u000f\u0005\rH\u0002\"\u0003\u0002f\"9\u0011Q\u001f\u0007\u0005\n\u0005]\bb\u0002B\u0002\u0019\u0011%!Q\u0001\u0005\b\u0005?aA\u0011\u0002B\u0011\u0011\u001d\u0011i\u0003\u0004C\u0001\u0005_\u0011!\u0003U1scV,GOU3bIN+\b\u000f]8si*\u0011adH\u0001\ba\u0006\u0014\u0018/^3u\u0015\t\u0001\u0013%A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001\u0012$\u0003%)\u00070Z2vi&|gN\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001[q\u00022A\f\u001b7\u001b\u0005y#B\u0001\u00192\u0003\r\t\u0007/\u001b\u0006\u0003eM\na\u0001[1e_>\u0004(B\u0001\u0010(\u0013\t)tFA\u0006SK\u0006$7+\u001e9q_J$\bCA\u001c;\u001b\u0005A$BA\u001d$\u0003!\u0019\u0017\r^1msN$\u0018BA\u001e9\u0005-Ie\u000e^3s]\u0006d'k\\<\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}*\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005\u0005s$a\u0002'pO\u001eLgnZ\u0001\nG>tg/\u001a:u)j,\u0012\u0001\u0012\t\u0004\u000b\"SU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\r=\u0003H/[8o!\tY\u0005+D\u0001M\u0015\tie*\u0001\u0003vi&d'\"A(\u0002\t)\fg/Y\u0005\u0003#2\u0013\u0001\u0002V5nKj{g.Z\u0001\u000bG>tg/\u001a:u)j\u0004\u0013AF3oC\ndWMV3di>\u0014\u0018N_3e%\u0016\fG-\u001a:\u0011\u0005\u0015+\u0016B\u0001,G\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDcA-\\9B\u0011!\fA\u0007\u0002;!)!\t\u0002a\u0001\t\")1\u000b\u0002a\u0001)\u000692-\u0019;bYf\u001cHOU3rk\u0016\u001cH/\u001a3TG\",W.Y\u000b\u0002?B\u0011\u0001mY\u0007\u0002C*\u0011!mI\u0001\u0006if\u0004Xm]\u0005\u0003I\u0006\u0014!b\u0015;sk\u000e$H+\u001f9f\u0003m\u0019\u0017\r^1msN$(+Z9vKN$X\rZ*dQ\u0016l\u0017m\u0018\u0013fcR\u0011qM\u001b\t\u0003\u000b\"L!!\u001b$\u0003\tUs\u0017\u000e\u001e\u0005\bW\u001a\t\t\u00111\u0001`\u0003\rAH%M\u0001\u0019G\u0006$\u0018\r\\=tiJ+\u0017/^3ti\u0016$7k\u00195f[\u0006\u0004C#A-\u0002\t%t\u0017\u000e\u001e\u000b\u0004a\u0006%\u0001cA9\u0002\u00049\u0011!o \b\u0003gzt!\u0001^?\u000f\u0005UdhB\u0001<|\u001d\t9(0D\u0001y\u0015\tI8&\u0001\u0004=e>|GOP\u0005\u0002U%\u0011\u0001&K\u0005\u0003=\u001dJ!AM\u001a\n\u0005A\n\u0014bAA\u0001_\u0005Y!+Z1e'V\u0004\bo\u001c:u\u0013\u0011\t)!a\u0002\u0003\u0017I+\u0017\rZ\"p]R,\u0007\u0010\u001e\u0006\u0004\u0003\u0003y\u0003bBA\u0006\u0013\u0001\u0007\u0011QB\u0001\bG>tG/\u001a=u!\rq\u0013qB\u0005\u0004\u0003#y#aC%oSR\u001cuN\u001c;fqR\fa\u0002\u001d:fa\u0006\u0014XMR8s%\u0016\fG\r\u0006\u0006\u0002\u0018\u0005\u0015\u0012QGA(\u0003?\u0002R!!\u0007\u0002\"Yj!!a\u0007\u000b\u0007A\niBC\u0002\u0002 M\n!![8\n\t\u0005\r\u00121\u0004\u0002\u0013%\u0016\u001cwN\u001d3NCR,'/[1mSj,'\u000fC\u0004\u0002()\u0001\r!!\u000b\u0002\t\r|gN\u001a\t\u0005\u0003W\t\t$\u0004\u0002\u0002.)!\u0011qEA\u0018\u0015\t\u0011t%\u0003\u0003\u00024\u00055\"!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004\u00028)\u0001\r!!\u000f\u0002!-,\u0017PV1mk\u0016lU\r^1ECR\f\u0007cB&\u0002<\u0005}\u0012qH\u0005\u0004\u0003{a%aA'baB!\u0011\u0011IA%\u001d\u0011\t\u0019%!\u0012\u0011\u0005]4\u0015bAA$\r\u00061\u0001K]3eK\u001aLA!a\u0013\u0002N\t11\u000b\u001e:j]\u001eT1!a\u0012G\u0011\u001d\t\tF\u0003a\u0001\u0003'\n!BZ5mKN\u001b\u0007.Z7b!\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-g\u000511o\u00195f[\u0006LA!!\u0018\u0002X\tYQ*Z:tC\u001e,G+\u001f9f\u0011\u0019\t\tG\u0003a\u0001a\u0006Y!/Z1e\u0007>tG/\u001a=u\u0003I\u0001\u0016M]9vKR\u0014V-\u00193TkB\u0004xN\u001d;\u0011\u0005ic1c\u0001\u0007\u0002jA\u0019Q)a\u001b\n\u0007\u00055dI\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003K\n!d\u0015)B%.{&kT,`%\u0016\u000bV+R*U\u000b\u0012{6k\u0011%F\u001b\u0006+\"!!\u001e\u0011\t\u0005]\u0014QP\u0007\u0003\u0003sR1!a\u001fO\u0003\u0011a\u0017M\\4\n\t\u0005-\u0013\u0011P\u0001\u001c'B\u000b%kS0S\u001f^{&+R)V\u000bN#V\tR0T\u0007\"+U*\u0011\u0011\u0002%M\u0003\u0016IU&`\u001b\u0016#\u0016\tR!U\u0003~[U)W\u0001\u0014'B\u000b%kS0N\u000bR\u000bE)\u0011+B?.+\u0015\fI\u0001\u0012G2L\u0007\u000fU1scV,GoU2iK6\fG\u0003CA*\u0003\u0013\u000bi)!%\t\u000f\u0005-%\u00031\u0001\u0002T\u0005i\u0001/\u0019:rk\u0016$8k\u00195f[\u0006Da!a$\u0013\u0001\u0004y\u0016AD2bi\u0006d\u0017p\u001d;TG\",W.\u0019\u0005\t\u0003'\u0013\u0002\u0013!a\u0001)\u0006i1-Y:f'\u0016t7/\u001b;jm\u0016\f1d\u00197jaB\u000b'/];fiN\u001b\u0007.Z7bI\u0011,g-Y;mi\u0012\u001aTCAAMU\r!\u00161T\u0016\u0003\u0003;\u0003B!a(\u0002*6\u0011\u0011\u0011\u0015\u0006\u0005\u0003G\u000b)+A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0015$\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002,\u0006\u0005&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y1\r\\5q!\u0006\u0014\u0018/^3u)f\u0004X\r\u0006\u0005\u00022\u0006]\u00161XAc!\u0011\t)&a-\n\t\u0005U\u0016q\u000b\u0002\u0005)f\u0004X\rC\u0004\u0002:R\u0001\r!!-\u0002\u0017A\f'/];fiRK\b/\u001a\u0005\b\u0003{#\u0002\u0019AA`\u00031\u0019\u0017\r^1msN$H+\u001f9f!\r\u0001\u0017\u0011Y\u0005\u0004\u0003\u0007\f'\u0001\u0003#bi\u0006$\u0016\u0010]3\t\r\u0005ME\u00031\u0001U\u0003]I7\u000f\u0015:j[&$\u0018N^3DCR\fG._:u)f\u0004X\rF\u0002U\u0003\u0017Dq!!4\u0016\u0001\u0004\ty,\u0001\u0005eCR\fG+\u001f9f\u0003M\u0019G.\u001b9QCJ\fX/\u001a;MSN$H+\u001f9f)!\t\t,a5\u0002^\u0006\u0005\bbBAk-\u0001\u0007\u0011q[\u0001\fa\u0006\u0014\u0018/^3u\u0019&\u001cH\u000f\u0005\u0003\u0002V\u0005e\u0017\u0002BAn\u0003/\u0012\u0011b\u0012:pkB$\u0016\u0010]3\t\u000f\u0005}g\u00031\u0001\u0002@\u0006YQ\r\\3nK:$H+\u001f9f\u0011\u0019\t\u0019J\u0006a\u0001)\u0006\u00112\r\\5q!\u0006\u0014\u0018/^3u\u001b\u0006\u0004H+\u001f9f))\t9.a:\u0002l\u0006=\u00181\u001f\u0005\b\u0003S<\u0002\u0019AAl\u0003)\u0001\u0018M]9vKRl\u0015\r\u001d\u0005\b\u0003[<\u0002\u0019AA`\u0003\u001dYW-\u001f+za\u0016Dq!!=\u0018\u0001\u0004\ty,A\u0005wC2,X\rV=qK\"1\u00111S\fA\u0002Q\u000b\u0001c\u00197jaB\u000b'/];fi\u001e\u0013x.\u001e9\u0015\u0011\u0005]\u0017\u0011`A\u007f\u0005\u0003Aq!a?\u0019\u0001\u0004\t9.A\u0007qCJ\fX/\u001a;SK\u000e|'\u000f\u001a\u0005\u0007\u0003\u007fD\u0002\u0019A0\u0002\u0015M$(/^2u)f\u0004X\r\u0003\u0004\u0002\u0014b\u0001\r\u0001V\u0001\u0017G2L\u0007\u000fU1scV,Go\u0012:pkB4\u0015.\u001a7egRA!q\u0001B\r\u00057\u0011i\u0002\u0005\u0004\u0003\n\tM\u0011\u0011\u0017\b\u0005\u0005\u0017\u0011yAD\u0002x\u0005\u001bI\u0011aR\u0005\u0004\u0005#1\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005+\u00119BA\u0002TKFT1A!\u0005G\u0011\u001d\tY0\u0007a\u0001\u0003/Da!a@\u001a\u0001\u0004y\u0006BBAJ3\u0001\u0007A+\u0001\fj]R,'o]3diB\u000b'/];fi\u001e\u0013x.\u001e9t)\u0019\u0011\u0019C!\n\u0003*A!Q\tSAl\u0011\u001d\u00119C\u0007a\u0001\u0003/\f!b\u001a:pkB$\u0016\u0010]32\u0011\u001d\u0011YC\u0007a\u0001\u0003/\f!b\u001a:pkB$\u0016\u0010]33\u0003%)\u0007\u0010]1oIV#E\u000bF\u0002`\u0005cAa!!\u0017\u001c\u0001\u0004y\u0006")
public class ParquetReadSupport
extends ReadSupport<InternalRow>
implements Logging {
    private final Option<TimeZone> convertTz;
    private final boolean enableVectorizedReader;
    private StructType catalystRequestedSchema;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static StructType expandUDT(StructType structType) {
        return ParquetReadSupport$.MODULE$.expandUDT(structType);
    }

    public static boolean clipParquetSchema$default$3() {
        return ParquetReadSupport$.MODULE$.clipParquetSchema$default$3();
    }

    public static MessageType clipParquetSchema(MessageType messageType, StructType structType, boolean bl) {
        return ParquetReadSupport$.MODULE$.clipParquetSchema(messageType, structType, bl);
    }

    public static String SPARK_METADATA_KEY() {
        return ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY();
    }

    public static String SPARK_ROW_REQUESTED_SCHEMA() {
        return ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<TimeZone> convertTz() {
        return this.convertTz;
    }

    private StructType catalystRequestedSchema() {
        return this.catalystRequestedSchema;
    }

    private void catalystRequestedSchema_$eq(StructType x$1) {
        this.catalystRequestedSchema = x$1;
    }

    public ReadSupport.ReadContext init(InitContext context) {
        Configuration conf = context.getConfiguration();
        String schemaString = conf.get(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA());
        Predef$.MODULE$.assert(schemaString != null, (Function0 & Serializable & scala.Serializable)() -> "Parquet requested schema not set.");
        this.catalystRequestedSchema_$eq(StructType$.MODULE$.fromString(schemaString));
        boolean caseSensitive = conf.getBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.CASE_SENSITIVE().defaultValue().get()));
        boolean schemaPruningEnabled = conf.getBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().defaultValue().get()));
        MessageType parquetFileSchema = context.getFileSchema();
        MessageType parquetClippedSchema = ParquetReadSupport$.MODULE$.clipParquetSchema(parquetFileSchema, this.catalystRequestedSchema(), caseSensitive);
        MessageType parquetRequestedSchema = schemaPruningEnabled && !this.enableVectorizedReader ? (MessageType)ParquetReadSupport$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$ParquetReadSupport$$intersectParquetGroups((GroupType)parquetClippedSchema, (GroupType)parquetFileSchema).map((Function1 & Serializable & scala.Serializable)groupType -> new MessageType(groupType.getName(), groupType.getFields())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ParquetSchemaConverter$.MODULE$.EMPTY_MESSAGE()) : parquetClippedSchema;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(273).append("Going to read the following fields from the Parquet file with the following schema:\n         |Parquet file schema:\n         |").append(parquetFileSchema).append("\n         |Parquet clipped schema:\n         |").append(parquetClippedSchema).append("\n         |Parquet requested schema:\n         |").append(parquetRequestedSchema).append("\n         |Catalyst requested schema:\n         |").append(this.catalystRequestedSchema().treeString()).append("\n       ").toString())).stripMargin());
        return new ReadSupport.ReadContext(parquetRequestedSchema, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());
    }

    public RecordMaterializer<InternalRow> prepareForRead(Configuration conf, java.util.Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        MessageType parquetRequestedSchema = readContext.getRequestedSchema();
        return new ParquetRecordMaterializer(parquetRequestedSchema, ParquetReadSupport$.MODULE$.expandUDT(this.catalystRequestedSchema()), new ParquetToSparkSchemaConverter(conf), this.convertTz());
    }

    public ParquetReadSupport(Option<TimeZone> convertTz, boolean enableVectorizedReader) {
        this.convertTz = convertTz;
        this.enableVectorizedReader = enableVectorizedReader;
        Logging.$init$((Logging)this);
    }

    public ParquetReadSupport() {
        this((Option<TimeZone>)None$.MODULE$, true);
    }
}

