/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.DropTableCommand$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ue\u0001B\u000f\u001f\u0001.B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\u000b\"A!\n\u0001BK\u0002\u0013\u00051\n\u0003\u0005P\u0001\tE\t\u0015!\u0003M\u0011!\u0001\u0006A!f\u0001\n\u0003Y\u0005\u0002C)\u0001\u0005#\u0005\u000b\u0011\u0002'\t\u0011I\u0003!Q3A\u0005\u0002-C\u0001b\u0015\u0001\u0003\u0012\u0003\u0006I\u0001\u0014\u0005\u0006)\u0002!\t!\u0016\u0005\u00067\u0002!\t\u0005\u0018\u0005\be\u0002\t\t\u0011\"\u0001t\u0011\u001dA\b!%A\u0005\u0002eD\u0011\"!\u0003\u0001#\u0003%\t!a\u0003\t\u0013\u0005=\u0001!%A\u0005\u0002\u0005-\u0001\"CA\t\u0001E\u0005I\u0011AA\u0006\u0011%\t\u0019\u0002AA\u0001\n\u0003\n)\u0002C\u0005\u0002(\u0001\t\t\u0011\"\u0001\u0002*!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003\u007f\u0001\u0011\u0011!C!\u0003\u0003B\u0011\"a\u0014\u0001\u0003\u0003%\t!!\u0015\t\u0013\u0005U\u0003!!A\u0005B\u0005]s!CA.=\u0005\u0005\t\u0012AA/\r!ib$!A\t\u0002\u0005}\u0003B\u0002+\u0018\t\u0003\ti\u0007C\u0005\u0002p]\t\t\u0011\"\u0012\u0002r!I\u00111O\f\u0002\u0002\u0013\u0005\u0015Q\u000f\u0005\n\u0003\u007f:\u0012\u0011!CA\u0003\u0003C\u0011\"a%\u0018\u0003\u0003%I!!&\u0003!\u0011\u0013x\u000e\u001d+bE2,7i\\7nC:$'BA\u0010!\u0003\u001d\u0019w.\\7b]\u0012T!!\t\u0012\u0002\u0013\u0015DXmY;uS>t'BA\u0012%\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003K\u0019\nQa\u001d9be.T!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sO\u000e\u00011#\u0002\u0001-mi\u0002\u0005CA\u00175\u001b\u0005q#BA\u00181\u0003\u001dawnZ5dC2T!!\r\u001a\u0002\u000bAd\u0017M\\:\u000b\u0005M\u0012\u0013\u0001C2bi\u0006d\u0017p\u001d;\n\u0005Ur#a\u0003'pO&\u001c\u0017\r\u001c)mC:\u0004\"a\u000e\u001d\u000e\u0003yI!!\u000f\u0010\u0003\u001fI+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002<\u0003&\u0011!\t\u0010\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\ni\u0006\u0014G.\u001a(b[\u0016,\u0012!\u0012\t\u0003\r\u001ek\u0011AM\u0005\u0003\u0011J\u0012q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM]\u0001\u000bi\u0006\u0014G.\u001a(b[\u0016\u0004\u0013\u0001C5g\u000bbL7\u000f^:\u0016\u00031\u0003\"aO'\n\u00059c$a\u0002\"p_2,\u0017M\\\u0001\nS\u001a,\u00050[:ug\u0002\na![:WS\u0016<\u0018aB5t-&,w\u000fI\u0001\u0006aV\u0014x-Z\u0001\u0007aV\u0014x-\u001a\u0011\u0002\rqJg.\u001b;?)\u00151v\u000bW-[!\t9\u0004\u0001C\u0003D\u0013\u0001\u0007Q\tC\u0003K\u0013\u0001\u0007A\nC\u0003Q\u0013\u0001\u0007A\nC\u0003S\u0013\u0001\u0007A*A\u0002sk:$\"!X7\u0011\u0007y3\u0017N\u0004\u0002`I:\u0011\u0001mY\u0007\u0002C*\u0011!MK\u0001\u0007yI|w\u000e\u001e \n\u0003uJ!!\u001a\u001f\u0002\u000fA\f7m[1hK&\u0011q\r\u001b\u0002\u0004'\u0016\f(BA3=!\tQ7.D\u0001#\u0013\ta'EA\u0002S_^DQA\u001c\u0006A\u0002=\fAb\u001d9be.\u001cVm]:j_:\u0004\"A\u001b9\n\u0005E\u0014#\u0001D*qCJ\\7+Z:tS>t\u0017\u0001B2paf$RA\u0016;vm^DqaQ\u0006\u0011\u0002\u0003\u0007Q\tC\u0004K\u0017A\u0005\t\u0019\u0001'\t\u000fA[\u0001\u0013!a\u0001\u0019\"9!k\u0003I\u0001\u0002\u0004a\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0002u*\u0012Qi_\u0016\u0002yB\u0019Q0!\u0002\u000e\u0003yT1a`A\u0001\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0004q\n!\"\u00198o_R\fG/[8o\u0013\r\t9A \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u001bQ#\u0001T>\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0012\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011\u0001\u00027b]\u001eT!!!\t\u0002\t)\fg/Y\u0005\u0005\u0003K\tYB\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003W\u00012aOA\u0017\u0013\r\ty\u0003\u0010\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003k\tY\u0004E\u0002<\u0003oI1!!\u000f=\u0005\r\te.\u001f\u0005\n\u0003{\u0011\u0012\u0011!a\u0001\u0003W\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA\"!\u0019\t)%a\u0013\u000265\u0011\u0011q\t\u0006\u0004\u0003\u0013b\u0014AC2pY2,7\r^5p]&!\u0011QJA$\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u00071\u000b\u0019\u0006C\u0005\u0002>Q\t\t\u00111\u0001\u00026\u00051Q-];bYN$2\u0001TA-\u0011%\ti$FA\u0001\u0002\u0004\t)$\u0001\tEe>\u0004H+\u00192mK\u000e{W.\\1oIB\u0011qgF\n\u0005/\u0005\u0005\u0004\tE\u0005\u0002d\u0005%T\t\u0014'M-6\u0011\u0011Q\r\u0006\u0004\u0003Ob\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003W\n)GA\tBEN$(/Y2u\rVt7\r^5p]R\"\"!!\u0018\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0006\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013Y\u000b9(!\u001f\u0002|\u0005u\u0004\"B\"\u001b\u0001\u0004)\u0005\"\u0002&\u001b\u0001\u0004a\u0005\"\u0002)\u001b\u0001\u0004a\u0005\"\u0002*\u001b\u0001\u0004a\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0007\u000by\tE\u0003<\u0003\u000b\u000bI)C\u0002\u0002\br\u0012aa\u00149uS>t\u0007cB\u001e\u0002\f\u0016cE\nT\u0005\u0004\u0003\u001bc$A\u0002+va2,G\u0007\u0003\u0005\u0002\u0012n\t\t\u00111\u0001W\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0018B!\u0011\u0011DAM\u0013\u0011\tY*a\u0007\u0003\r=\u0013'.Z2u\u0001")
public class DropTableCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final boolean ifExists;
    private final boolean isView;
    private final boolean purge;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple4<TableIdentifier, Object, Object, Object>> unapply(DropTableCommand dropTableCommand) {
        return DropTableCommand$.MODULE$.unapply(dropTableCommand);
    }

    public static Function1<Tuple4<TableIdentifier, Object, Object, Object>, DropTableCommand> tupled() {
        return DropTableCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Object, Function1<Object, Function1<Object, DropTableCommand>>>> curried() {
        return DropTableCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DropTableCommand dropTableCommand = this;
        synchronized (dropTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public boolean ifExists() {
        return this.ifExists;
    }

    public boolean isView() {
        return this.isView;
    }

    public boolean purge() {
        return this.purge;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        boolean isTempView = catalog.isTemporaryTable(this.tableName());
        if (!isTempView && catalog.tableExists(this.tableName())) {
            CatalogTableType catalogTableType = catalog.getTableMetadata(this.tableName()).tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            CatalogTableType catalogTableType3 = catalogTableType;
            if (!(catalogTableType2 != null ? !catalogTableType2.equals(catalogTableType3) : catalogTableType3 != null) && !this.isView()) {
                throw new AnalysisException("Cannot drop a view with DROP TABLE. Please use DROP VIEW instead", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            CatalogTableType catalogTableType4 = catalogTableType;
            CatalogTableType catalogTableType5 = CatalogTableType$.MODULE$.VIEW();
            if ((catalogTableType4 == null ? catalogTableType5 != null : !catalogTableType4.equals(catalogTableType5)) && this.isView()) {
                throw new AnalysisException("Cannot drop a table with DROP VIEW. Please use DROP TABLE instead", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (isTempView || catalog.tableExists(this.tableName())) {
            try {
                sparkSession.sharedState().cacheManager().uncacheQuery(sparkSession.table(this.tableName()), !isTempView);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.log().warn(e.toString(), e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
            catalog.refreshTable(this.tableName());
            catalog.dropTable(this.tableName(), this.ifExists(), this.purge());
        } else if (!this.ifExists()) {
            throw new AnalysisException(new StringBuilder(25).append("Table or view not found: ").append(this.tableName().identifier()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public DropTableCommand copy(TableIdentifier tableName, boolean ifExists, boolean isView, boolean purge) {
        return new DropTableCommand(tableName, ifExists, isView, purge);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public boolean copy$default$2() {
        return this.ifExists();
    }

    public boolean copy$default$3() {
        return this.isView();
    }

    public boolean copy$default$4() {
        return this.purge();
    }

    public String productPrefix() {
        return "DropTableCommand";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifExists());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isView());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.purge());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DropTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DropTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DropTableCommand dropTableCommand = (DropTableCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = dropTableCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        if (this.ifExists() != dropTableCommand.ifExists()) return false;
        if (this.isView() != dropTableCommand.isView()) return false;
        if (this.purge() != dropTableCommand.purge()) return false;
        if (!dropTableCommand.canEqual(this)) return false;
        return true;
    }

    public DropTableCommand(TableIdentifier tableName, boolean ifExists, boolean isView, boolean purge) {
        this.tableName = tableName;
        this.ifExists = ifExists;
        this.isView = isView;
        this.purge = purge;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

