/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.adaptive;

import java.io.Serializable;
import org.apache.spark.MapOutputStatistics;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.CoalescedShuffleReaderExec;
import org.apache.spark.sql.execution.adaptive.LocalShuffleReaderExec;
import org.apache.spark.sql.execution.adaptive.QueryStageExec;
import org.apache.spark.sql.execution.adaptive.ReduceNumShufflePartitions$;
import org.apache.spark.sql.execution.adaptive.ReusedQueryStageExec;
import org.apache.spark.sql.execution.adaptive.ShuffleQueryStageExec;
import org.apache.spark.sql.execution.adaptive.ShuffleQueryStageExec$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.util.ThreadUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001B\f\u0019\u0001\u0016B\u0001b\u000f\u0001\u0003\u0016\u0004%\t\u0001\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005{!)A\t\u0001C\u0001\u000b\")\u0011\n\u0001C!\u0015\"1Q\n\u0001C\u000199Cq\u0001\u0018\u0001\u0002\u0002\u0013\u0005Q\fC\u0004`\u0001E\u0005I\u0011\u00011\t\u000f-\u0004\u0011\u0011!C!Y\"9Q\u000fAA\u0001\n\u00031\bbB<\u0001\u0003\u0003%\t\u0001\u001f\u0005\b}\u0002\t\t\u0011\"\u0011\u0000\u0011%\ti\u0001AA\u0001\n\u0003\ty\u0001C\u0005\u0002\u001a\u0001\t\t\u0011\"\u0011\u0002\u001c!I\u0011Q\u0004\u0001\u0002\u0002\u0013\u0005\u0013q\u0004\u0005\n\u0003C\u0001\u0011\u0011!C!\u0003G9\u0011\"a\n\u0019\u0003\u0003E\t!!\u000b\u0007\u0011]A\u0012\u0011!E\u0001\u0003WAa\u0001R\t\u0005\u0002\u0005e\u0002\"CA\u000f#\u0005\u0005IQIA\u0010\u0011!I\u0015#!A\u0005\u0002\u0006m\u0002\"CA #\u0005\u0005I\u0011QA!\u0011%\ti%EA\u0001\n\u0013\tyE\u0001\u000eSK\u0012,8-\u001a(v[NCWO\u001a4mKB\u000b'\u000f^5uS>t7O\u0003\u0002\u001a5\u0005A\u0011\rZ1qi&4XM\u0003\u0002\u001c9\u0005IQ\r_3dkRLwN\u001c\u0006\u0003;y\t1a]9m\u0015\ty\u0002%A\u0003ta\u0006\u00148N\u0003\u0002\"E\u00051\u0011\r]1dQ\u0016T\u0011aI\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0019\u0012\u0004\bE\u0002(Y9j\u0011\u0001\u000b\u0006\u0003S)\nQA];mKNT!a\u000b\u000f\u0002\u0011\r\fG/\u00197zgRL!!\f\u0015\u0003\tI+H.\u001a\t\u0003_Aj\u0011AG\u0005\u0003ci\u0011\u0011b\u00159be.\u0004F.\u00198\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\u000fA\u0013x\u000eZ;diB\u00111'O\u0005\u0003uQ\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fAaY8oMV\tQ\b\u0005\u0002?\u00036\tqH\u0003\u0002A9\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002C\u007f\t91+\u0015'D_:4\u0017!B2p]\u001a\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002G\u0011B\u0011q\tA\u0007\u00021!)1h\u0001a\u0001{\u0005)\u0011\r\u001d9msR\u0011af\u0013\u0005\u0006\u0019\u0012\u0001\rAL\u0001\u0005a2\fg.A\u000ffgRLW.\u0019;f!\u0006\u0014H/\u001b;j_:\u001cF/\u0019:u\u0013:$\u0017nY3t)\tyU\u000bE\u00024!JK!!\u0015\u001b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005M\u001a\u0016B\u0001+5\u0005\rIe\u000e\u001e\u0005\u0006-\u0016\u0001\raV\u0001\u0014[\u0006\u0004x*\u001e;qkR\u001cF/\u0019;jgRL7m\u001d\t\u0004gAC\u0006CA-[\u001b\u0005q\u0012BA.\u001f\u0005Mi\u0015\r](viB,Ho\u0015;bi&\u001cH/[2t\u0003\u0011\u0019w\u000e]=\u0015\u0005\u0019s\u0006bB\u001e\u0007!\u0003\u0005\r!P\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005\t'FA\u001fcW\u0005\u0019\u0007C\u00013j\u001b\u0005)'B\u00014h\u0003%)hn\u00195fG.,GM\u0003\u0002ii\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005),'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\u0012!\u001c\t\u0003]Nl\u0011a\u001c\u0006\u0003aF\fA\u0001\\1oO*\t!/\u0001\u0003kCZ\f\u0017B\u0001;p\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\t!+\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0005ed\bCA\u001a{\u0013\tYHGA\u0002B]fDq! \u0006\u0002\u0002\u0003\u0007!+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0003\u0001R!a\u0001\u0002\nel!!!\u0002\u000b\u0007\u0005\u001dA'\u0001\u0006d_2dWm\u0019;j_:LA!a\u0003\u0002\u0006\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\t\t\"a\u0006\u0011\u0007M\n\u0019\"C\u0002\u0002\u0016Q\u0012qAQ8pY\u0016\fg\u000eC\u0004~\u0019\u0005\u0005\t\u0019A=\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012AU\u0001\ti>\u001cFO]5oOR\tQ.\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003#\t)\u0003C\u0004~\u001f\u0005\u0005\t\u0019A=\u00025I+G-^2f\u001dVl7\u000b[;gM2,\u0007+\u0019:uSRLwN\\:\u0011\u0005\u001d\u000b2\u0003B\t\u0002.a\u0002b!a\f\u00026u2UBAA\u0019\u0015\r\t\u0019\u0004N\u0001\beVtG/[7f\u0013\u0011\t9$!\r\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0002*Q\u0019a)!\u0010\t\u000bm\"\u0002\u0019A\u001f\u0002\u000fUt\u0017\r\u001d9msR!\u00111IA%!\u0011\u0019\u0014QI\u001f\n\u0007\u0005\u001dCG\u0001\u0004PaRLwN\u001c\u0005\t\u0003\u0017*\u0012\u0011!a\u0001\r\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003#\u00022A\\A*\u0013\r\t)f\u001c\u0002\u0007\u001f\nTWm\u0019;")
public class ReduceNumShufflePartitions
extends Rule<SparkPlan>
implements Product,
scala.Serializable {
    private final SQLConf conf;

    public static Option<SQLConf> unapply(ReduceNumShufflePartitions reduceNumShufflePartitions) {
        return ReduceNumShufflePartitions$.MODULE$.unapply(reduceNumShufflePartitions);
    }

    public static <A> Function1<SQLConf, A> andThen(Function1<ReduceNumShufflePartitions, A> function1) {
        return ReduceNumShufflePartitions$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, ReduceNumShufflePartitions> compose(Function1<A, SQLConf> function1) {
        return ReduceNumShufflePartitions$.MODULE$.compose(function1);
    }

    public SQLConf conf() {
        return this.conf;
    }

    public SparkPlan apply(SparkPlan plan) {
        SparkPlan sparkPlan;
        if (!this.conf().reducePostShufflePartitionsEnabled()) {
            return plan;
        }
        if (!plan.collectLeaves().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReduceNumShufflePartitions.$anonfun$apply$1(x$1)))) {
            return plan;
        }
        Seq shuffleStages = ReduceNumShufflePartitions.collectShuffleStages$1(plan);
        if (!shuffleStages.forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReduceNumShufflePartitions.$anonfun$apply$3(x$2)))) {
            sparkPlan = plan;
        } else {
            Seq shuffleMetrics = (Seq)shuffleStages.map((Function1 & Serializable & scala.Serializable)stage -> {
                Future<MapOutputStatistics> metricsFuture = stage.plan().mapOutputStatisticsFuture();
                Predef$.MODULE$.assert(metricsFuture.isCompleted(), (Function0 & Serializable & scala.Serializable)() -> "ShuffleQueryStageExec should already be ready");
                return (MapOutputStatistics)ThreadUtils$.MODULE$.awaitResult(metricsFuture, (Duration)Duration$.MODULE$.Zero());
            }, Seq$.MODULE$.canBuildFrom());
            Seq validMetrics = (Seq)shuffleMetrics.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReduceNumShufflePartitions.$anonfun$apply$6(x$3)));
            Seq distinctNumPreShufflePartitions = (Seq)((SeqLike)validMetrics.map((Function1 & Serializable & scala.Serializable)stats -> BoxesRunTime.boxToInteger((int)ReduceNumShufflePartitions.$anonfun$apply$7(stats)), Seq$.MODULE$.canBuildFrom())).distinct();
            if (validMetrics.nonEmpty() && distinctNumPreShufflePartitions.length() == 1) {
                int[] partitionStartIndices = this.estimatePartitionStartIndices((MapOutputStatistics[])validMetrics.toArray(ClassTag$.MODULE$.apply(MapOutputStatistics.class)));
                sparkPlan = (SparkPlan)plan.transformUp((PartialFunction)new scala.Serializable(null, partitionStartIndices){
                    public static final long serialVersionUID = 0L;
                    private final int[] partitionStartIndices$1;

                    public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        QueryStageExec queryStageExec;
                        A1 A1 = x1;
                        Object object = A1 instanceof QueryStageExec && ShuffleQueryStageExec$.MODULE$.isShuffleQueryStageExec(queryStageExec = (QueryStageExec)A1) ? new CoalescedShuffleReaderExec(queryStageExec, this.partitionStartIndices$1) : function1.apply(x1);
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(SparkPlan x1) {
                        QueryStageExec queryStageExec;
                        SparkPlan sparkPlan = x1;
                        boolean bl = sparkPlan instanceof QueryStageExec && ShuffleQueryStageExec$.MODULE$.isShuffleQueryStageExec(queryStageExec = (QueryStageExec)sparkPlan);
                        return bl;
                    }
                    {
                        this.partitionStartIndices$1 = partitionStartIndices$1;
                    }
                });
            } else {
                sparkPlan = plan;
            }
        }
        return sparkPlan;
    }

    public int[] estimatePartitionStartIndices(MapOutputStatistics[] mapOutputStatistics) {
        int minNumPostShufflePartitions = this.conf().minNumPostShufflePartitions();
        long advisoryTargetPostShuffleInputSize = this.conf().targetPostShuffleInputSize();
        long totalPostShuffleInputSize = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapOutputStatistics)).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)ReduceNumShufflePartitions.$anonfun$estimatePartitionStartIndices$1(x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long maxPostShuffleInputSize = package$.MODULE$.max((long)package$.MODULE$.ceil((double)totalPostShuffleInputSize / (double)minNumPostShufflePartitions), 16L);
        long targetPostShuffleInputSize = package$.MODULE$.min(maxPostShuffleInputSize, advisoryTargetPostShuffleInputSize);
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("advisoryTargetPostShuffleInputSize: ").append(advisoryTargetPostShuffleInputSize).append(", ").append("targetPostShuffleInputSize ").append(targetPostShuffleInputSize).append(".").toString());
        int[] distinctNumPreShufflePartitions = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mapOutputStatistics)).map((Function1 & Serializable & scala.Serializable)stats -> BoxesRunTime.boxToInteger((int)ReduceNumShufflePartitions.$anonfun$estimatePartitionStartIndices$3(stats)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).distinct();
        Predef$.MODULE$.assert(distinctNumPreShufflePartitions.length == 1, (Function0 & Serializable & scala.Serializable)() -> "There should be only one distinct value of the number pre-shuffle partitions among registered Exchange operator.");
        int numPreShufflePartitions = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(distinctNumPreShufflePartitions)).head());
        ArrayBuffer partitionStartIndices = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        partitionStartIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)0));
        long postShuffleInputSize = 0L;
        for (int i = 0; i < numPreShufflePartitions; ++i) {
            long nextShuffleInputSize = 0L;
            for (int j = 0; j < mapOutputStatistics.length; ++j) {
                nextShuffleInputSize += mapOutputStatistics[j].bytesByPartitionId()[i];
            }
            if (i > 0 && postShuffleInputSize + nextShuffleInputSize > targetPostShuffleInputSize) {
                partitionStartIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                postShuffleInputSize = nextShuffleInputSize;
                continue;
            }
            postShuffleInputSize += nextShuffleInputSize;
        }
        return (int[])partitionStartIndices.toArray(ClassTag$.MODULE$.Int());
    }

    public ReduceNumShufflePartitions copy(SQLConf conf) {
        return new ReduceNumShufflePartitions(conf);
    }

    public SQLConf copy$default$1() {
        return this.conf();
    }

    public String productPrefix() {
        return "ReduceNumShufflePartitions";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.conf();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ReduceNumShufflePartitions;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ReduceNumShufflePartitions)) return false;
        boolean bl = true;
        if (!bl) return false;
        ReduceNumShufflePartitions reduceNumShufflePartitions = (ReduceNumShufflePartitions)((Object)x$1);
        SQLConf sQLConf = this.conf();
        SQLConf sQLConf2 = reduceNumShufflePartitions.conf();
        if (sQLConf == null) {
            if (sQLConf2 != null) {
                return false;
            }
        } else if (!sQLConf.equals(sQLConf2)) return false;
        if (!reduceNumShufflePartitions.canEqual((Object)this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(SparkPlan x$1) {
        return x$1 instanceof QueryStageExec;
    }

    private static final Seq collectShuffleStages$1(SparkPlan plan2) {
        ReusedQueryStageExec reusedQueryStageExec;
        QueryStageExec stage;
        Nil$ nil$;
        SparkPlan sparkPlan = plan2;
        if (sparkPlan instanceof LocalShuffleReaderExec) {
            nil$ = Nil$.MODULE$;
        } else if (sparkPlan instanceof ShuffleQueryStageExec) {
            ShuffleQueryStageExec shuffleQueryStageExec = (ShuffleQueryStageExec)sparkPlan;
            nil$ = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ShuffleQueryStageExec[]{shuffleQueryStageExec}));
        } else if (sparkPlan instanceof ReusedQueryStageExec && (stage = (reusedQueryStageExec = (ReusedQueryStageExec)sparkPlan).plan()) instanceof ShuffleQueryStageExec) {
            ShuffleQueryStageExec shuffleQueryStageExec = (ShuffleQueryStageExec)stage;
            nil$ = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ShuffleQueryStageExec[]{shuffleQueryStageExec}));
        } else {
            nil$ = (Seq)plan2.children().flatMap((Function1 & Serializable & scala.Serializable)plan -> ReduceNumShufflePartitions.collectShuffleStages$1(plan), Seq$.MODULE$.canBuildFrom());
        }
        return nil$;
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(ShuffleQueryStageExec x$2) {
        return x$2.plan().canChangeNumPartitions();
    }

    public static final /* synthetic */ boolean $anonfun$apply$6(MapOutputStatistics x$3) {
        return x$3 != null;
    }

    public static final /* synthetic */ int $anonfun$apply$7(MapOutputStatistics stats) {
        return stats.bytesByPartitionId().length;
    }

    public static final /* synthetic */ long $anonfun$estimatePartitionStartIndices$1(MapOutputStatistics x$4) {
        return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$4.bytesByPartitionId())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ int $anonfun$estimatePartitionStartIndices$3(MapOutputStatistics stats) {
        return stats.bytesByPartitionId().length;
    }

    public ReduceNumShufflePartitions(SQLConf conf) {
        this.conf = conf;
        Product.$init$((Product)this);
    }
}

